/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.orchestrator.listeners;

import android.os.Bundle;
import android.support.test.orchestrator.junit.ParcelableDescription;
import android.support.test.orchestrator.junit.ParcelableFailure;
import android.support.test.orchestrator.listeners.OrchestrationResult;
import android.support.test.orchestrator.listeners.OrchestrationRunListener;
import android.support.test.orchestrator.listeners.TextListener;
import android.util.Log;
import java.io.PrintStream;

public class OrchestrationResultPrinter
extends OrchestrationRunListener {
    private static final String LOG_TAG = "OdoInstrResultPrinter";
    public static final String REPORT_VALUE_ID = "AndroidJUnitRunner";
    public static final String REPORT_KEY_NUM_TOTAL = "numtests";
    public static final String REPORT_KEY_NUM_CURRENT = "current";
    public static final String REPORT_KEY_NAME_CLASS = "class";
    public static final String REPORT_KEY_NAME_TEST = "test";
    public static final int REPORT_VALUE_RESULT_START = 1;
    public static final int REPORT_VALUE_RESULT_OK = 0;
    @Deprecated
    public static final int REPORT_VALUE_RESULT_ERROR = -1;
    public static final int REPORT_VALUE_RESULT_FAILURE = -2;
    public static final int REPORT_VALUE_RESULT_IGNORED = -3;
    public static final int REPORT_VALUE_RESULT_ASSUMPTION_FAILURE = -4;
    public static final String REPORT_KEY_STACK = "stack";
    private final Bundle mResultTemplate = new Bundle();
    private Bundle mTestResult = new Bundle(this.mResultTemplate);
    int mTestNum = 0;
    int mTestResultCode = -999;
    String mTestClass = null;
    private ParcelableDescription mDescription;

    @Override
    public void orchestrationRunStarted(int testCount) {
        this.mResultTemplate.putString("id", REPORT_VALUE_ID);
        this.mResultTemplate.putInt(REPORT_KEY_NUM_TOTAL, testCount);
    }

    @Override
    public void testStarted(ParcelableDescription description) {
        this.mDescription = description;
        String testClass = description.getClassName();
        String testName = description.getMethodName();
        this.mTestResult = new Bundle(this.mResultTemplate);
        this.mTestResult.putString(REPORT_KEY_NAME_CLASS, testClass);
        this.mTestResult.putString(REPORT_KEY_NAME_TEST, testName);
        this.mTestResult.putInt(REPORT_KEY_NUM_CURRENT, ++this.mTestNum);
        if (testClass != null && !testClass.equals(this.mTestClass)) {
            this.mTestResult.putString("stream", String.format("\n%s:", testClass));
            this.mTestClass = testClass;
        } else {
            this.mTestResult.putString("stream", "");
        }
        this.sendStatus(1, this.mTestResult);
        this.mTestResultCode = 0;
    }

    @Override
    public void testFinished(ParcelableDescription description) {
        if (this.mTestResultCode == 0) {
            this.mTestResult.putString("stream", ".");
        }
        this.sendStatus(this.mTestResultCode, this.mTestResult);
    }

    @Override
    public void testFailure(ParcelableFailure failure) {
        this.mTestResultCode = -2;
        this.reportFailure(failure);
    }

    @Override
    public void testAssumptionFailure(ParcelableFailure failure) {
        this.mTestResultCode = -4;
        this.mTestResult.putString(REPORT_KEY_STACK, failure.getTrace());
    }

    private void reportFailure(ParcelableFailure failure) {
        this.mTestResult.putString(REPORT_KEY_STACK, failure.getTrace());
        this.mTestResult.putString("stream", String.format("\nError in %s:\n%s", failure.getDescription().getDisplayName(), failure.getTrace()));
    }

    @Override
    public void testIgnored(ParcelableDescription description) {
        this.testStarted(description);
        this.mTestResultCode = -3;
        this.testFinished(description);
    }

    public void reportProcessCrash(Throwable t) {
        try {
            this.mTestResultCode = -2;
            ParcelableFailure failure = new ParcelableFailure(this.mDescription, t);
            this.mTestResult.putString(REPORT_KEY_STACK, failure.getTrace());
            this.mTestResult.putString("stream", String.format("\nProcess crashed while executing %s:\n%s", this.mDescription.getDisplayName(), failure.getTrace()));
            this.testFinished(this.mDescription);
        }
        catch (Exception e) {
            if (null == this.mDescription) {
                Log.e((String)LOG_TAG, (String)"Failed to initialize test before process crash");
            }
            String string = this.mDescription.getDisplayName();
            Log.e((String)LOG_TAG, (String)new StringBuilder(52 + String.valueOf(string).length()).append("Failed to mark test ").append(string).append(" as finished after process crash").toString());
        }
    }

    public void sendStatus(int code, Bundle bundle) {
        this.getInstrumentation().sendStatus(code, bundle);
    }

    public void orchestrationRunFinished(PrintStream streamResult, OrchestrationResult orchestrationResults) {
        new TextListener(streamResult).testRunFinished(orchestrationResults);
    }
}

