/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.orchestrator.instrumentationlistener;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.test.orchestrator.callback.OrchestratorCallback;
import android.support.test.orchestrator.junit.BundleJUnitUtils;
import android.support.test.orchestrator.listeners.OrchestrationListenerManager;
import android.util.Log;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public final class OrchestratedInstrumentationListener
extends RunListener {
    private static final String TAG = "OrchestrationListener";
    private static final String ORCHESTRATOR_PACKAGE = "android.support.test.orchestrator";
    private static final String ODO_SERVICE_PACKAGE = "android.support.test.orchestrator.OrchestratorService";
    private final OnConnectListener listener;
    OrchestratorCallback odoCallback;
    private final ServiceConnection connection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            OrchestratedInstrumentationListener.this.odoCallback = OrchestratorCallback.Stub.asInterface(service);
            Log.i((String)OrchestratedInstrumentationListener.TAG, (String)"OrchestrationListener connected to service");
            OrchestratedInstrumentationListener.this.listener.onOrchestratorConnect();
        }

        public void onServiceDisconnected(ComponentName className) {
            OrchestratedInstrumentationListener.this.odoCallback = null;
            Log.i((String)OrchestratedInstrumentationListener.TAG, (String)"OrchestrationListener disconnected from service");
        }
    };

    public OrchestratedInstrumentationListener(OnConnectListener listener) {
        this.listener = listener;
    }

    public void connect(Context context) {
        Intent intent = new Intent(ODO_SERVICE_PACKAGE);
        intent.setPackage(ORCHESTRATOR_PACKAGE);
        if (!context.bindService(intent, this.connection, 1)) {
            throw new RuntimeException("Cannot connect to android.support.test.orchestrator.OrchestratorService");
        }
    }

    public void testRunStarted(Description description) {
        try {
            this.sendTestNotification(OrchestrationListenerManager.TestEvent.TEST_RUN_STARTED, BundleJUnitUtils.getBundleFromDescription(description));
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to send TestRunStarted Status to Orchestrator", (Throwable)e);
        }
    }

    public void testRunFinished(Result result) {
        try {
            this.sendTestNotification(OrchestrationListenerManager.TestEvent.TEST_RUN_FINISHED, BundleJUnitUtils.getBundleFromResult(result));
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to send TestRunFinished Status to Orchestrator", (Throwable)e);
        }
    }

    public void testStarted(Description description) {
        try {
            this.sendTestNotification(OrchestrationListenerManager.TestEvent.TEST_STARTED, BundleJUnitUtils.getBundleFromDescription(description));
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to send TestStarted Status to Orchestrator", (Throwable)e);
        }
    }

    public void testFinished(Description description) {
        try {
            this.sendTestNotification(OrchestrationListenerManager.TestEvent.TEST_FINISHED, BundleJUnitUtils.getBundleFromDescription(description));
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to send TestFinished Status to Orchestrator", (Throwable)e);
        }
    }

    public void testFailure(Failure failure) {
        try {
            this.sendTestNotification(OrchestrationListenerManager.TestEvent.TEST_FAILURE, BundleJUnitUtils.getBundleFromFailure(failure));
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Unable to send TestFailure status, terminating", e);
        }
    }

    public void testAssumptionFailure(Failure failure) {
        try {
            this.sendTestNotification(OrchestrationListenerManager.TestEvent.TEST_ASSUMPTION_FAILURE, BundleJUnitUtils.getBundleFromFailure(failure));
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Unable to send TestAssumptionFailure status, terminating", e);
        }
    }

    public void testIgnored(Description description) {
        try {
            this.sendTestNotification(OrchestrationListenerManager.TestEvent.TEST_IGNORED, BundleJUnitUtils.getBundleFromDescription(description));
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to send TestIgnored Status to Orchestrator", (Throwable)e);
        }
    }

    public void sendTestNotification(OrchestrationListenerManager.TestEvent type, Bundle bundle) throws RemoteException {
        if (null == this.odoCallback) {
            throw new IllegalStateException("Unable to send notification, callback is null");
        }
        bundle.putString("TestEvent", type.toString());
        this.odoCallback.sendTestNotification(bundle);
    }

    public void addTests(Description description) {
        if (description.isTest()) {
            String string = description.getClassName();
            String string2 = description.getMethodName();
            this.addTest(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("#").append(string2).toString());
        } else {
            for (Description child : description.getChildren()) {
                this.addTests(child);
            }
        }
    }

    public void addTest(String test) {
        if (null == this.odoCallback) {
            throw new IllegalStateException("Unable to send test, callback is null");
        }
        try {
            this.odoCallback.addTest(test);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to send test", (Throwable)e);
        }
    }

    public static interface OnConnectListener {
        public void onOrchestratorConnect();
    }
}

