/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner.tracker;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.SystemClock;
import android.support.test.internal.runner.tracker.UsageTracker;
import android.support.test.internal.util.Checks;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class AnalyticsBasedUsageTracker
implements UsageTracker {
    private static final String TAG = "InfraTrack";
    private static final String UTF_8 = "UTF-8";
    private static final String APP_NAME_PARAM = "an=";
    private static final String SCREEN_NAME_PARAM = "&cd=";
    private static final String APP_VERSION_PARAM = "&av=";
    private static final String TRACKER_ID_PARAM = "&tid=";
    private static final String CLIENT_ID_PARAM = "&cid=";
    private static final String SCREEN_RESOLUTION_PARAM = "&sr=";
    private static final String API_LEVEL_PARAM = "&cd2=";
    private static final String MODEL_NAME_PARAM = "&cd3=";
    private final String trackingId;
    private final String targetPackage;
    private final URL analyticsURI;
    private final String screenResolution;
    private final String apiLevel;
    private final String model;
    private final String userId;
    private final Map<String, String> usageTypeToVersion = new HashMap<String, String>();

    private AnalyticsBasedUsageTracker(Builder builder) {
        this.trackingId = Checks.checkNotNull(builder.trackingId);
        this.targetPackage = Checks.checkNotNull(builder.targetPackage);
        this.analyticsURI = Checks.checkNotNull(builder.analyticsURI);
        this.apiLevel = Checks.checkNotNull(builder.apiLevel);
        this.model = Checks.checkNotNull(builder.model);
        this.screenResolution = Checks.checkNotNull(builder.screenResolution);
        this.userId = Checks.checkNotNull(builder.userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trackUsage(String usageType, String version) {
        Map<String, String> map = this.usageTypeToVersion;
        synchronized (map) {
            this.usageTypeToVersion.put(usageType, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendUsages() {
        HashMap<String, String> myUsages;
        Map<String, String> map = this.usageTypeToVersion;
        synchronized (map) {
            if (this.usageTypeToVersion.isEmpty()) {
                return;
            }
            myUsages = new HashMap<String, String>(this.usageTypeToVersion);
            this.usageTypeToVersion.clear();
        }
        String baseBody = null;
        try {
            baseBody = APP_NAME_PARAM + URLEncoder.encode(this.targetPackage, UTF_8) + TRACKER_ID_PARAM + URLEncoder.encode(this.trackingId, UTF_8) + "&v=1" + "&z=" + SystemClock.uptimeMillis() + CLIENT_ID_PARAM + URLEncoder.encode(this.userId, UTF_8) + SCREEN_RESOLUTION_PARAM + URLEncoder.encode(this.screenResolution, UTF_8) + API_LEVEL_PARAM + URLEncoder.encode(this.apiLevel, UTF_8) + MODEL_NAME_PARAM + URLEncoder.encode(this.model, UTF_8) + "&t=appview" + "&sc=start";
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (String)"Impossible error happened. analytics disabled.", (Throwable)ioe);
        }
        for (Map.Entry usage : myUsages.entrySet()) {
            HttpURLConnection analyticsConnection = null;
            try {
                analyticsConnection = (HttpURLConnection)this.analyticsURI.openConnection();
                byte[] body = (baseBody + SCREEN_NAME_PARAM + URLEncoder.encode((String)usage.getKey(), UTF_8) + APP_VERSION_PARAM + URLEncoder.encode((String)usage.getValue(), UTF_8)).getBytes();
                analyticsConnection.setConnectTimeout(3000);
                analyticsConnection.setReadTimeout(5000);
                analyticsConnection.setDoOutput(true);
                analyticsConnection.setFixedLengthStreamingMode(body.length);
                analyticsConnection.getOutputStream().write(body);
                int status = analyticsConnection.getResponseCode();
                if (status / 100 == 2) continue;
                String string = String.valueOf(usage);
                int n = analyticsConnection.getResponseCode();
                String string2 = analyticsConnection.getResponseMessage();
                Log.w((String)TAG, (String)new StringBuilder(45 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Analytics post: ").append(string).append(" failed. code: ").append(n).append(" - ").append(string2).toString());
            }
            catch (IOException ioe) {
                String string = String.valueOf(usage);
                Log.w((String)TAG, (String)new StringBuilder(25 + String.valueOf(string).length()).append("Analytics post: ").append(string).append(" failed. ").toString(), (Throwable)ioe);
            }
            finally {
                if (null == analyticsConnection) continue;
                analyticsConnection.disconnect();
            }
        }
    }

    public static class Builder {
        private final Context targetContext;
        private Uri analyticsUri = new Uri.Builder().scheme("https").authority("www.google-analytics.com").path("collect").build();
        private String trackingId = "UA-36650409-3";
        private String apiLevel = String.valueOf(Build.VERSION.SDK_INT);
        private String model = Build.MODEL;
        private String targetPackage;
        private URL analyticsURI;
        private String screenResolution;
        private String userId;
        private boolean hashed;

        public Builder(Context targetContext) {
            if (targetContext == null) {
                throw new NullPointerException("Context null!?");
            }
            this.targetContext = targetContext;
        }

        public Builder withTrackingId(String trackingId) {
            this.trackingId = trackingId;
            return this;
        }

        public Builder withAnalyticsUri(Uri analyticsUri) {
            Checks.checkNotNull(analyticsUri);
            this.analyticsUri = analyticsUri;
            return this;
        }

        public Builder withApiLevel(String apiLevel) {
            this.apiLevel = apiLevel;
            return this;
        }

        public Builder withScreenResolution(String resolutionVal) {
            this.screenResolution = resolutionVal;
            return this;
        }

        public Builder withUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder withModel(String model) {
            this.model = model;
            return this;
        }

        public Builder withTargetPackage(String targetPackage) {
            this.hashed = false;
            this.targetPackage = targetPackage;
            return this;
        }

        public UsageTracker buildIfPossible() {
            if (!this.hasInternetPermission()) {
                Log.d((String)AnalyticsBasedUsageTracker.TAG, (String)"Tracking disabled due to lack of internet permissions");
                return null;
            }
            if (null == this.targetPackage) {
                this.withTargetPackage(this.targetContext.getPackageName());
            }
            if (this.targetPackage.contains("com.google.analytics")) {
                Log.d((String)AnalyticsBasedUsageTracker.TAG, (String)"Refusing to use analytics while testing analytics.");
                return null;
            }
            try {
                if (!(this.targetPackage.startsWith("com.google.") || this.targetPackage.startsWith("com.android.") || this.targetPackage.startsWith("android.support."))) {
                    if (!this.hashed) {
                        MessageDigest digest = MessageDigest.getInstance("SHA-256");
                        digest.reset();
                        digest.update(this.targetPackage.getBytes(AnalyticsBasedUsageTracker.UTF_8));
                        BigInteger hashedPackage = new BigInteger(digest.digest());
                        String string = String.valueOf(hashedPackage.toString(16));
                        this.targetPackage = string.length() != 0 ? "sha256-".concat(string) : new String("sha256-");
                    }
                    this.hashed = true;
                }
            }
            catch (NoSuchAlgorithmException nsae) {
                Log.d((String)AnalyticsBasedUsageTracker.TAG, (String)"Cannot hash package name.", (Throwable)nsae);
                return null;
            }
            catch (UnsupportedEncodingException uee) {
                Log.d((String)AnalyticsBasedUsageTracker.TAG, (String)"Impossible - no utf-8 encoding?", (Throwable)uee);
                return null;
            }
            try {
                this.analyticsURI = new URL(this.analyticsUri.toString());
            }
            catch (MalformedURLException mule) {
                String string = String.valueOf(this.analyticsUri.toString());
                Log.w((String)AnalyticsBasedUsageTracker.TAG, (String)(string.length() != 0 ? "Tracking disabled bad url: ".concat(string) : new String("Tracking disabled bad url: ")), (Throwable)mule);
                return null;
            }
            if (null == this.screenResolution) {
                Display display = ((WindowManager)this.targetContext.getSystemService("window")).getDefaultDisplay();
                this.screenResolution = null == display ? "0x0" : display.getWidth() + "x" + display.getHeight();
            }
            if (null == this.userId) {
                this.userId = UUID.randomUUID().toString();
            }
            return new AnalyticsBasedUsageTracker(this);
        }

        private boolean hasInternetPermission() {
            return 0 == this.targetContext.checkCallingOrSelfPermission("android.permission.INTERNET");
        }
    }
}

