/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner;

import android.app.Instrumentation;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import android.support.test.filters.RequiresDevice;
import android.support.test.filters.SdkSuppress;
import android.support.test.filters.Suppress;
import android.support.test.internal.runner.AndroidLogOnlyBuilder;
import android.support.test.internal.runner.AndroidRunnerBuilder;
import android.support.test.internal.runner.ClassPathScanner;
import android.support.test.internal.runner.RunnerArgs;
import android.support.test.internal.runner.TestLoader;
import android.support.test.internal.runner.TestSize;
import android.support.test.internal.util.AndroidRunnerParams;
import android.support.test.internal.util.Checks;
import android.util.Log;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class TestRequestBuilder {
    private static final String TAG = "TestRequestBuilder";
    private static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"junit", "org.junit", "org.hamcrest", "org.mockito", "android.support.test.internal.runner.junit3", "org.jacoco", "net.bytebuddy"};
    static final String MISSING_ARGUMENTS_MSG = "Must provide either classes to run, or apks to scan";
    static final String AMBIGUOUS_ARGUMENTS_MSG = "Ambiguous arguments: cannot provide both test package and test class(es) to run";
    private List<String> mApkPaths = new ArrayList<String>();
    private Set<String> mIncludedPackages = new HashSet<String>();
    private Set<String> mExcludedPackages = new HashSet<String>();
    private Set<String> mIncludedClasses = new HashSet<String>();
    private Set<String> mExcludedClasses = new HashSet<String>();
    private ClassAndMethodFilter mClassMethodFilter = new ClassAndMethodFilter();
    private Filter mFilter = new AnnotationExclusionFilter(Suppress.class).intersect(new AnnotationExclusionFilter(android.test.suitebuilder.annotation.Suppress.class)).intersect((Filter)new SdkSuppressFilter()).intersect((Filter)new RequiresDeviceFilter()).intersect((Filter)this.mClassMethodFilter);
    private List<Class<? extends RunnerBuilder>> customRunnerBuilderClasses = new ArrayList<Class<? extends RunnerBuilder>>();
    private boolean mSkipExecution = false;
    private final DeviceBuild mDeviceBuild;
    private long mPerTestTimeout = 0L;
    private final Instrumentation mInstr;
    private final Bundle mArgsBundle;
    private ClassLoader mClassLoader;
    private boolean mIgnoreSuiteMethods = false;

    public TestRequestBuilder(Instrumentation instr, Bundle bundle) {
        this(new DeviceBuildImpl(), instr, bundle);
    }

    @VisibleForTesting
    TestRequestBuilder(DeviceBuild deviceBuildAccessor, Instrumentation instr, Bundle bundle) {
        this.mDeviceBuild = Checks.checkNotNull(deviceBuildAccessor);
        this.mInstr = Checks.checkNotNull(instr);
        this.mArgsBundle = Checks.checkNotNull(bundle);
    }

    public TestRequestBuilder addApkToScan(String apkPath) {
        this.mApkPaths.add(apkPath);
        return this;
    }

    public TestRequestBuilder setClassLoader(ClassLoader loader) {
        this.mClassLoader = loader;
        return this;
    }

    public TestRequestBuilder ignoreSuiteMethods(boolean ignoreSuiteMethods) {
        this.mIgnoreSuiteMethods = ignoreSuiteMethods;
        return this;
    }

    public TestRequestBuilder addTestClass(String className) {
        this.mIncludedClasses.add(className);
        return this;
    }

    public TestRequestBuilder removeTestClass(String className) {
        this.mExcludedClasses.add(className);
        return this;
    }

    public TestRequestBuilder addTestMethod(String testClassName, String testMethodName) {
        this.mIncludedClasses.add(testClassName);
        this.mClassMethodFilter.addMethod(testClassName, testMethodName);
        return this;
    }

    public TestRequestBuilder removeTestMethod(String testClassName, String testMethodName) {
        this.mClassMethodFilter.removeMethod(testClassName, testMethodName);
        return this;
    }

    public TestRequestBuilder addTestPackage(String testPackage) {
        this.mIncludedPackages.add(testPackage);
        return this;
    }

    public TestRequestBuilder removeTestPackage(String testPackage) {
        this.mExcludedPackages.add(testPackage);
        return this;
    }

    public TestRequestBuilder addTestSizeFilter(TestSize forTestSize) {
        if (!TestSize.NONE.equals(forTestSize)) {
            this.addFilter(new SizeFilter(forTestSize));
        } else {
            Log.e((String)TAG, (String)String.format("Unrecognized test size '%s'", forTestSize.getSizeQualifierName()));
        }
        return this;
    }

    public TestRequestBuilder addAnnotationInclusionFilter(String annotation) {
        Class<? extends Annotation> annotationClass = this.loadAnnotationClass(annotation);
        if (annotationClass != null) {
            this.addFilter(new AnnotationInclusionFilter(annotationClass));
        }
        return this;
    }

    public TestRequestBuilder addAnnotationExclusionFilter(String notAnnotation) {
        Class<? extends Annotation> annotationClass = this.loadAnnotationClass(notAnnotation);
        if (annotationClass != null) {
            this.addFilter(new AnnotationExclusionFilter(annotationClass));
        }
        return this;
    }

    public TestRequestBuilder addShardingFilter(int numShards, int shardIndex) {
        return this.addFilter(new ShardingFilter(numShards, shardIndex));
    }

    public TestRequestBuilder addFilter(Filter filter) {
        this.mFilter = this.mFilter.intersect(filter);
        return this;
    }

    public TestRequestBuilder addCustomRunnerBuilderClass(Class<? extends RunnerBuilder> runnerBuilderClass) {
        this.customRunnerBuilderClasses.add(runnerBuilderClass);
        return this;
    }

    public TestRequestBuilder setSkipExecution(boolean b) {
        this.mSkipExecution = b;
        return this;
    }

    public TestRequestBuilder setPerTestTimeout(long millis) {
        this.mPerTestTimeout = millis;
        return this;
    }

    public TestRequestBuilder addFromRunnerArgs(RunnerArgs runnerArgs) {
        for (RunnerArgs.TestArg testArg : runnerArgs.tests) {
            if (testArg.methodName == null) {
                this.addTestClass(testArg.testClassName);
                continue;
            }
            this.addTestMethod(testArg.testClassName, testArg.methodName);
        }
        for (RunnerArgs.TestArg testArg : runnerArgs.notTests) {
            if (testArg.methodName == null) {
                this.removeTestClass(testArg.testClassName);
                continue;
            }
            this.removeTestMethod(testArg.testClassName, testArg.methodName);
        }
        for (String string : runnerArgs.testPackages) {
            this.addTestPackage(string);
        }
        for (String string : runnerArgs.notTestPackages) {
            this.removeTestPackage(string);
        }
        if (runnerArgs.testSize != null) {
            this.addTestSizeFilter(TestSize.fromString(runnerArgs.testSize));
        }
        if (runnerArgs.annotation != null) {
            this.addAnnotationInclusionFilter(runnerArgs.annotation);
        }
        for (String string : runnerArgs.notAnnotations) {
            this.addAnnotationExclusionFilter(string);
        }
        for (Filter filter : runnerArgs.filters) {
            this.addFilter(filter);
        }
        if (runnerArgs.testTimeout > 0L) {
            this.setPerTestTimeout(runnerArgs.testTimeout);
        }
        if (runnerArgs.numShards > 0 && runnerArgs.shardIndex >= 0 && runnerArgs.shardIndex < runnerArgs.numShards) {
            this.addShardingFilter(runnerArgs.numShards, runnerArgs.shardIndex);
        }
        if (runnerArgs.logOnly) {
            this.setSkipExecution(true);
        }
        if (runnerArgs.classLoader != null) {
            this.setClassLoader(runnerArgs.classLoader);
        }
        for (Class clazz : runnerArgs.runnerBuilderClasses) {
            this.addCustomRunnerBuilderClass(clazz);
        }
        return this;
    }

    public Request build() {
        this.mIncludedPackages.removeAll(this.mExcludedPackages);
        this.mIncludedClasses.removeAll(this.mExcludedClasses);
        this.validate(this.mIncludedClasses);
        boolean scanningPath = this.mIncludedClasses.isEmpty();
        boolean ignoreSuiteMethods = this.mIgnoreSuiteMethods || scanningPath;
        AndroidRunnerParams runnerParams = new AndroidRunnerParams(this.mInstr, this.mArgsBundle, this.mPerTestTimeout, ignoreSuiteMethods);
        RunnerBuilder runnerBuilder = this.getRunnerBuilder(runnerParams, scanningPath);
        TestLoader loader = TestLoader.testLoader(this.mClassLoader, runnerBuilder, scanningPath);
        Collection<String> classNames = scanningPath ? this.getClassNamesFromClassPath() : this.mIncludedClasses;
        List<Runner> runners = loader.getRunnersFor(classNames, scanningPath);
        Suite suite = ExtendedSuite.createSuite(runners);
        Request request = Request.runner((Runner)suite);
        return new LenientFilterRequest(request, this.mFilter);
    }

    private void validate(Set<String> classNames) {
        if (classNames.isEmpty() && this.mApkPaths.isEmpty()) {
            throw new IllegalArgumentException(MISSING_ARGUMENTS_MSG);
        }
        if (!(this.mIncludedPackages.isEmpty() && this.mExcludedPackages.isEmpty() || classNames.isEmpty())) {
            throw new IllegalArgumentException(AMBIGUOUS_ARGUMENTS_MSG);
        }
    }

    private RunnerBuilder getRunnerBuilder(AndroidRunnerParams runnerParams, boolean scanningPath) {
        Object builder = this.mSkipExecution ? new AndroidLogOnlyBuilder(runnerParams, scanningPath, this.customRunnerBuilderClasses) : new AndroidRunnerBuilder(runnerParams, scanningPath, this.customRunnerBuilderClasses);
        return builder;
    }

    private Collection<String> getClassNamesFromClassPath() {
        if (this.mApkPaths.isEmpty()) {
            throw new IllegalStateException("neither test class to execute or apk paths were provided");
        }
        Log.i((String)TAG, (String)String.format("Scanning classpath to find tests in apks %s", this.mApkPaths));
        ClassPathScanner scanner = this.createClassPathScanner(this.mApkPaths);
        ClassPathScanner.ChainedClassNameFilter filter = new ClassPathScanner.ChainedClassNameFilter();
        filter.add(new ClassPathScanner.ExternalClassNameFilter());
        for (String pkg : DEFAULT_EXCLUDED_PACKAGES) {
            if (this.mIncludedPackages.contains(pkg)) continue;
            this.mExcludedPackages.add(pkg);
        }
        for (String pkg : this.mIncludedPackages) {
            filter.add(new ClassPathScanner.InclusivePackageNameFilter(pkg));
        }
        for (String pkg : this.mExcludedPackages) {
            filter.add(new ClassPathScanner.ExcludePackageNameFilter(pkg));
        }
        filter.add(new ClassPathScanner.ExcludeClassNamesFilter(this.mExcludedClasses));
        try {
            return scanner.getClassPathEntries(filter);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Failed to scan classes", (Throwable)e);
            return Collections.emptyList();
        }
    }

    ClassPathScanner createClassPathScanner(List<String> apkPaths) {
        return new ClassPathScanner(apkPaths);
    }

    private Class<? extends Annotation> loadAnnotationClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)String.format("Could not find annotation class: %s", className));
        }
        catch (ClassCastException e) {
            Log.e((String)TAG, (String)String.format("Class %s is not an annotation", className));
        }
        return null;
    }

    private int getDeviceSdkInt() {
        return this.mDeviceBuild.getSdkVersionInt();
    }

    private String getDeviceHardware() {
        return this.mDeviceBuild.getHardware();
    }

    private static class MethodFilter
    extends ParentFilter {
        private final String mClassName;
        private Set<String> mIncludedMethods = new HashSet<String>();
        private Set<String> mExcludedMethods = new HashSet<String>();

        public MethodFilter(String className) {
            this.mClassName = className;
        }

        public String describe() {
            String string = this.mClassName;
            return new StringBuilder(24 + String.valueOf(string).length()).append("Method filter for ").append(string).append(" class").toString();
        }

        @Override
        public boolean evaluateTest(Description description) {
            String methodName = description.getMethodName();
            if (this.mExcludedMethods.contains(methodName = this.stripParameterizedSuffix(methodName))) {
                return false;
            }
            return this.mIncludedMethods.isEmpty() || this.mIncludedMethods.contains(methodName) || methodName.equals("initializationError");
        }

        private String stripParameterizedSuffix(String name) {
            Pattern suffixPattern = Pattern.compile(".+(\\[[0-9]+\\])$");
            if (suffixPattern.matcher(name).matches()) {
                name = name.substring(0, name.lastIndexOf(91));
            }
            return name;
        }

        public void addInclusionMethod(String methodName) {
            this.mIncludedMethods.add(methodName);
        }

        public void addExclusionMethod(String methodName) {
            this.mExcludedMethods.add(methodName);
        }
    }

    private static class ClassAndMethodFilter
    extends ParentFilter {
        private Map<String, MethodFilter> mMethodFilters = new HashMap<String, MethodFilter>();

        private ClassAndMethodFilter() {
        }

        @Override
        public boolean evaluateTest(Description description) {
            if (this.mMethodFilters.isEmpty()) {
                return true;
            }
            String className = description.getClassName();
            MethodFilter methodFilter = this.mMethodFilters.get(className);
            if (methodFilter != null) {
                return methodFilter.shouldRun(description);
            }
            return true;
        }

        public String describe() {
            return "Class and method filter";
        }

        public void addMethod(String className, String methodName) {
            MethodFilter methodFilter = this.mMethodFilters.get(className);
            if (methodFilter == null) {
                methodFilter = new MethodFilter(className);
                this.mMethodFilters.put(className, methodFilter);
            }
            methodFilter.addInclusionMethod(methodName);
        }

        public void removeMethod(String className, String methodName) {
            MethodFilter methodFilter = this.mMethodFilters.get(className);
            if (methodFilter == null) {
                methodFilter = new MethodFilter(className);
                this.mMethodFilters.put(className, methodFilter);
            }
            methodFilter.addExclusionMethod(methodName);
        }
    }

    private static class BlankRunner
    extends Runner {
        private BlankRunner() {
        }

        public Description getDescription() {
            return Description.createSuiteDescription((String)"no tests found", (Annotation[])new Annotation[0]);
        }

        public void run(RunNotifier notifier) {
        }
    }

    private static class LenientFilterRequest
    extends Request {
        private final Request mRequest;
        private final Filter mFilter;

        public LenientFilterRequest(Request classRequest, Filter filter) {
            this.mRequest = classRequest;
            this.mFilter = filter;
        }

        public Runner getRunner() {
            try {
                Runner runner = this.mRequest.getRunner();
                this.mFilter.apply((Object)runner);
                return runner;
            }
            catch (NoTestsRemainException e) {
                return new BlankRunner();
            }
        }
    }

    private static class ShardingFilter
    extends Filter {
        private final int mNumShards;
        private final int mShardIndex;

        ShardingFilter(int numShards, int shardIndex) {
            this.mNumShards = numShards;
            this.mShardIndex = shardIndex;
        }

        public boolean shouldRun(Description description) {
            if (description.isTest()) {
                return Math.abs(description.hashCode()) % this.mNumShards == this.mShardIndex;
            }
            return true;
        }

        public String describe() {
            return String.format("Shard %s of %s shards", this.mShardIndex, this.mNumShards);
        }
    }

    @VisibleForTesting
    class RequiresDeviceFilter
    extends AnnotationExclusionFilter {
        static final String EMULATOR_HARDWARE_GOLDFISH = "goldfish";
        static final String EMULATOR_HARDWARE_RANCHU = "ranchu";
        static final String EMULATOR_HARDWARE_GCE = "gce_x86";
        private final Set<String> emulatorHardwareNames;

        RequiresDeviceFilter() {
            super(RequiresDevice.class);
            this.emulatorHardwareNames = new HashSet<String>(Arrays.asList(EMULATOR_HARDWARE_GOLDFISH, EMULATOR_HARDWARE_RANCHU, EMULATOR_HARDWARE_GCE));
        }

        @Override
        protected boolean evaluateTest(Description description) {
            if (!super.evaluateTest(description)) {
                return !this.emulatorHardwareNames.contains(TestRequestBuilder.this.getDeviceHardware());
            }
            return true;
        }

        @Override
        public String describe() {
            return String.format("skip tests annotated with RequiresDevice if necessary", new Object[0]);
        }
    }

    private class SdkSuppressFilter
    extends ParentFilter {
        private SdkSuppressFilter() {
        }

        @Override
        protected boolean evaluateTest(Description description) {
            SdkSuppress sdkSuppress = this.getAnnotationForTest(description);
            if (sdkSuppress != null) {
                return TestRequestBuilder.this.getDeviceSdkInt() >= sdkSuppress.minSdkVersion() && TestRequestBuilder.this.getDeviceSdkInt() <= sdkSuppress.maxSdkVersion();
            }
            return true;
        }

        private SdkSuppress getAnnotationForTest(Description description) {
            SdkSuppress s = (SdkSuppress)description.getAnnotation(SdkSuppress.class);
            if (s != null) {
                return s;
            }
            Class testClass = description.getTestClass();
            if (testClass != null) {
                return testClass.getAnnotation(SdkSuppress.class);
            }
            return null;
        }

        public String describe() {
            return String.format("skip tests annotated with SdkSuppress if necessary", new Object[0]);
        }
    }

    private static class ExtendedSuite
    extends Suite {
        static Suite createSuite(List<Runner> runners) {
            try {
                return new ExtendedSuite(runners);
            }
            catch (InitializationError e) {
                String string = Suite.class.getName();
                throw new RuntimeException(new StringBuilder(107 + String.valueOf(string).length()).append("Internal Error: ").append(string).append("(Class<?>, List<Runner>) should never throw an InitializationError when passed a null Class").toString());
            }
        }

        ExtendedSuite(List<Runner> runners) throws InitializationError {
            super(null, runners);
        }
    }

    private static class AnnotationExclusionFilter
    extends ParentFilter {
        private final Class<? extends Annotation> mAnnotationClass;

        AnnotationExclusionFilter(Class<? extends Annotation> annotation) {
            this.mAnnotationClass = annotation;
        }

        @Override
        protected boolean evaluateTest(Description description) {
            Class testClass = description.getTestClass();
            return (testClass == null || !testClass.isAnnotationPresent(this.mAnnotationClass)) && description.getAnnotation(this.mAnnotationClass) == null;
        }

        public String describe() {
            return String.format("not annotation %s", this.mAnnotationClass.getName());
        }
    }

    private static class SizeFilter
    extends ParentFilter {
        private final TestSize mTestSize;

        SizeFilter(TestSize testSize) {
            this.mTestSize = testSize;
        }

        public String describe() {
            return "";
        }

        @Override
        protected boolean evaluateTest(Description description) {
            if (this.mTestSize.testMethodIsAnnotatedWithTestSize(description)) {
                return true;
            }
            if (this.mTestSize.testClassIsAnnotatedWithTestSize(description)) {
                for (Annotation a : description.getAnnotations()) {
                    if (!TestSize.isAnyTestSize(a.annotationType())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static class AnnotationInclusionFilter
    extends ParentFilter {
        private final Class<? extends Annotation> mAnnotationClass;

        AnnotationInclusionFilter(Class<? extends Annotation> annotation) {
            this.mAnnotationClass = annotation;
        }

        @Override
        protected boolean evaluateTest(Description description) {
            Class testClass = description.getTestClass();
            return description.getAnnotation(this.mAnnotationClass) != null || testClass != null && testClass.isAnnotationPresent(this.mAnnotationClass);
        }

        protected Class<? extends Annotation> getAnnotationClass() {
            return this.mAnnotationClass;
        }

        public String describe() {
            return String.format("annotation %s", this.mAnnotationClass.getName());
        }
    }

    private static abstract class ParentFilter
    extends Filter {
        private ParentFilter() {
        }

        public boolean shouldRun(Description description) {
            if (description.isTest()) {
                return this.evaluateTest(description);
            }
            for (Description each : description.getChildren()) {
                if (!this.shouldRun(each)) continue;
                return true;
            }
            return false;
        }

        protected abstract boolean evaluateTest(Description var1);
    }

    private static class DeviceBuildImpl
    implements DeviceBuild {
        private DeviceBuildImpl() {
        }

        @Override
        public int getSdkVersionInt() {
            return Build.VERSION.SDK_INT;
        }

        @Override
        public String getHardware() {
            return Build.HARDWARE;
        }
    }

    static interface DeviceBuild {
        public int getSdkVersionInt();

        public String getHardware();
    }
}

