/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.rule;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.test.InstrumentationRegistry;
import android.support.test.internal.runner.junit4.statement.UiThreadStatement;
import android.support.test.internal.util.Checks;
import android.support.test.runner.MonitoringInstrumentation;
import android.support.test.runner.intercepting.InterceptingActivityFactory;
import android.support.test.runner.intercepting.SingleActivityFactory;
import android.support.test.runner.lifecycle.ActivityLifecycleCallback;
import android.support.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import android.support.test.runner.lifecycle.Stage;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ActivityTestRule<T extends Activity>
implements TestRule {
    private static final String TAG = "ActivityTestRule";
    private static final int NO_FLAGS_SET = 0;
    private static final String FIELD_RESULT_CODE = "mResultCode";
    private static final String FIELD_RESULT_DATA = "mResultData";
    private final Class<T> mActivityClass;
    private final String mTargetPackage;
    private final int mLaunchFlags;
    private final ActivityLifecycleCallback mLifecycleCallback = new LifecycleCallback();
    private Instrumentation mInstrumentation;
    private boolean mInitialTouchMode = false;
    private boolean mLaunchActivity = false;
    private SingleActivityFactory<T> mActivityFactory;
    @VisibleForTesting
    volatile WeakReference<T> mActivity = this.makeWeakReference(null);
    private volatile Instrumentation.ActivityResult mActivityResult;

    public ActivityTestRule(Class<T> activityClass) {
        this(activityClass, false);
    }

    public ActivityTestRule(Class<T> activityClass, boolean initialTouchMode) {
        this(activityClass, initialTouchMode, true);
    }

    public ActivityTestRule(Class<T> activityClass, boolean initialTouchMode, boolean launchActivity) {
        this(activityClass, InstrumentationRegistry.getTargetContext().getPackageName(), 0x10000000, initialTouchMode, launchActivity);
    }

    public ActivityTestRule(SingleActivityFactory<T> activityFactory, boolean initialTouchMode, boolean launchActivity) {
        this(activityFactory.getActivityClassToIntercept(), initialTouchMode, launchActivity);
        this.mActivityFactory = activityFactory;
    }

    public ActivityTestRule(Class<T> activityClass, @NonNull String targetPackage, int launchFlags, boolean initialTouchMode, boolean launchActivity) {
        this.mInstrumentation = InstrumentationRegistry.getInstrumentation();
        this.mActivityClass = activityClass;
        this.mTargetPackage = (String)Checks.checkNotNull((Object)targetPackage, (Object)"targetPackage cannot be null!");
        this.mLaunchFlags = launchFlags;
        this.mInitialTouchMode = initialTouchMode;
        this.mLaunchActivity = launchActivity;
    }

    protected Intent getActivityIntent() {
        return null;
    }

    protected void beforeActivityLaunched() {
    }

    protected void afterActivityLaunched() {
    }

    protected void afterActivityFinished() {
    }

    public T getActivity() {
        Activity hardActivityRef = (Activity)this.mActivity.get();
        if (hardActivityRef == null) {
            Log.w((String)TAG, (String)"Activity wasn't created yet or already stopped");
        }
        return (T)hardActivityRef;
    }

    public Statement apply(Statement base, Description description) {
        return new ActivityStatement(base);
    }

    public T launchActivity(@Nullable Intent startIntent) {
        this.mInstrumentation.setInTouchMode(this.mInitialTouchMode);
        if (null == startIntent && null == (startIntent = this.getActivityIntent())) {
            Log.w((String)TAG, (String)"getActivityIntent() returned null using default: Intent(Intent.ACTION_MAIN)");
            startIntent = new Intent("android.intent.action.MAIN");
        }
        if (null == startIntent.getComponent()) {
            startIntent.setClassName(this.mTargetPackage, this.mActivityClass.getName());
        }
        if (0 == startIntent.getFlags()) {
            startIntent.addFlags(this.mLaunchFlags);
        }
        this.beforeActivityLaunched();
        Activity hardActivityRef = (Activity)this.mActivityClass.cast(this.mInstrumentation.startActivitySync(startIntent));
        this.mActivity = this.makeWeakReference(hardActivityRef);
        this.mInstrumentation.waitForIdleSync();
        if (hardActivityRef != null) {
            ActivityLifecycleMonitorRegistry.getInstance().addLifecycleCallback(this.mLifecycleCallback);
            this.afterActivityLaunched();
        } else {
            String errorMessage = String.format("Activity %s, failed to launch", startIntent.getComponent());
            Bundle bundle = new Bundle();
            String string = String.valueOf("ActivityTestRule ");
            String string2 = String.valueOf(errorMessage);
            bundle.putString("stream", string2.length() != 0 ? string.concat(string2) : new String(string));
            this.mInstrumentation.sendStatus(0, bundle);
            Log.e((String)TAG, (String)errorMessage);
        }
        return (T)hardActivityRef;
    }

    @VisibleForTesting
    void setInstrumentation(Instrumentation instrumentation) {
        this.mInstrumentation = (Instrumentation)Checks.checkNotNull((Object)instrumentation, (Object)"instrumentation cannot be null!");
    }

    public void finishActivity() {
        try {
            if (this.mActivity.get() != null) {
                this.callFinishOnMainSync();
            }
        }
        finally {
            this.mActivity = this.makeWeakReference(null);
            this.afterActivityFinished();
        }
    }

    @VisibleForTesting
    void callFinishOnMainSync() {
        try {
            final Activity hardActivityRef = (Activity)this.mActivity.get();
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Checks.checkState((hardActivityRef != null ? 1 : 0) != 0, (Object)"Activity was not launched. If you manually finished it, you must launch it again before finishing it. ");
                    hardActivityRef.finish();
                    ActivityTestRule.this.setActivityResultForActivity(hardActivityRef);
                }
            });
            this.mInstrumentation.waitForIdleSync();
        }
        catch (Throwable throwable) {
            String msg = "Failed to execute activity.finish() on the main thread";
            Log.e((String)TAG, (String)msg, (Throwable)throwable);
            throw new IllegalStateException(msg, throwable);
        }
    }

    public Instrumentation.ActivityResult getActivityResult() {
        if (null == this.mActivityResult) {
            final Activity hardActivityRef = (Activity)this.mActivity.get();
            Checks.checkNotNull((Object)hardActivityRef, (Object)"Activity wasn't created yet or already destroyed!");
            try {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Checks.checkState((boolean)hardActivityRef.isFinishing(), (Object)"Activity is not finishing!");
                        ActivityTestRule.this.setActivityResultForActivity(hardActivityRef);
                    }
                });
            }
            catch (Throwable throwable) {
                throw new IllegalStateException(throwable);
            }
        }
        return this.mActivityResult;
    }

    private void setActivityResultForActivity(T activity) {
        Checks.checkState((Looper.myLooper() == Looper.getMainLooper() ? 1 : 0) != 0, (Object)"Must be called on the main thread!");
        Checks.checkNotNull(activity, (Object)"Activity wasn't created yet or already destroyed!");
        try {
            Field resultCodeField = Activity.class.getDeclaredField(FIELD_RESULT_CODE);
            resultCodeField.setAccessible(true);
            Field resultDataField = Activity.class.getDeclaredField(FIELD_RESULT_DATA);
            resultDataField.setAccessible(true);
            this.mActivityResult = new Instrumentation.ActivityResult(((Integer)resultCodeField.get(activity)).intValue(), (Intent)resultDataField.get(activity));
        }
        catch (NoSuchFieldException e) {
            String msg = "Looks like the Android Activity class has changed itsprivate fields for mResultCode or mResultData. Time to update the reflection code.";
            Log.e((String)TAG, (String)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Field mResultCode or mResultData is not accessible";
            Log.e((String)TAG, (String)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public void runOnUiThread(Runnable runnable) throws Throwable {
        UiThreadStatement.runOnUiThread((Runnable)runnable);
    }

    @VisibleForTesting
    WeakReference<T> makeWeakReference(T activity) {
        return new WeakReference<T>(activity);
    }

    private class LifecycleCallback
    implements ActivityLifecycleCallback {
        private LifecycleCallback() {
        }

        public void onActivityLifecycleChanged(Activity activity, Stage stage) {
            if (ActivityTestRule.this.mActivityClass.isInstance(activity)) {
                if (Stage.RESUMED == stage) {
                    ActivityTestRule.this.mActivity = ActivityTestRule.this.makeWeakReference((Activity)ActivityTestRule.this.mActivityClass.cast(activity));
                } else if (Stage.PAUSED == stage && activity.isFinishing() && ActivityTestRule.this.mActivityResult != null) {
                    ActivityTestRule.this.setActivityResultForActivity((Activity)ActivityTestRule.this.mActivityClass.cast(activity));
                }
            }
        }
    }

    private class ActivityStatement
    extends Statement {
        private final Statement mBase;

        public ActivityStatement(Statement base) {
            this.mBase = base;
        }

        public void evaluate() throws Throwable {
            MonitoringInstrumentation instrumentation = ActivityTestRule.this.mInstrumentation instanceof MonitoringInstrumentation ? (MonitoringInstrumentation)ActivityTestRule.this.mInstrumentation : null;
            try {
                if (ActivityTestRule.this.mActivityFactory != null && instrumentation != null) {
                    instrumentation.interceptActivityUsing((InterceptingActivityFactory)ActivityTestRule.this.mActivityFactory);
                }
                if (ActivityTestRule.this.mLaunchActivity) {
                    ActivityTestRule.this.launchActivity(ActivityTestRule.this.getActivityIntent());
                }
                this.mBase.evaluate();
            }
            finally {
                Activity hardActivityRef;
                if (instrumentation != null) {
                    instrumentation.useDefaultInterceptingActivityFactory();
                }
                if ((hardActivityRef = (Activity)ActivityTestRule.this.mActivity.get()) != null) {
                    ActivityTestRule.this.finishActivity();
                }
                ActivityTestRule.this.mActivityResult = null;
                ActivityLifecycleMonitorRegistry.getInstance().removeLifecycleCallback(ActivityTestRule.this.mLifecycleCallback);
            }
        }
    }
}

