/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.rule;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.test.annotation.Beta;
import android.support.test.internal.util.Checks;
import android.support.test.runner.permission.PermissionRequester;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Beta
public class GrantPermissionRule
implements TestRule {
    private PermissionRequester mPermissionRequester;

    private GrantPermissionRule() {
        this(new PermissionRequester());
    }

    private GrantPermissionRule(@NonNull PermissionRequester permissionRequester) {
        this.setPermissionRequester(permissionRequester);
    }

    public static GrantPermissionRule grant(String ... permissions) {
        GrantPermissionRule grantPermissionRule = new GrantPermissionRule();
        grantPermissionRule.grantPermissions(permissions);
        return grantPermissionRule;
    }

    private void grantPermissions(String ... permissions) {
        this.mPermissionRequester.addPermissions(permissions);
    }

    public final Statement apply(Statement base, Description description) {
        return new RequestPermissionStatement(base);
    }

    @VisibleForTesting
    protected void setPermissionRequester(PermissionRequester permissionRequester) {
        this.mPermissionRequester = (PermissionRequester)Checks.checkNotNull((Object)permissionRequester, (Object)"permissionRequester cannot be null!");
    }

    private class RequestPermissionStatement
    extends Statement {
        private final Statement mBase;

        public RequestPermissionStatement(Statement base) {
            this.mBase = base;
        }

        public void evaluate() throws Throwable {
            GrantPermissionRule.this.mPermissionRequester.requestPermissions();
            this.mBase.evaluate();
        }
    }
}

