/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModel;
import android.arch.lifecycle.ViewModelProvider;
import android.arch.lifecycle.ViewModelStore;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.util.DebugUtils;
import android.support.v4.util.SparseArrayCompat;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;

class LoaderManagerImpl
extends LoaderManager {
    static final String TAG = "LoaderManager";
    static boolean DEBUG = false;
    @NonNull
    private final LifecycleOwner mLifecycleOwner;
    @NonNull
    private final LoaderViewModel mLoaderViewModel;
    private boolean mCreatingLoader;

    LoaderManagerImpl(@NonNull LifecycleOwner lifecycleOwner, @NonNull ViewModelStore viewModelStore) {
        this.mLifecycleOwner = lifecycleOwner;
        this.mLoaderViewModel = LoaderViewModel.getInstance(viewModelStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    @NonNull
    private <D> Loader<D> createAndInstallLoader(int id2, @Nullable Bundle args, @NonNull LoaderManager.LoaderCallbacks<D> callback) {
        LoaderInfo<D> info;
        try {
            this.mCreatingLoader = true;
            Loader<D> loader = callback.onCreateLoader(id2, args);
            if (loader.getClass().isMemberClass() && !Modifier.isStatic(loader.getClass().getModifiers())) {
                throw new IllegalArgumentException("Object returned from onCreateLoader must not be a non-static inner member class: " + loader);
            }
            info = new LoaderInfo<D>(id2, args, loader);
            if (DEBUG) {
                Log.v((String)TAG, (String)("  Created new loader " + info));
            }
            this.mLoaderViewModel.putLoader(id2, info);
        }
        finally {
            this.mCreatingLoader = false;
        }
        return info.setCallback(this.mLifecycleOwner, callback);
    }

    @Override
    @MainThread
    @NonNull
    public <D> Loader<D> initLoader(int id2, @Nullable Bundle args, @NonNull LoaderManager.LoaderCallbacks<D> callback) {
        if (this.mCreatingLoader) {
            throw new IllegalStateException("Called while creating a loader");
        }
        if (Looper.getMainLooper() != Looper.myLooper()) {
            throw new IllegalStateException("initLoader must be called on the main thread");
        }
        LoaderInfo<D> info = this.mLoaderViewModel.getLoader(id2);
        if (DEBUG) {
            Log.v((String)TAG, (String)("initLoader in " + this + ": args=" + args));
        }
        if (info == null) {
            return this.createAndInstallLoader(id2, args, callback);
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("  Re-using existing loader " + info));
        }
        return info.setCallback(this.mLifecycleOwner, callback);
    }

    @Override
    @MainThread
    @NonNull
    public <D> Loader<D> restartLoader(int id2, @Nullable Bundle args, @NonNull LoaderManager.LoaderCallbacks<D> callback) {
        if (this.mCreatingLoader) {
            throw new IllegalStateException("Called while creating a loader");
        }
        if (Looper.getMainLooper() != Looper.myLooper()) {
            throw new IllegalStateException("restartLoader must be called on the main thread");
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("restartLoader in " + this + ": args=" + args));
        }
        this.destroyLoader(id2);
        return this.createAndInstallLoader(id2, args, callback);
    }

    @Override
    @MainThread
    public void destroyLoader(int id2) {
        LoaderInfo info;
        if (this.mCreatingLoader) {
            throw new IllegalStateException("Called while creating a loader");
        }
        if (Looper.getMainLooper() != Looper.myLooper()) {
            throw new IllegalStateException("destroyLoader must be called on the main thread");
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("destroyLoader in " + this + " of " + id2));
        }
        if ((info = this.mLoaderViewModel.getLoader(id2)) != null) {
            info.destroy();
            this.mLoaderViewModel.removeLoader(id2);
        }
    }

    @Override
    @Nullable
    public <D> Loader<D> getLoader(int id2) {
        if (this.mCreatingLoader) {
            throw new IllegalStateException("Called while creating a loader");
        }
        LoaderInfo info = this.mLoaderViewModel.getLoader(id2);
        return info != null ? info.getLoader() : null;
    }

    void markForRedelivery() {
        this.mLoaderViewModel.markForRedelivery();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("LoaderManager{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" in ");
        DebugUtils.buildShortClassTag((Object)this.mLifecycleOwner, (StringBuilder)sb);
        sb.append("}}");
        return sb.toString();
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mLoaderViewModel.dump(prefix, fd, writer, args);
    }

    @Override
    public boolean hasRunningLoaders() {
        return this.mLoaderViewModel.hasRunningLoaders();
    }

    static class LoaderViewModel
    extends ViewModel {
        private static final ViewModelProvider.Factory FACTORY = new ViewModelProvider.Factory(){

            @NonNull
            public <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
                return (T)((Object)new LoaderViewModel());
            }
        };
        private SparseArrayCompat<LoaderInfo> mLoaders = new SparseArrayCompat();

        LoaderViewModel() {
        }

        @NonNull
        static LoaderViewModel getInstance(ViewModelStore viewModelStore) {
            return (LoaderViewModel)new ViewModelProvider(viewModelStore, FACTORY).get(LoaderViewModel.class);
        }

        void putLoader(int id2, @NonNull LoaderInfo info) {
            this.mLoaders.put(id2, (Object)info);
        }

        <D> LoaderInfo<D> getLoader(int id2) {
            return (LoaderInfo)((Object)this.mLoaders.get(id2));
        }

        void removeLoader(int id2) {
            this.mLoaders.remove(id2);
        }

        boolean hasRunningLoaders() {
            int size = this.mLoaders.size();
            for (int index = 0; index < size; ++index) {
                LoaderInfo info = (LoaderInfo)((Object)this.mLoaders.valueAt(index));
                if (!info.isCallbackWaitingForData()) continue;
                return true;
            }
            return false;
        }

        void markForRedelivery() {
            int size = this.mLoaders.size();
            for (int index = 0; index < size; ++index) {
                LoaderInfo info = (LoaderInfo)((Object)this.mLoaders.valueAt(index));
                info.markForRedelivery();
            }
        }

        protected void onCleared() {
            super.onCleared();
            int size = this.mLoaders.size();
            for (int index = 0; index < size; ++index) {
                LoaderInfo info = (LoaderInfo)((Object)this.mLoaders.valueAt(index));
                info.destroy();
            }
            this.mLoaders.clear();
        }

        public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            if (this.mLoaders.size() > 0) {
                writer.print(prefix);
                writer.println("Loaders:");
                String innerPrefix = prefix + "    ";
                for (int i = 0; i < this.mLoaders.size(); ++i) {
                    LoaderInfo info = (LoaderInfo)((Object)this.mLoaders.valueAt(i));
                    writer.print(prefix);
                    writer.print("  #");
                    writer.print(this.mLoaders.keyAt(i));
                    writer.print(": ");
                    writer.println(info.toString());
                    info.dump(innerPrefix, fd, writer, args);
                }
            }
        }
    }

    static class LoaderObserver<D>
    implements Observer<D> {
        @NonNull
        private final Loader<D> mLoader;
        @NonNull
        private final LoaderManager.LoaderCallbacks<D> mCallback;
        private boolean mDeliveredData = false;

        LoaderObserver(@NonNull Loader<D> loader, @NonNull LoaderManager.LoaderCallbacks<D> callback) {
            this.mLoader = loader;
            this.mCallback = callback;
        }

        public void onChanged(@Nullable D data) {
            if (DEBUG) {
                Log.v((String)LoaderManagerImpl.TAG, (String)("  onLoadFinished in " + this.mLoader + ": " + this.mLoader.dataToString(data)));
            }
            this.mCallback.onLoadFinished(this.mLoader, data);
            this.mDeliveredData = true;
        }

        boolean hasDeliveredData() {
            return this.mDeliveredData;
        }

        @MainThread
        void reset() {
            if (this.mDeliveredData) {
                if (DEBUG) {
                    Log.v((String)LoaderManagerImpl.TAG, (String)("  Resetting: " + this.mLoader));
                }
                this.mCallback.onLoaderReset(this.mLoader);
            }
        }

        public String toString() {
            return this.mCallback.toString();
        }

        public void dump(String prefix, PrintWriter writer) {
            writer.print(prefix);
            writer.print("mDeliveredData=");
            writer.println(this.mDeliveredData);
        }
    }

    public static class LoaderInfo<D>
    extends MutableLiveData<D>
    implements Loader.OnLoadCompleteListener<D> {
        private final int mId;
        @Nullable
        private final Bundle mArgs;
        @NonNull
        private final Loader<D> mLoader;
        private LifecycleOwner mLifecycleOwner;
        private LoaderObserver<D> mObserver;

        LoaderInfo(int id2, @Nullable Bundle args, @NonNull Loader<D> loader) {
            this.mId = id2;
            this.mArgs = args;
            this.mLoader = loader;
            this.mLoader.registerListener(id2, (Loader.OnLoadCompleteListener)this);
        }

        @NonNull
        Loader<D> getLoader() {
            return this.mLoader;
        }

        protected void onActive() {
            if (DEBUG) {
                Log.v((String)LoaderManagerImpl.TAG, (String)("  Starting: " + (Object)((Object)this)));
            }
            this.mLoader.startLoading();
        }

        protected void onInactive() {
            if (DEBUG) {
                Log.v((String)LoaderManagerImpl.TAG, (String)("  Stopping: " + (Object)((Object)this)));
            }
            this.mLoader.stopLoading();
        }

        @MainThread
        @NonNull
        Loader<D> setCallback(@NonNull LifecycleOwner owner, @NonNull LoaderManager.LoaderCallbacks<D> callback) {
            LoaderObserver<D> observer = new LoaderObserver<D>(this.mLoader, callback);
            this.observe(owner, observer);
            if (this.mObserver != null) {
                this.removeObserver(this.mObserver);
            }
            this.mLifecycleOwner = owner;
            this.mObserver = observer;
            return this.mLoader;
        }

        void markForRedelivery() {
            LifecycleOwner lifecycleOwner = this.mLifecycleOwner;
            LoaderObserver<D> observer = this.mObserver;
            if (lifecycleOwner != null && observer != null) {
                this.removeObserver(observer);
                this.observe(lifecycleOwner, observer);
            }
        }

        boolean isCallbackWaitingForData() {
            if (!this.hasActiveObservers()) {
                return false;
            }
            return this.mObserver != null && !this.mObserver.hasDeliveredData();
        }

        public void removeObserver(@NonNull Observer<D> observer) {
            super.removeObserver(observer);
            this.mLifecycleOwner = null;
            this.mObserver = null;
        }

        @MainThread
        void destroy() {
            if (DEBUG) {
                Log.v((String)LoaderManagerImpl.TAG, (String)("  Destroying: " + (Object)((Object)this)));
            }
            this.mLoader.cancelLoad();
            this.mLoader.abandon();
            LoaderObserver<D> observer = this.mObserver;
            if (observer != null) {
                this.removeObserver(observer);
                observer.reset();
            }
            this.mLoader.unregisterListener((Loader.OnLoadCompleteListener)this);
            this.mLoader.reset();
        }

        public void onLoadComplete(@NonNull Loader<D> loader, @Nullable D data) {
            if (DEBUG) {
                Log.v((String)LoaderManagerImpl.TAG, (String)("onLoadComplete: " + (Object)((Object)this)));
            }
            if (Looper.myLooper() == Looper.getMainLooper()) {
                this.setValue(data);
            } else {
                if (DEBUG) {
                    Log.w((String)LoaderManagerImpl.TAG, (String)"onLoadComplete was incorrectly called on a background thread");
                }
                this.postValue(data);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append("LoaderInfo{");
            sb.append(Integer.toHexString(System.identityHashCode((Object)this)));
            sb.append(" #");
            sb.append(this.mId);
            sb.append(" : ");
            DebugUtils.buildShortClassTag(this.mLoader, (StringBuilder)sb);
            sb.append("}}");
            return sb.toString();
        }

        public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            writer.print(prefix);
            writer.print("mId=");
            writer.print(this.mId);
            writer.print(" mArgs=");
            writer.println(this.mArgs);
            writer.print(prefix);
            writer.print("mLoader=");
            writer.println(this.mLoader);
            this.mLoader.dump(prefix + "  ", fd, writer, args);
            if (this.mObserver != null) {
                writer.print(prefix);
                writer.print("mCallbacks=");
                writer.println(this.mObserver);
                this.mObserver.dump(prefix + "  ", writer);
            }
            writer.print(prefix);
            writer.print("mData=");
            writer.println(this.getLoader().dataToString(this.getValue()));
            writer.print(prefix);
            writer.print("mStarted=");
            writer.println(this.hasActiveObservers());
        }
    }
}

