/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.os.Build;
import android.support.constraint.ConstraintAttribute;
import android.support.constraint.motion.MotionLayout;
import android.support.constraint.motion.utils.CurveFit;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.Arrays;

public abstract class SplineSet {
    private static final String TAG = "SplineSet";
    protected CurveFit mCurveFit;
    protected int[] mTimePoints = new int[10];
    protected float[] mValues = new float[10];
    private int count;
    private String mType;

    public String toString() {
        String str = this.mType;
        DecimalFormat df = new DecimalFormat("##.##");
        for (int i = 0; i < this.count; ++i) {
            str = str + "[" + this.mTimePoints[i] + " , " + df.format(this.mValues[i]) + "] ";
        }
        return str;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public abstract void setProperty(View var1, float var2);

    public float get(float t) {
        return (float)this.mCurveFit.getPos((double)t, 0);
    }

    public float getSlope(float t) {
        return (float)this.mCurveFit.getSlope((double)t, 0);
    }

    public CurveFit getCurveFit() {
        return this.mCurveFit;
    }

    static SplineSet makeCustomSpline(String str, SparseArray<ConstraintAttribute> attrList) {
        return new CustomSet(str, attrList);
    }

    static SplineSet makeSpline(String str) {
        switch (str) {
            case "alpha": {
                return new AlphaSet();
            }
            case "elevation": {
                return new ElevationSet();
            }
            case "rotation": {
                return new RotationSet();
            }
            case "rotationX": {
                return new RotationXset();
            }
            case "rotationY": {
                return new RotationYset();
            }
            case "transformPivotX": {
                return new PivotXset();
            }
            case "transformPivotY": {
                return new PivotYset();
            }
            case "transitionPathRotate": {
                return new PathRotate();
            }
            case "scaleX": {
                return new ScaleXset();
            }
            case "scaleY": {
                return new ScaleYset();
            }
            case "waveOffset": {
                return new AlphaSet();
            }
            case "waveVariesBy": {
                return new AlphaSet();
            }
            case "translationX": {
                return new TranslationXset();
            }
            case "translationY": {
                return new TranslationYset();
            }
            case "translationZ": {
                return new TranslationZset();
            }
            case "progress": {
                return new ProgressSet();
            }
        }
        return null;
    }

    public void setPoint(int position, float value) {
        if (this.mTimePoints.length < this.count + 1) {
            this.mTimePoints = Arrays.copyOf(this.mTimePoints, this.mTimePoints.length * 2);
            this.mValues = Arrays.copyOf(this.mValues, this.mValues.length * 2);
        }
        this.mTimePoints[this.count] = position;
        this.mValues[this.count] = value;
        ++this.count;
    }

    public void setup(int curveType) {
        if (this.count == 0) {
            return;
        }
        Sort.doubleQuickSort(this.mTimePoints, this.mValues, 0, this.count - 1);
        int unique = 1;
        for (int i = 1; i < this.count; ++i) {
            if (this.mTimePoints[i - 1] == this.mTimePoints[i]) continue;
            ++unique;
        }
        double[] time = new double[unique];
        double[][] values = new double[unique][1];
        int k = 0;
        for (int i = 0; i < this.count; ++i) {
            if (i > 0 && this.mTimePoints[i] == this.mTimePoints[i - 1]) continue;
            time[k] = (double)this.mTimePoints[i] * 0.01;
            values[k][0] = this.mValues[i];
            ++k;
        }
        this.mCurveFit = CurveFit.get(curveType, time, values);
    }

    private static class Sort {
        private Sort() {
        }

        static void doubleQuickSort(int[] key, float[] value, int low, int hi) {
            int[] stack = new int[key.length + 10];
            int count = 0;
            stack[count++] = hi;
            stack[count++] = low;
            while (count > 0) {
                --count;
                low = stack[count];
                if (low >= (hi = stack[--count])) continue;
                int p = Sort.partition(key, value, low, hi);
                stack[count++] = p - 1;
                stack[count++] = low;
                stack[count++] = hi;
                stack[count++] = p + 1;
            }
        }

        private static int partition(int[] array, float[] value, int low, int hi) {
            int pivot = array[hi];
            int i = low;
            for (int j = low; j < hi; ++j) {
                if (array[j] > pivot) continue;
                Sort.swap(array, value, i, j);
                ++i;
            }
            Sort.swap(array, value, i, hi);
            return i;
        }

        private static void swap(int[] array, float[] value, int a, int b) {
            int tmp = array[a];
            array[a] = array[b];
            array[b] = tmp;
            float tmpv = value[a];
            value[a] = value[b];
            value[b] = tmpv;
        }
    }

    static class ProgressSet
    extends SplineSet {
        boolean mNoMethod = false;

        ProgressSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            if (view instanceof MotionLayout) {
                ((MotionLayout)view).setProgress(this.get(t));
            } else {
                if (this.mNoMethod) {
                    return;
                }
                Method method = null;
                try {
                    method = view.getClass().getMethod("setProgress", Float.TYPE);
                }
                catch (NoSuchMethodException e) {
                    this.mNoMethod = true;
                }
                if (method != null) {
                    try {
                        method.invoke((Object)view, Float.valueOf(this.get(t)));
                    }
                    catch (IllegalAccessException e) {
                        Log.e((String)SplineSet.TAG, (String)"unable to setProgress", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        Log.e((String)SplineSet.TAG, (String)"unable to setProgress", (Throwable)e);
                    }
                }
            }
        }
    }

    static class CustomSet
    extends SplineSet {
        String mAttributeName;
        SparseArray<ConstraintAttribute> mConstraintAttributeList;
        float[] mTempValues;

        public CustomSet(String attribute, SparseArray<ConstraintAttribute> attrList) {
            this.mAttributeName = attribute.split(",")[1];
            this.mConstraintAttributeList = attrList;
        }

        @Override
        public void setup(int curveType) {
            int size = this.mConstraintAttributeList.size();
            int dimensionality = ((ConstraintAttribute)this.mConstraintAttributeList.valueAt(0)).noOfInterpValues();
            double[] time = new double[size];
            this.mTempValues = new float[dimensionality];
            double[][] values = new double[size][dimensionality];
            for (int i = 0; i < size; ++i) {
                int key = this.mConstraintAttributeList.keyAt(i);
                ConstraintAttribute ca = (ConstraintAttribute)this.mConstraintAttributeList.valueAt(i);
                time[i] = (double)key * 0.01;
                ca.getValuesToInterpolate(this.mTempValues);
                for (int k = 0; k < this.mTempValues.length; ++k) {
                    values[i][k] = this.mTempValues[k];
                }
            }
            this.mCurveFit = CurveFit.get(curveType, time, values);
        }

        @Override
        public void setPoint(int position, float value) {
            throw new RuntimeException("don't call for custom attribute call setPoint(pos, ConstraintAttribute)");
        }

        public void setPoint(int position, ConstraintAttribute value) {
            this.mConstraintAttributeList.append(position, (Object)value);
        }

        @Override
        public void setProperty(View view, float t) {
            this.mCurveFit.getPos((double)t, this.mTempValues);
            ((ConstraintAttribute)this.mConstraintAttributeList.valueAt(0)).setInterpolatedValue(view, this.mTempValues);
        }
    }

    static class TranslationZset
    extends SplineSet {
        TranslationZset() {
        }

        @Override
        public void setProperty(View view, float t) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setTranslationZ(this.get(t));
            }
        }
    }

    static class TranslationYset
    extends SplineSet {
        TranslationYset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setTranslationY(this.get(t));
        }
    }

    static class TranslationXset
    extends SplineSet {
        TranslationXset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setTranslationX(this.get(t));
        }
    }

    static class ScaleYset
    extends SplineSet {
        ScaleYset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setScaleY(this.get(t));
        }
    }

    static class ScaleXset
    extends SplineSet {
        ScaleXset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setScaleX(this.get(t));
        }
    }

    static class PathRotate
    extends SplineSet {
        PathRotate() {
        }

        @Override
        public void setProperty(View view, float t) {
        }

        public void setPathRotate(View view, float t, double dx, double dy) {
            view.setRotation(this.get(t) + (float)Math.toDegrees(Math.atan2(dy, dx)));
        }
    }

    static class PivotYset
    extends SplineSet {
        PivotYset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setPivotY(this.get(t));
        }
    }

    static class PivotXset
    extends SplineSet {
        PivotXset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setPivotX(this.get(t));
        }
    }

    static class RotationYset
    extends SplineSet {
        RotationYset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setRotationY(this.get(t));
        }
    }

    static class RotationXset
    extends SplineSet {
        RotationXset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setRotationX(this.get(t));
        }
    }

    static class RotationSet
    extends SplineSet {
        RotationSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setRotation(this.get(t));
        }
    }

    static class AlphaSet
    extends SplineSet {
        AlphaSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setAlpha(this.get(t));
        }
    }

    static class ElevationSet
    extends SplineSet {
        ElevationSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setElevation(this.get(t));
            }
        }
    }
}

