/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.StyleRes;
import android.support.v7.view.menu.ActionMenuItemView;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.view.menu.MenuItemImpl;
import android.support.v7.view.menu.MenuPresenter;
import android.support.v7.view.menu.MenuView;
import android.support.v7.widget.ActionMenuPresenter;
import android.support.v7.widget.LinearLayoutCompat;
import android.support.v7.widget.ViewUtils;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;

public class ActionMenuView
extends LinearLayoutCompat
implements MenuBuilder.ItemInvoker,
MenuView {
    private static final String TAG = "ActionMenuView";
    static final int MIN_CELL_SIZE = 56;
    static final int GENERATED_ITEM_PADDING = 4;
    private MenuBuilder mMenu;
    private Context mPopupContext;
    private int mPopupTheme;
    private boolean mReserveOverflow;
    private ActionMenuPresenter mPresenter;
    private MenuPresenter.Callback mActionMenuPresenterCallback;
    MenuBuilder.Callback mMenuBuilderCallback;
    private boolean mFormatItems;
    private int mFormatItemsWidth;
    private int mMinCellSize;
    private int mGeneratedItemPadding;
    OnMenuItemClickListener mOnMenuItemClickListener;

    public ActionMenuView(Context context) {
        this(context, null);
    }

    public ActionMenuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setBaselineAligned(false);
        float density = context.getResources().getDisplayMetrics().density;
        this.mMinCellSize = (int)(56.0f * density);
        this.mGeneratedItemPadding = (int)(4.0f * density);
        this.mPopupContext = context;
        this.mPopupTheme = 0;
    }

    public void setPopupTheme(@StyleRes int resId) {
        if (this.mPopupTheme != resId) {
            this.mPopupTheme = resId;
            this.mPopupContext = resId == 0 ? this.getContext() : new ContextThemeWrapper(this.getContext(), resId);
        }
    }

    public int getPopupTheme() {
        return this.mPopupTheme;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setPresenter(ActionMenuPresenter presenter) {
        this.mPresenter = presenter;
        this.mPresenter.setMenuView(this);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mPresenter != null) {
            this.mPresenter.updateMenuView(false);
            if (this.mPresenter.isOverflowMenuShowing()) {
                this.mPresenter.hideOverflowMenu();
                this.mPresenter.showOverflowMenu();
            }
        }
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener listener) {
        this.mOnMenuItemClickListener = listener;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean wasFormatted = this.mFormatItems;
        boolean bl = this.mFormatItems = View.MeasureSpec.getMode((int)widthMeasureSpec) == 0x40000000;
        if (wasFormatted != this.mFormatItems) {
            this.mFormatItemsWidth = 0;
        }
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.mFormatItems && this.mMenu != null && widthSize != this.mFormatItemsWidth) {
            this.mFormatItemsWidth = widthSize;
            this.mMenu.onItemsChanged(true);
        }
        int childCount = this.getChildCount();
        if (this.mFormatItems && childCount > 0) {
            this.onMeasureExactFormat(widthMeasureSpec, heightMeasureSpec);
        } else {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                lp.rightMargin = 0;
                lp.leftMargin = 0;
            }
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void onMeasureExactFormat(int widthMeasureSpec, int heightMeasureSpec) {
        boolean singleItem;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthPadding = this.getPaddingLeft() + this.getPaddingRight();
        int heightPadding = this.getPaddingTop() + this.getPaddingBottom();
        int itemHeightSpec = ActionMenuView.getChildMeasureSpec((int)heightMeasureSpec, (int)heightPadding, (int)-2);
        int cellCount = (widthSize -= widthPadding) / this.mMinCellSize;
        int cellSizeRemaining = widthSize % this.mMinCellSize;
        if (cellCount == 0) {
            this.setMeasuredDimension(widthSize, 0);
            return;
        }
        int cellSize = this.mMinCellSize + cellSizeRemaining / cellCount;
        int cellsRemaining = cellCount;
        int maxChildHeight = 0;
        int maxCellsUsed = 0;
        int expandableItemCount = 0;
        int visibleItemCount = 0;
        boolean hasOverflow = false;
        long smallestItemsAt = 0L;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            boolean isGeneratedItem = child instanceof ActionMenuItemView;
            ++visibleItemCount;
            if (isGeneratedItem) {
                child.setPadding(this.mGeneratedItemPadding, 0, this.mGeneratedItemPadding, 0);
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.expanded = false;
            lp.extraPixels = 0;
            lp.cellsUsed = 0;
            lp.expandable = false;
            lp.leftMargin = 0;
            lp.rightMargin = 0;
            lp.preventEdgeOffset = isGeneratedItem && ((ActionMenuItemView)child).hasText();
            int cellsAvailable = lp.isOverflowButton ? 1 : cellsRemaining;
            int cellsUsed = ActionMenuView.measureChildForCells(child, cellSize, cellsAvailable, itemHeightSpec, heightPadding);
            maxCellsUsed = Math.max(maxCellsUsed, cellsUsed);
            if (lp.expandable) {
                ++expandableItemCount;
            }
            if (lp.isOverflowButton) {
                hasOverflow = true;
            }
            cellsRemaining -= cellsUsed;
            maxChildHeight = Math.max(maxChildHeight, child.getMeasuredHeight());
            if (cellsUsed != 1) continue;
            smallestItemsAt |= (long)(1 << i);
        }
        boolean centerSingleExpandedItem = hasOverflow && visibleItemCount == 2;
        boolean needsExpansion = false;
        while (expandableItemCount > 0 && cellsRemaining > 0) {
            LayoutParams lp;
            View child;
            int i;
            int minCells = Integer.MAX_VALUE;
            long minCellsAt = 0L;
            int minCellsItemCount = 0;
            for (i = 0; i < childCount; ++i) {
                child = this.getChildAt(i);
                lp = (LayoutParams)child.getLayoutParams();
                if (!lp.expandable) continue;
                if (lp.cellsUsed < minCells) {
                    minCells = lp.cellsUsed;
                    minCellsAt = 1 << i;
                    minCellsItemCount = 1;
                    continue;
                }
                if (lp.cellsUsed != minCells) continue;
                minCellsAt |= (long)(1 << i);
                ++minCellsItemCount;
            }
            smallestItemsAt |= minCellsAt;
            if (minCellsItemCount > cellsRemaining) break;
            ++minCells;
            for (i = 0; i < childCount; ++i) {
                child = this.getChildAt(i);
                lp = (LayoutParams)child.getLayoutParams();
                if ((minCellsAt & (long)(1 << i)) == 0L) {
                    if (lp.cellsUsed != minCells) continue;
                    smallestItemsAt |= (long)(1 << i);
                    continue;
                }
                if (centerSingleExpandedItem && lp.preventEdgeOffset && cellsRemaining == 1) {
                    child.setPadding(this.mGeneratedItemPadding + cellSize, 0, this.mGeneratedItemPadding, 0);
                }
                ++lp.cellsUsed;
                lp.expanded = true;
                --cellsRemaining;
            }
            needsExpansion = true;
        }
        boolean bl = singleItem = !hasOverflow && visibleItemCount == 1;
        if (cellsRemaining > 0 && smallestItemsAt != 0L && (cellsRemaining < visibleItemCount - 1 || singleItem || maxCellsUsed > 1)) {
            float expandCount = Long.bitCount(smallestItemsAt);
            if (!singleItem) {
                if ((smallestItemsAt & 1L) != 0L) {
                    LayoutParams lp = (LayoutParams)this.getChildAt(0).getLayoutParams();
                    if (!lp.preventEdgeOffset) {
                        expandCount -= 0.5f;
                    }
                }
                if ((smallestItemsAt & (long)(1 << childCount - 1)) != 0L) {
                    LayoutParams lp = (LayoutParams)this.getChildAt(childCount - 1).getLayoutParams();
                    if (!lp.preventEdgeOffset) {
                        expandCount -= 0.5f;
                    }
                }
            }
            int extraPixels = expandCount > 0.0f ? (int)((float)(cellsRemaining * cellSize) / expandCount) : 0;
            for (int i = 0; i < childCount; ++i) {
                if ((smallestItemsAt & (long)(1 << i)) == 0L) continue;
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (child instanceof ActionMenuItemView) {
                    lp.extraPixels = extraPixels;
                    lp.expanded = true;
                    if (i == 0 && !lp.preventEdgeOffset) {
                        lp.leftMargin = -extraPixels / 2;
                    }
                    needsExpansion = true;
                    continue;
                }
                if (lp.isOverflowButton) {
                    lp.extraPixels = extraPixels;
                    lp.expanded = true;
                    lp.rightMargin = -extraPixels / 2;
                    needsExpansion = true;
                    continue;
                }
                if (i != 0) {
                    lp.leftMargin = extraPixels / 2;
                }
                if (i == childCount - 1) continue;
                lp.rightMargin = extraPixels / 2;
            }
            cellsRemaining = 0;
        }
        if (needsExpansion) {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (!lp.expanded) continue;
                int width = lp.cellsUsed * cellSize + lp.extraPixels;
                child.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), itemHeightSpec);
            }
        }
        if (heightMode != 0x40000000) {
            heightSize = maxChildHeight;
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    static int measureChildForCells(View child, int cellSize, int cellsRemaining, int parentHeightMeasureSpec, int parentHeightPadding) {
        boolean expandable;
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int childHeightSize = View.MeasureSpec.getSize((int)parentHeightMeasureSpec) - parentHeightPadding;
        int childHeightMode = View.MeasureSpec.getMode((int)parentHeightMeasureSpec);
        int childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)childHeightSize, (int)childHeightMode);
        ActionMenuItemView itemView = child instanceof ActionMenuItemView ? (ActionMenuItemView)child : null;
        boolean hasText = itemView != null && itemView.hasText();
        int cellsUsed = 0;
        if (!(cellsRemaining <= 0 || hasText && cellsRemaining < 2)) {
            int childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)(cellSize * cellsRemaining), (int)Integer.MIN_VALUE);
            child.measure(childWidthSpec, childHeightSpec);
            int measuredWidth = child.getMeasuredWidth();
            cellsUsed = measuredWidth / cellSize;
            if (measuredWidth % cellSize != 0) {
                ++cellsUsed;
            }
            if (hasText && cellsUsed < 2) {
                cellsUsed = 2;
            }
        }
        lp.expandable = expandable = !lp.isOverflowButton && hasText;
        lp.cellsUsed = cellsUsed;
        int targetWidth = cellsUsed * cellSize;
        child.measure(View.MeasureSpec.makeMeasureSpec((int)targetWidth, (int)0x40000000), childHeightSpec);
        return cellsUsed;
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int height;
        int width;
        int i;
        if (!this.mFormatItems) {
            super.onLayout(changed, left, top, right, bottom);
            return;
        }
        int childCount = this.getChildCount();
        int midVertical = (bottom - top) / 2;
        int dividerWidth = this.getDividerWidth();
        int overflowWidth = 0;
        int nonOverflowWidth = 0;
        int nonOverflowCount = 0;
        int widthRemaining = right - left - this.getPaddingRight() - this.getPaddingLeft();
        boolean hasOverflow = false;
        boolean isLayoutRtl = ViewUtils.isLayoutRtl((View)this);
        for (int i2 = 0; i2 < childCount; ++i2) {
            View v = this.getChildAt(i2);
            if (v.getVisibility() == 8) continue;
            LayoutParams p = (LayoutParams)v.getLayoutParams();
            if (p.isOverflowButton) {
                int r;
                int l;
                overflowWidth = v.getMeasuredWidth();
                if (this.hasSupportDividerBeforeChildAt(i2)) {
                    overflowWidth += dividerWidth;
                }
                int height2 = v.getMeasuredHeight();
                if (isLayoutRtl) {
                    l = this.getPaddingLeft() + p.leftMargin;
                    r = l + overflowWidth;
                } else {
                    r = this.getWidth() - this.getPaddingRight() - p.rightMargin;
                    l = r - overflowWidth;
                }
                int t = midVertical - height2 / 2;
                int b = t + height2;
                v.layout(l, t, r, b);
                widthRemaining -= overflowWidth;
                hasOverflow = true;
                continue;
            }
            int size = v.getMeasuredWidth() + p.leftMargin + p.rightMargin;
            nonOverflowWidth += size;
            widthRemaining -= size;
            if (this.hasSupportDividerBeforeChildAt(i2)) {
                nonOverflowWidth += dividerWidth;
            }
            ++nonOverflowCount;
        }
        if (childCount == 1 && !hasOverflow) {
            View v = this.getChildAt(0);
            int width2 = v.getMeasuredWidth();
            int height3 = v.getMeasuredHeight();
            int midHorizontal = (right - left) / 2;
            int l = midHorizontal - width2 / 2;
            int t = midVertical - height3 / 2;
            v.layout(l, t, l + width2, t + height3);
            return;
        }
        int spacerCount = nonOverflowCount - (hasOverflow ? 0 : 1);
        int spacerSize = Math.max(0, spacerCount > 0 ? widthRemaining / spacerCount : 0);
        if (isLayoutRtl) {
            int startRight = this.getWidth() - this.getPaddingRight();
            for (i = 0; i < childCount; ++i) {
                View v = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)v.getLayoutParams();
                if (v.getVisibility() == 8 || lp.isOverflowButton) continue;
                width = v.getMeasuredWidth();
                height = v.getMeasuredHeight();
                int t = midVertical - height / 2;
                v.layout((startRight -= lp.rightMargin) - width, t, startRight, t + height);
                startRight -= width + lp.leftMargin + spacerSize;
            }
        } else {
            int startLeft = this.getPaddingLeft();
            for (i = 0; i < childCount; ++i) {
                View v = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)v.getLayoutParams();
                if (v.getVisibility() == 8 || lp.isOverflowButton) continue;
                width = v.getMeasuredWidth();
                height = v.getMeasuredHeight();
                int t = midVertical - height / 2;
                v.layout(startLeft += lp.leftMargin, t, startLeft + width, t + height);
                startLeft += width + lp.rightMargin + spacerSize;
            }
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.dismissPopupMenus();
    }

    public void setOverflowIcon(@Nullable Drawable icon) {
        this.getMenu();
        this.mPresenter.setOverflowIcon(icon);
    }

    @Nullable
    public Drawable getOverflowIcon() {
        this.getMenu();
        return this.mPresenter.getOverflowIcon();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isOverflowReserved() {
        return this.mReserveOverflow;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setOverflowReserved(boolean reserveOverflow) {
        this.mReserveOverflow = reserveOverflow;
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        LayoutParams params = new LayoutParams(-2, -2);
        params.gravity = 16;
        return params;
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (p != null) {
            LayoutParams result;
            LayoutParams layoutParams = result = p instanceof LayoutParams ? new LayoutParams((LayoutParams)p) : new LayoutParams(p);
            if (result.gravity <= 0) {
                result.gravity = 16;
            }
            return result;
        }
        return this.generateDefaultLayoutParams();
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p != null && p instanceof LayoutParams;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public LayoutParams generateOverflowButtonLayoutParams() {
        LayoutParams result = this.generateDefaultLayoutParams();
        result.isOverflowButton = true;
        return result;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean invokeItem(MenuItemImpl item) {
        return this.mMenu.performItemAction((MenuItem)item, 0);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getWindowAnimations() {
        return 0;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void initialize(MenuBuilder menu) {
        this.mMenu = menu;
    }

    public Menu getMenu() {
        if (this.mMenu == null) {
            Context context = this.getContext();
            this.mMenu = new MenuBuilder(context);
            this.mMenu.setCallback(new MenuBuilderCallback());
            this.mPresenter = new ActionMenuPresenter(context);
            this.mPresenter.setReserveOverflow(true);
            this.mPresenter.setCallback(this.mActionMenuPresenterCallback != null ? this.mActionMenuPresenterCallback : new ActionMenuPresenterCallback());
            this.mMenu.addMenuPresenter(this.mPresenter, this.mPopupContext);
            this.mPresenter.setMenuView(this);
        }
        return this.mMenu;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setMenuCallbacks(MenuPresenter.Callback pcb, MenuBuilder.Callback mcb) {
        this.mActionMenuPresenterCallback = pcb;
        this.mMenuBuilderCallback = mcb;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MenuBuilder peekMenu() {
        return this.mMenu;
    }

    public boolean showOverflowMenu() {
        return this.mPresenter != null && this.mPresenter.showOverflowMenu();
    }

    public boolean hideOverflowMenu() {
        return this.mPresenter != null && this.mPresenter.hideOverflowMenu();
    }

    public boolean isOverflowMenuShowing() {
        return this.mPresenter != null && this.mPresenter.isOverflowMenuShowing();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isOverflowMenuShowPending() {
        return this.mPresenter != null && this.mPresenter.isOverflowMenuShowPending();
    }

    public void dismissPopupMenus() {
        if (this.mPresenter != null) {
            this.mPresenter.dismissPopupMenus();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected boolean hasSupportDividerBeforeChildAt(int childIndex) {
        if (childIndex == 0) {
            return false;
        }
        View childBefore = this.getChildAt(childIndex - 1);
        View child = this.getChildAt(childIndex);
        boolean result = false;
        if (childIndex < this.getChildCount() && childBefore instanceof ActionMenuChildView) {
            result |= ((ActionMenuChildView)childBefore).needsDividerAfter();
        }
        if (childIndex > 0 && child instanceof ActionMenuChildView) {
            result |= ((ActionMenuChildView)child).needsDividerBefore();
        }
        return result;
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setExpandedActionViewsExclusive(boolean exclusive) {
        this.mPresenter.setExpandedActionViewsExclusive(exclusive);
    }

    public static class LayoutParams
    extends LinearLayoutCompat.LayoutParams {
        @ViewDebug.ExportedProperty
        public boolean isOverflowButton;
        @ViewDebug.ExportedProperty
        public int cellsUsed;
        @ViewDebug.ExportedProperty
        public int extraPixels;
        @ViewDebug.ExportedProperty
        public boolean expandable;
        @ViewDebug.ExportedProperty
        public boolean preventEdgeOffset;
        boolean expanded;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(ViewGroup.LayoutParams other) {
            super(other);
        }

        public LayoutParams(LayoutParams other) {
            super((ViewGroup.LayoutParams)other);
            this.isOverflowButton = other.isOverflowButton;
        }

        public LayoutParams(int width, int height) {
            super(width, height);
            this.isOverflowButton = false;
        }

        LayoutParams(int width, int height, boolean isOverflowButton) {
            super(width, height);
            this.isOverflowButton = isOverflowButton;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface ActionMenuChildView {
        public boolean needsDividerBefore();

        public boolean needsDividerAfter();
    }

    private static class ActionMenuPresenterCallback
    implements MenuPresenter.Callback {
        ActionMenuPresenterCallback() {
        }

        @Override
        public void onCloseMenu(MenuBuilder menu, boolean allMenusAreClosing) {
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder subMenu) {
            return false;
        }
    }

    private class MenuBuilderCallback
    implements MenuBuilder.Callback {
        MenuBuilderCallback() {
        }

        @Override
        public boolean onMenuItemSelected(MenuBuilder menu, MenuItem item) {
            return ActionMenuView.this.mOnMenuItemClickListener != null && ActionMenuView.this.mOnMenuItemClickListener.onMenuItemClick(item);
        }

        @Override
        public void onMenuModeChange(MenuBuilder menu) {
            if (ActionMenuView.this.mMenuBuilderCallback != null) {
                ActionMenuView.this.mMenuBuilderCallback.onMenuModeChange(menu);
            }
        }
    }

    public static interface OnMenuItemClickListener {
        public boolean onMenuItemClick(MenuItem var1);
    }
}

