/*
 * Decompiled with CFR 0.152.
 */
package com.android.component.mvp.fragment.config;

import android.app.Activity;
import com.android.component.mvp.fragment.ComponentWrapper;
import com.android.component.mvp.fragment.IComponent;
import com.android.component.mvp.fragment.config.BaseContainerConfig;
import com.android.component.mvp.fragment.config.ConfigClassFactory;
import com.android.component.mvp.fragment.config.ContainerConfig;
import com.android.component.mvp.fragment.container.AbstractComponentContainer;
import com.android.component.mvp.fragment.container.ContainerWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ConfigMaker {
    private static ConfigMaker maker;
    private ConfigClassFactory mFactoty;
    private Map<Class<? extends Activity>, ContainerWrapper> mContainers = new HashMap<Class<? extends Activity>, ContainerWrapper>();
    private Map<Class<? extends IComponent>, ComponentWrapper> mComponents = new HashMap<Class<? extends IComponent>, ComponentWrapper>();

    private ConfigMaker(ConfigClassFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory is null >> ?.");
        }
        this.mFactoty = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigMaker of(ConfigClassFactory factory) {
        if (maker != null) return maker;
        Class<ConfigMaker> clazz = ConfigMaker.class;
        synchronized (ConfigMaker.class) {
            if (maker != null) return maker;
            maker = new ConfigMaker(factory);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return maker;
        }
    }

    public <T extends ContainerWrapper> T containerWrapper(Class<? extends Activity> activityClz) {
        Class<? extends ContainerWrapper> containerClz;
        if (activityClz == null) {
            return null;
        }
        ContainerWrapper containerWrapper = this.mContainers.get(activityClz);
        if (containerWrapper == null && (containerClz = this.ofContainer(activityClz)) != null) {
            try {
                containerWrapper = containerClz.newInstance();
                this.mContainers.put(activityClz, containerWrapper);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return (T)containerWrapper;
    }

    public <T extends IComponent> T ofComponent(Class<T> clz) {
        return this.wrapper(clz).instance();
    }

    public <T extends IComponent> ComponentWrapper<T> wrapper(Class<T> componentClz) {
        ComponentWrapper wrapper = this.mComponents.get(componentClz);
        if (wrapper == null) {
            wrapper = this.mFactoty.create(componentClz);
            if (wrapper == null) {
                throw new RuntimeException("Component: " + componentClz.getSimpleName() + " Wrapper is null?");
            }
            this.mComponents.put(componentClz, wrapper);
        }
        return wrapper;
    }

    public Class<? extends ComponentWrapper> ofComponentWrapper(Class<? extends IComponent> componentClz) {
        return this.mFactoty.componentWrapperClass(componentClz);
    }

    private Class<? extends ContainerWrapper> ofContainer(Class<? extends Activity> activityClz) {
        return this.mFactoty.containerClass(activityClz);
    }

    public Class<? extends BaseContainerConfig> ofConfig(Class<? extends AbstractComponentContainer> containerClz) {
        return this.mFactoty.containerConfigClass(containerClz);
    }

    public List<Class<? extends IComponent>> ofComponents(Class<? extends ContainerConfig> containerConfigClz) {
        return this.mFactoty.componentClasses(containerConfigClz);
    }
}

