/*
 * Decompiled with CFR 0.152.
 */
package com.android.component.mvp.fragment;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.android.component.mvp.fragment.IComponent;
import com.android.component.mvp.fragment.IComponentBehavior;
import com.android.component.mvp.fragment.container.IComponentContainer;
import com.android.component.mvp.mvp.MvpSniper;
import com.android.component.mvp.mvp.view.MvpView;

public abstract class MTComponent
extends Fragment
implements IComponent,
MvpView {
    protected View mRootView;
    protected IComponentContainer mAttachContainer;
    protected Activity mActivity;
    protected Handler mHandler = new Handler();
    protected boolean isContainerInflated = false;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        MvpSniper.bind(this);
        this.mActivity = this.getActivity();
    }

    @Override
    public Fragment getContent() {
        return this;
    }

    @Override
    public void showSelf() {
        if (!this.getFragmentManager().isDestroyed() && this.isHidden()) {
            this.getFragmentManager().beginTransaction().show((Fragment)this).commitAllowingStateLoss();
        }
    }

    @Override
    public void hideSelf() {
        if (!this.getFragmentManager().isDestroyed() && !this.isHidden()) {
            this.getFragmentManager().beginTransaction().hide((Fragment)this).commitAllowingStateLoss();
        }
    }

    @Override
    public void attachContainer(@NonNull IComponentContainer container) {
        this.mAttachContainer = container;
    }

    @Nullable
    protected <V extends View> V findViewById(int id) {
        if (this.mRootView != null) {
            return (V)this.mRootView.findViewById(id);
        }
        return null;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(this.ofLayoutId(), container, false);
        this.initView(this.mRootView);
        return this.mRootView;
    }

    protected void finishActivity() {
        if (this.mActivity != null && !this.mActivity.isFinishing()) {
            this.mActivity.finish();
        }
    }

    public <B extends IComponentBehavior> B findBehavior(Class<B> bClass) {
        if (this.mAttachContainer != null) {
            return this.mAttachContainer.findBehavior(bClass);
        }
        return null;
    }

    public <C extends IComponent> C getComponent(Class<C> pClass) {
        if (this.mAttachContainer != null) {
            return this.mAttachContainer.getComponent(pClass);
        }
        return null;
    }

    @Override
    public IComponentContainer getContainer() {
        return this.mAttachContainer;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.mAttachContainer != null) {
            this.mAttachContainer.onComponentViewCreated(this.getClass());
        }
    }

    @Override
    public void onContainerInflated() {
        this.isContainerInflated = true;
    }

    protected abstract int ofLayoutId();

    protected abstract void initView(View var1);
}

