package com.android.component.mvp.mvp;


import android.app.Activity;
import android.support.v4.app.Fragment;
import com.android.component.mvp.mvp.presenter.PresenterBinder;

import java.util.HashMap;
import java.util.Map;

/**
 * @data         2018/7/20
 * @author       zhuqian(zaki)
 * @Description  bind方法注入
 */
public final class MvpSniper {
    //存储$$PresenterBinder，不需要每次都反射生成
    private static final Map<String, PresenterBinder> mPresenterBinders = new HashMap<>();

    /**
     * Fragment 注入，扫描注解，一般在onCreate()添加
     *
     * @param fragment
     */
    public static void bind(Fragment fragment) throws IllegalArgumentException {
        bindInner(fragment);
    }

    /**
     * Activity 注入，扫描注解，一般在onCreate()添加
     *
     * @param activity
     */
    public static void bind(Activity activity) throws IllegalArgumentException {
        bindInner(activity);
    }

    private static void bindInner(Object host) throws IllegalArgumentException {
        if (host == null) {
            throw new IllegalArgumentException("bind host == null ?");
        }

        try {
            Class clazz = host.getClass();
            String className = clazz.getName();
            PresenterBinder binder = mPresenterBinders.get(className);
            if (binder == null) {
                Class<?> binderClass = Class.forName(className + "$$PresenterBinder");
                binder = (PresenterBinder) binderClass.newInstance();
                mPresenterBinders.put(className, binder);
            }

            if (binder != null) { //有可能没有添加过注解
                binder.bindPresenter(host);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
