package com.android.component.mvp.fragment.config;


import android.app.Activity;

import com.android.component.mvp.fragment.ComponentWrapper;
import com.android.component.mvp.fragment.IComponent;
import com.android.component.mvp.fragment.container.AbstractComponentContainer;
import com.android.component.mvp.fragment.container.ContainerWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @data         2018/7/25
 * @author       zhuqian(zaki)
 * @Description  这个类负责生成配置信息实例，单例
 */
public final class ConfigMaker {

    private static ConfigMaker maker;

    private ConfigClassFactory mFactoty;
    private Map<Class<? extends Activity>, ContainerWrapper> mContainers = new HashMap();
    private Map<Class<? extends IComponent>, ComponentWrapper> mComponents = new HashMap<>();

    private ConfigMaker(ConfigClassFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory is null >> ?.");
        }
        this.mFactoty = factory;
    }

    public static ConfigMaker of(ConfigClassFactory factory) {
        if (maker == null) {
            synchronized (ConfigMaker.class) {
                if (maker == null) {
                    maker = new ConfigMaker(factory);
                }
            }
        }

        return maker;
    }

    /**
     * 获取一个Container，每次调用都会生成一个Container实例
     *
     * @param activityClz
     * @param <T>
     * @return
     */
    public <T extends ContainerWrapper> T containerWrapper(Class<? extends Activity> activityClz) {
        if (activityClz == null) {
            return null;
        }

        ContainerWrapper containerWrapper = mContainers.get(activityClz);
        if (containerWrapper == null) { //判断缓存是否存在，存在直接返回
            Class<? extends ContainerWrapper> containerClz = ofContainer(activityClz);
            if (containerClz != null) {
                try {
                    containerWrapper = containerClz.newInstance();
                    mContainers.put(activityClz, containerWrapper);
                } catch (InstantiationException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return (T) containerWrapper;
    }

    public <T extends IComponent> T ofComponent(Class<T> clz) {
        return wrapper(clz).instance();
    }

    public <T extends IComponent> ComponentWrapper<T> wrapper(Class<T> componentClz) {
        ComponentWrapper<T> wrapper = mComponents.get(componentClz);

        if (wrapper == null) {
            wrapper = mFactoty.create(componentClz);

            if (wrapper == null) {
                throw new RuntimeException("Component: " + componentClz.getSimpleName() + " Wrapper is null?");
            }
            mComponents.put(componentClz, wrapper);
        }

        return wrapper;
    }

    public Class<? extends ComponentWrapper> ofComponentWrapper(Class<? extends IComponent> componentClz) {
        return mFactoty.componentWrapperClass(componentClz);
    }

    private Class<? extends ContainerWrapper> ofContainer(Class<? extends Activity> activityClz) {
        return mFactoty.containerClass(activityClz);
    }

    public Class<? extends BaseContainerConfig> ofConfig(Class<? extends AbstractComponentContainer> containerClz) {
        return mFactoty.containerConfigClass(containerClz);
    }

    public List<Class<? extends IComponent>> ofComponents(Class<? extends ContainerConfig> containerConfigClz) {
        return mFactoty.componentClasses(containerConfigClz);
    }

}
