package com.android.component.mvp.fragment.config;


import android.app.Activity;

import com.android.component.mvp.fragment.ComponentWrapper;
import com.android.component.mvp.fragment.IComponent;
import com.android.component.mvp.fragment.container.AbstractComponentContainer;
import com.android.component.mvp.fragment.container.ContainerWrapper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @data         2018/7/25
 * @author       zhuqian(zaki)
 * @Description  配置信息中心，管理class信息
 */
public abstract class ConfigClassFactory {
    //Activity的Container配置表
    protected Map<Class<? extends Activity>, Class<? extends ContainerWrapper>> mActivityConfigs = new ConcurrentHashMap<>();
    //Container的config配置表
    protected Map<Class<? extends AbstractComponentContainer>, Class<? extends BaseContainerConfig>> mContainerConfigs = new ConcurrentHashMap<>();
    //Config的component配置表
    protected Map<Class<? extends ContainerConfig>, List<Class<? extends IComponent>>> mCompontents = new ConcurrentHashMap<>();

    protected Map<Class<? extends IComponent>, Class<? extends ComponentWrapper>> mComponentWrappers = new ConcurrentHashMap<>();


    public ConfigClassFactory() {
        initClzMap();
    }

    public abstract void initClzMap();

    public Class<? extends BaseContainerConfig> containerConfigClass(Class<? extends AbstractComponentContainer> containerClz) {
        return mContainerConfigs.get(containerClz);
    }

    public Class<? extends ContainerWrapper> containerClass(Class<? extends Activity> activityClz) {
        return mActivityConfigs.get(activityClz);
    }

    public List<Class<? extends IComponent>> componentClasses(Class<? extends ContainerConfig> containerConfigClz) {
        return mCompontents.get(containerConfigClz);
    }

    public Class<? extends ComponentWrapper> componentWrapperClass(Class<? extends IComponent> componentClz) {
        return mComponentWrappers.get(componentClz);
    }

    public final <T extends IComponent> ComponentWrapper<T> create(Class<? extends IComponent> componentClz) {
        Class<? extends ComponentWrapper> wrapperClz = mComponentWrappers.get(componentClz);
        if (wrapperClz != null) {
            try {
                return wrapperClz.newInstance();
            } catch (InstantiationException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        return null;
    }

}
