package com.android.component.mvp.fragment;

import com.android.component.mvp.fragment.config.ComponentConfig;
import com.android.component.mvp.fragment.config.ContainerConfig;

import java.util.HashMap;
import java.util.Map;

public abstract class AbstractComponentWrapper<T extends IComponent> implements ComponentWrapper<T> {

    protected Map<Class<? extends ContainerConfig>, ComponentConfig> mConfigs = new HashMap();

    @Override
    public int resId(Class<? extends ContainerConfig> containerClz) {
        ComponentConfig config = mConfigs.get(containerClz);

        if (config != null) {
            return config.getResId();
        }
        return -1;
    }

    @Override
    public boolean initHidden(Class<? extends ContainerConfig> containerClz) {
        ComponentConfig config = mConfigs.get(containerClz);

        if (config != null) {
            return config.initHidden();
        }
        return false;
    }

    @Override
    public T instance() {
        return createInstance();
    }


    protected abstract T createInstance();
}
