/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.android.billingclient.api.BillingBroadcastManager;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.android.billingclient.util.BillingHelper;
import com.android.billingclient.util.ProxyBillingActivity;
import com.android.vending.billing.IInAppBillingService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

public class BillingClientImpl
extends BillingClient {
    private static final String TAG = "BillingClient";
    private static final int MAX_SKU_DETAILS_ITEMS_PER_REQUEST = 20;
    private static final String GET_SKU_DETAILS_ITEM_LIST = "ITEM_ID_LIST";
    private static final String KEY_VR = "vr";
    private static final String LIBRARY_VERSION_KEY = "libraryVersion";
    private static final String LIBRARY_VERSION = "dp-1";
    private final Handler mUiThreadHandler = new Handler();
    private final BillingBroadcastManager mBroadcastManager;
    private Context mContext;
    private IInAppBillingService mService;
    private ServiceConnection mServiceConnection;
    private boolean mSubscriptionsSupported;
    private boolean mSubscriptionUpdateSupported;
    private ExecutorService mExecutorService;
    private boolean mSetupDone;

    @UiThread
    BillingClientImpl(@NonNull Context context, @NonNull PurchasesUpdatedListener listener) {
        this.mContext = context.getApplicationContext();
        this.mBroadcastManager = new BillingBroadcastManager(this.mContext, listener);
    }

    @Override
    public int isFeatureSupported(String feature) {
        if (!this.isReady()) {
            return -1;
        }
        switch (feature) {
            case "subscriptions": {
                return this.mSubscriptionsSupported ? 0 : -2;
            }
            case "subscriptionsUpdate": {
                return this.mSubscriptionUpdateSupported ? 0 : -2;
            }
            case "inAppItemsOnVr": {
                return this.isBillingSupportedOnVr("inapp");
            }
            case "subscriptionsOnVr": {
                return this.isBillingSupportedOnVr("subs");
            }
        }
        BillingHelper.logWarn(TAG, "Unsupported feature: " + feature);
        return 5;
    }

    @Override
    public boolean isReady() {
        return this.mSetupDone && this.mService != null && this.mServiceConnection != null;
    }

    @Override
    public void startConnection(@NonNull BillingClientStateListener listener) {
        if (this.isReady()) {
            BillingHelper.logVerbose(TAG, "Service connection is valid. No need to re-initialize.");
            listener.onBillingSetupFinished(0);
            return;
        }
        this.mBroadcastManager.registerReceiver();
        BillingHelper.logVerbose(TAG, "Starting in-app billing setup.");
        this.mServiceConnection = new BillingServiceConnection(listener);
        Intent serviceIntent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
        serviceIntent.setPackage("com.android.vending");
        List intentServices = this.mContext.getPackageManager().queryIntentServices(serviceIntent, 0);
        if (intentServices != null && !intentServices.isEmpty()) {
            serviceIntent.putExtra(LIBRARY_VERSION_KEY, LIBRARY_VERSION);
            this.mContext.bindService(serviceIntent, this.mServiceConnection, 1);
        } else {
            BillingHelper.logVerbose(TAG, "Billing service unavailable on device.");
            listener.onBillingSetupFinished(3);
        }
    }

    @Override
    public void endConnection() {
        this.mBroadcastManager.destroy();
        this.mSetupDone = false;
        if (this.mServiceConnection != null) {
            BillingHelper.logVerbose(TAG, "Unbinding from service.");
            if (this.mContext != null) {
                this.mContext.unbindService(this.mServiceConnection);
                this.mContext = null;
            }
            this.mServiceConnection = null;
        }
        this.mService = null;
        if (this.mExecutorService != null) {
            this.mExecutorService.shutdownNow();
            this.mExecutorService = null;
        }
    }

    @Override
    public int launchBillingFlow(Activity activity, BillingFlowParams params) {
        boolean isSubscriptionUpdate;
        if (!this.isReady()) {
            return -1;
        }
        String skuType = params.getSkuType();
        String newSku = params.getSku();
        if (newSku == null) {
            BillingHelper.logWarn(TAG, "Please fix the input params. SKU can't be null.");
            return 5;
        }
        if (skuType == null) {
            BillingHelper.logWarn(TAG, "Please fix the input params. SkuType can't be null.");
            return 5;
        }
        if (params.getOldSkus() != null && params.getOldSkus().size() < 1) {
            BillingHelper.logWarn(TAG, "Please fix the input params. OldSkus size can't be 0.");
            return 5;
        }
        if (skuType.equals("subs") && !this.mSubscriptionsSupported) {
            return -2;
        }
        boolean bl = isSubscriptionUpdate = params.getOldSkus() != null;
        if (isSubscriptionUpdate && !this.mSubscriptionUpdateSupported) {
            return -2;
        }
        try {
            Bundle buyIntentBundle;
            BillingHelper.logVerbose(TAG, "Constructing buy intent for " + newSku + ", item type: " + skuType);
            if (params.hasExtraParams()) {
                Bundle extraParams = this.constructExtraParams(params);
                int apiVersion = params.getVrPurchaseFlow() ? 7 : 6;
                buyIntentBundle = this.mService.getBuyIntentExtraParams(apiVersion, this.mContext.getPackageName(), newSku, skuType, null, extraParams);
            } else {
                buyIntentBundle = isSubscriptionUpdate ? this.mService.getBuyIntentToReplaceSkus(5, this.mContext.getPackageName(), params.getOldSkus(), newSku, "subs", null) : this.mService.getBuyIntent(3, this.mContext.getPackageName(), newSku, skuType, null);
            }
            int responseCode = BillingHelper.getResponseCodeFromBundle(buyIntentBundle, TAG);
            if (responseCode != 0) {
                BillingHelper.logWarn(TAG, "Unable to buy item, Error response code: " + responseCode);
                return responseCode;
            }
            ResultReceiver purchaseResultReceiver = new ResultReceiver(this.mUiThreadHandler){

                protected void onReceiveResult(int responseCode, Bundle resultData) {
                    List<Purchase> purchases = resultData == null ? null : BillingHelper.extractPurchases(resultData);
                    BillingClientImpl.this.mBroadcastManager.getListener().onPurchasesUpdated(responseCode, purchases);
                }
            };
            Intent intent = new Intent((Context)activity, ProxyBillingActivity.class);
            intent.putExtra("receiver_extra", (Parcelable)purchaseResultReceiver);
            intent.putExtra("BUY_INTENT", buyIntentBundle.getParcelable("BUY_INTENT"));
            activity.startActivity(intent);
        }
        catch (RemoteException e) {
            String msg = "RemoteException while launching launching replace subscriptions flow: ; for sku: " + newSku + "; try to reconnect";
            BillingHelper.logWarn(TAG, msg);
            return -1;
        }
        return 0;
    }

    @Override
    public Purchase.PurchasesResult queryPurchases(String skuType) {
        if (!this.isReady()) {
            return new Purchase.PurchasesResult(null, -1);
        }
        return this.queryPurchasesInternal(skuType, false);
    }

    @Override
    public void querySkuDetailsAsync(final String skuType, final List<String> skuList, final SkuDetailsResponseListener listener) {
        if (!this.isReady()) {
            listener.onSkuDetailsResponse(new SkuDetails.SkuDetailsResult(null, -1));
        }
        if (skuList == null) {
            throw new IllegalArgumentException("Please provide a non-null list of SKUs to querySkuDetailsAsync()");
        }
        if (skuList.size() == 0) {
            throw new IllegalArgumentException("Please provide a non-zero length list of SKUs to querySkuDetailsAsync()");
        }
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                final SkuDetails.SkuDetailsResult result = BillingClientImpl.this.querySkuDetailsInternal(skuType, skuList);
                BillingClientImpl.this.postToUiThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onSkuDetailsResponse(result);
                    }
                });
            }
        });
    }

    @Override
    public void consumeAsync(final String purchaseToken, final ConsumeResponseListener listener) {
        if (!this.isReady()) {
            listener.onConsumeResponse(null, -1);
        }
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                BillingClientImpl.this.consumeInternal(purchaseToken, listener);
            }
        });
    }

    @Override
    public void queryPurchaseHistoryAsync(final String skuType, final PurchaseHistoryResponseListener listener) {
        if (!this.isReady()) {
            listener.onPurchaseHistoryResponse(new Purchase.PurchasesResult(null, -1));
        }
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                final Purchase.PurchasesResult result = BillingClientImpl.this.queryPurchasesInternal(skuType, true);
                BillingClientImpl.this.postToUiThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onPurchaseHistoryResponse(result);
                    }
                });
            }
        });
    }

    private Bundle constructExtraParams(BillingFlowParams params) {
        Bundle extraParams = new Bundle();
        if (params.getReplaceSkusProration()) {
            extraParams.putBoolean("replaceSkusProration", true);
        }
        if (params.getAccountId() != null) {
            extraParams.putString("accountId", params.getAccountId());
        }
        if (params.getVrPurchaseFlow()) {
            extraParams.putBoolean(KEY_VR, true);
        }
        if (params.getOldSkus() != null) {
            extraParams.putStringArrayList("skusToReplace", params.getOldSkus());
        }
        return extraParams;
    }

    private void executeAsync(Runnable runnable) {
        if (this.mExecutorService == null) {
            this.mExecutorService = Executors.newFixedThreadPool(BillingHelper.NUMBER_OF_CORES);
        }
        this.mExecutorService.submit(runnable);
    }

    private int isBillingSupportedOnVr(String skuType) {
        try {
            int supportedResult = this.mService.isBillingSupportedExtraParams(7, this.mContext.getPackageName(), skuType, this.generateVrBundle());
            return supportedResult == 0 ? 0 : -2;
        }
        catch (RemoteException e) {
            BillingHelper.logWarn(TAG, "RemoteException while checking if billing is supported; try to reconnect");
            return -1;
        }
    }

    private Bundle generateVrBundle() {
        Bundle result = new Bundle();
        result.putBoolean(KEY_VR, true);
        return result;
    }

    @VisibleForTesting
    SkuDetails.SkuDetailsResult querySkuDetailsInternal(String skuType, List<String> skuList) {
        ArrayList<SkuDetails> resultList = new ArrayList<SkuDetails>();
        int listSize = skuList.size();
        for (int startIndex = 0; startIndex < listSize; startIndex += 20) {
            Bundle skuDetails;
            int endIndex = startIndex + 20;
            if (endIndex > listSize) {
                endIndex = listSize;
            }
            ArrayList<String> curSkuList = new ArrayList<String>(skuList.subList(startIndex, endIndex));
            Bundle querySkus = new Bundle();
            querySkus.putStringArrayList(GET_SKU_DETAILS_ITEM_LIST, curSkuList);
            try {
                skuDetails = this.mService.getSkuDetails(3, this.mContext.getPackageName(), skuType, querySkus);
            }
            catch (RemoteException e) {
                String msg = "querySkuDetailsAsync got a remote exception (try to reconnect): " + (Object)((Object)e);
                BillingHelper.logWarn(TAG, msg);
                return new SkuDetails.SkuDetailsResult(null, -1);
            }
            if (skuDetails == null) {
                BillingHelper.logWarn(TAG, "querySkuDetailsAsync got null sku details list");
                return new SkuDetails.SkuDetailsResult(null, 4);
            }
            if (!skuDetails.containsKey("DETAILS_LIST")) {
                int responseCode = BillingHelper.getResponseCodeFromBundle(skuDetails, TAG);
                if (responseCode != 0) {
                    BillingHelper.logWarn(TAG, "getSkuDetails() failed. Response code: " + responseCode);
                    return new SkuDetails.SkuDetailsResult(resultList, responseCode);
                }
                BillingHelper.logWarn(TAG, "getSkuDetails() returned a bundle with neither an error nor a detail list.");
                return new SkuDetails.SkuDetailsResult(resultList, 6);
            }
            ArrayList skuDetailsJsonList = skuDetails.getStringArrayList("DETAILS_LIST");
            if (skuDetailsJsonList == null) {
                BillingHelper.logWarn(TAG, "querySkuDetailsAsync got null response list");
                return new SkuDetails.SkuDetailsResult(null, 4);
            }
            for (int i = 0; i < skuDetailsJsonList.size(); ++i) {
                SkuDetails currentSkuDetails;
                String thisResponse = (String)skuDetailsJsonList.get(i);
                try {
                    currentSkuDetails = new SkuDetails(thisResponse);
                }
                catch (JSONException e) {
                    BillingHelper.logWarn(TAG, "Got a JSON exception trying to decode SkuDetails");
                    return new SkuDetails.SkuDetailsResult(null, 6);
                }
                BillingHelper.logVerbose(TAG, "Got sku details: " + currentSkuDetails);
                resultList.add(currentSkuDetails);
            }
        }
        return new SkuDetails.SkuDetailsResult(resultList, 0);
    }

    private Purchase.PurchasesResult queryPurchasesInternal(String skuType, boolean queryHistory) {
        BillingHelper.logVerbose(TAG, "Querying owned items, item type: " + skuType + "; history: " + queryHistory);
        String continueToken = null;
        ArrayList<Purchase> resultList = new ArrayList<Purchase>();
        do {
            Bundle ownedItems;
            try {
                ownedItems = queryHistory ? this.mService.getPurchaseHistory(6, this.mContext.getPackageName(), skuType, continueToken, null) : this.mService.getPurchases(3, this.mContext.getPackageName(), skuType, continueToken);
            }
            catch (RemoteException e) {
                BillingHelper.logWarn(TAG, "Got exception trying to get purchases: " + (Object)((Object)e) + "; try to reconnect");
                return new Purchase.PurchasesResult(null, -1);
            }
            if (ownedItems == null) {
                BillingHelper.logWarn(TAG, "queryPurchases got null owned items list");
                return new Purchase.PurchasesResult(null, 6);
            }
            int responseCode = BillingHelper.getResponseCodeFromBundle(ownedItems, TAG);
            if (responseCode != 0) {
                BillingHelper.logWarn(TAG, "getPurchases() failed. Response code: " + responseCode);
                return new Purchase.PurchasesResult(null, responseCode);
            }
            if (!(ownedItems.containsKey("INAPP_PURCHASE_ITEM_LIST") && ownedItems.containsKey("INAPP_PURCHASE_DATA_LIST") && ownedItems.containsKey("INAPP_DATA_SIGNATURE_LIST"))) {
                BillingHelper.logWarn(TAG, "Bundle returned from getPurchases() doesn't contain required fields.");
                return new Purchase.PurchasesResult(null, 6);
            }
            ArrayList ownedSkus = ownedItems.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList purchaseDataList = ownedItems.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList signatureList = ownedItems.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            if (ownedSkus == null) {
                BillingHelper.logWarn(TAG, "Bundle returned from getPurchases() contains null SKUs list.");
                return new Purchase.PurchasesResult(null, 6);
            }
            if (purchaseDataList == null) {
                BillingHelper.logWarn(TAG, "Bundle returned from getPurchases() contains null purchases list.");
                return new Purchase.PurchasesResult(null, 6);
            }
            if (signatureList == null) {
                BillingHelper.logWarn(TAG, "Bundle returned from getPurchases() contains null signatures list.");
                return new Purchase.PurchasesResult(null, 6);
            }
            for (int i = 0; i < purchaseDataList.size(); ++i) {
                Purchase purchase;
                String purchaseData = (String)purchaseDataList.get(i);
                String signature = (String)signatureList.get(i);
                String sku = (String)ownedSkus.get(i);
                BillingHelper.logVerbose(TAG, "Sku is owned: " + sku);
                try {
                    purchase = new Purchase(purchaseData, signature);
                }
                catch (JSONException e) {
                    BillingHelper.logWarn(TAG, "Got an exception trying to decode the purchase: " + (Object)((Object)e));
                    return new Purchase.PurchasesResult(null, 6);
                }
                if (TextUtils.isEmpty((CharSequence)purchase.getPurchaseToken())) {
                    BillingHelper.logWarn(TAG, "BUG: empty/null token!");
                }
                resultList.add(purchase);
            }
            continueToken = ownedItems.getString("INAPP_CONTINUATION_TOKEN");
            BillingHelper.logVerbose(TAG, "Continuation token: " + continueToken);
        } while (!TextUtils.isEmpty((CharSequence)continueToken));
        return new Purchase.PurchasesResult(resultList, 0);
    }

    private void postToUiThread(Runnable runnable) {
        this.mUiThreadHandler.post(runnable);
    }

    @WorkerThread
    private void consumeInternal(final String purchaseToken, final ConsumeResponseListener listener) {
        try {
            BillingHelper.logVerbose(TAG, "Consuming purchase with token: " + purchaseToken);
            final int responseCode = this.mService.consumePurchase(3, this.mContext.getPackageName(), purchaseToken);
            if (responseCode == 0) {
                BillingHelper.logVerbose(TAG, "Successfully consumed purchase.");
                if (listener != null) {
                    this.postToUiThread(new Runnable(){

                        @Override
                        public void run() {
                            listener.onConsumeResponse(purchaseToken, responseCode);
                        }
                    });
                }
            } else {
                BillingHelper.logWarn(TAG, "Error consuming purchase with token. Response code: " + responseCode);
                this.postToUiThread(new Runnable(){

                    @Override
                    public void run() {
                        BillingHelper.logWarn(BillingClientImpl.TAG, "Error consuming purchase.");
                        listener.onConsumeResponse(purchaseToken, responseCode);
                    }
                });
            }
        }
        catch (RemoteException e) {
            this.postToUiThread(new Runnable(){

                @Override
                public void run() {
                    BillingHelper.logWarn(BillingClientImpl.TAG, "Error consuming purchase; ex: " + (Object)((Object)e));
                    listener.onConsumeResponse(purchaseToken, -1);
                }
            });
        }
    }

    private final class BillingServiceConnection
    implements ServiceConnection {
        private final BillingClientStateListener mListener;

        private BillingServiceConnection(BillingClientStateListener listener) {
            if (listener == null) {
                throw new RuntimeException("Please specify a listener to know when init is done.");
            }
            this.mListener = listener;
        }

        public void onServiceDisconnected(ComponentName name) {
            BillingHelper.logWarn(BillingClientImpl.TAG, "Billing service disconnected.");
            BillingClientImpl.this.mService = null;
            BillingClientImpl.this.mSetupDone = false;
            this.mListener.onBillingServiceDisconnected();
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            BillingHelper.logVerbose(BillingClientImpl.TAG, "Billing service connected.");
            BillingClientImpl.this.mService = IInAppBillingService.Stub.asInterface(service);
            String packageName = BillingClientImpl.this.mContext.getPackageName();
            BillingClientImpl.this.mSubscriptionsSupported = false;
            BillingClientImpl.this.mSubscriptionUpdateSupported = false;
            try {
                BillingHelper.logVerbose(BillingClientImpl.TAG, "Checking for in-app billing 3 support.");
                int response = BillingClientImpl.this.mService.isBillingSupported(3, packageName, "inapp");
                if (response != 0) {
                    BillingHelper.logWarn(BillingClientImpl.TAG, "Error checking for billing v3 support.");
                    this.mListener.onBillingSetupFinished(response);
                    return;
                }
                BillingHelper.logVerbose(BillingClientImpl.TAG, "In-app billing version 3 supported.");
                response = BillingClientImpl.this.mService.isBillingSupported(5, packageName, "subs");
                if (response == 0) {
                    BillingHelper.logVerbose(BillingClientImpl.TAG, "Subscription re-signup available..");
                    BillingClientImpl.this.mSubscriptionUpdateSupported = true;
                    BillingClientImpl.this.mSubscriptionsSupported = true;
                } else {
                    BillingHelper.logVerbose(BillingClientImpl.TAG, "Subscription re-signup not available.");
                    BillingClientImpl.this.mSubscriptionUpdateSupported = false;
                }
                if (!BillingClientImpl.this.mSubscriptionsSupported) {
                    response = BillingClientImpl.this.mService.isBillingSupported(3, packageName, "subs");
                    if (response == 0) {
                        BillingHelper.logVerbose(BillingClientImpl.TAG, "Subscriptions available.");
                        BillingClientImpl.this.mSubscriptionsSupported = true;
                    } else {
                        BillingHelper.logVerbose(BillingClientImpl.TAG, "Subscriptions not available.BillingResponse: " + response);
                    }
                }
                BillingClientImpl.this.mSetupDone = true;
            }
            catch (RemoteException e) {
                BillingHelper.logWarn(BillingClientImpl.TAG, "RemoteException while setting up in-app billing" + (Object)((Object)e));
                this.mListener.onBillingSetupFinished(-1);
                BillingClientImpl.this.mSetupDone = false;
                return;
            }
            BillingHelper.logVerbose(BillingClientImpl.TAG, "Billing client setup was successful!");
            this.mListener.onBillingSetupFinished(0);
        }
    }
}

