/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.play_billing;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.zzap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;

public final class zza {
    public static int zza = Runtime.getRuntime().availableProcessors();

    public static void zza(String string, String string2) {
        if (Log.isLoggable((String)string, (int)2)) {
            Log.v((String)string, (String)string2);
        }
    }

    public static void zzb(String string, String string2) {
        if (Log.isLoggable((String)string, (int)5)) {
            Log.w((String)string, (String)string2);
        }
    }

    public static int zza(Intent intent, String string) {
        return com.google.android.gms.internal.play_billing.zza.zzb(intent, string).getResponseCode();
    }

    public static BillingResult zzb(Intent intent, String string) {
        if (intent == null) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingHelper", "Got null intent!");
            return BillingResult.newBuilder().setResponseCode(6).setDebugMessage("An internal error occurred.").build();
        }
        return BillingResult.newBuilder().setResponseCode(com.google.android.gms.internal.play_billing.zza.zza(intent.getExtras(), string)).setDebugMessage(com.google.android.gms.internal.play_billing.zza.zzb(intent.getExtras(), string)).build();
    }

    public static int zza(Bundle bundle, String string) {
        if (bundle == null) {
            com.google.android.gms.internal.play_billing.zza.zzb(string, "Unexpected null bundle received!");
            return 6;
        }
        Object object = bundle.get("RESPONSE_CODE");
        if (object == null) {
            com.google.android.gms.internal.play_billing.zza.zza(string, "getResponseCodeFromBundle() got null response code, assuming OK");
            return 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        String string2 = String.valueOf(object.getClass().getName());
        com.google.android.gms.internal.play_billing.zza.zzb(string, string2.length() != 0 ? "Unexpected type for bundle response code: ".concat(string2) : new String("Unexpected type for bundle response code: "));
        return 6;
    }

    public static String zzb(Bundle bundle, String string) {
        String string2 = "";
        if (bundle == null) {
            com.google.android.gms.internal.play_billing.zza.zzb(string, "Unexpected null bundle received!");
            return string2;
        }
        Object object = bundle.get("DEBUG_MESSAGE");
        if (object == null) {
            com.google.android.gms.internal.play_billing.zza.zza(string, "getDebugMessageFromBundle() got null response code, assuming OK");
            return string2;
        }
        if (object instanceof String) {
            return (String)object;
        }
        String string3 = String.valueOf(object.getClass().getName());
        com.google.android.gms.internal.play_billing.zza.zzb(string, string3.length() != 0 ? "Unexpected type for debug message: ".concat(string3) : new String("Unexpected type for debug message: "));
        return string2;
    }

    public static List<Purchase> zza(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        ArrayList arrayList = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
        ArrayList arrayList2 = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
        ArrayList<Purchase> arrayList3 = new ArrayList<Purchase>();
        if (arrayList == null || arrayList2 == null) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingHelper", "Couldn't find purchase lists, trying to find single data.");
            String string = bundle.getString("INAPP_PURCHASE_DATA");
            String string2 = bundle.getString("INAPP_DATA_SIGNATURE");
            Purchase purchase = com.google.android.gms.internal.play_billing.zza.zzc(string, string2);
            if (purchase == null) {
                com.google.android.gms.internal.play_billing.zza.zzb("BillingHelper", "Couldn't find single purchase data as well.");
                return null;
            }
            arrayList3.add(purchase);
        } else {
            for (int i = 0; i < arrayList.size() && i < arrayList2.size(); ++i) {
                Purchase purchase = com.google.android.gms.internal.play_billing.zza.zzc((String)arrayList.get(i), (String)arrayList2.get(i));
                if (purchase == null) continue;
                arrayList3.add(purchase);
            }
        }
        return arrayList3;
    }

    public static Bundle zza(BillingFlowParams billingFlowParams, boolean bl, boolean bl2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("playBillingLibraryVersion", string);
        if (billingFlowParams.getReplaceSkusProrationMode() != 0) {
            bundle.putInt("prorationMode", billingFlowParams.getReplaceSkusProrationMode());
        }
        if (!TextUtils.isEmpty((CharSequence)billingFlowParams.zzb())) {
            bundle.putString("accountId", billingFlowParams.zzb());
        }
        if (!TextUtils.isEmpty((CharSequence)billingFlowParams.zzd())) {
            bundle.putString("obfuscatedProfileId", billingFlowParams.zzd());
        }
        if (billingFlowParams.getVrPurchaseFlow()) {
            bundle.putBoolean("vr", true);
        }
        if (!TextUtils.isEmpty((CharSequence)billingFlowParams.getOldSku())) {
            bundle.putStringArrayList("skusToReplace", new ArrayList<String>(Arrays.asList(billingFlowParams.getOldSku())));
        }
        if (!TextUtils.isEmpty((CharSequence)billingFlowParams.getOldSkuPurchaseToken())) {
            bundle.putString("oldSkuPurchaseToken", billingFlowParams.getOldSkuPurchaseToken());
        }
        if (bl && bl2) {
            bundle.putBoolean("enablePendingPurchases", true);
        }
        return bundle;
    }

    public static Bundle zza(boolean bl, boolean bl2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("playBillingLibraryVersion", string);
        if (bl && bl2) {
            bundle.putBoolean("enablePendingPurchases", true);
        }
        return bundle;
    }

    public static Bundle zza(int n, boolean bl, String string, @Nullable String string2, ArrayList<zzap> arrayList) {
        Bundle bundle = new Bundle();
        if (n >= 9) {
            bundle.putString("playBillingLibraryVersion", string);
        }
        if (n >= 9 && bl) {
            bundle.putBoolean("enablePendingPurchases", true);
        }
        if (n >= 13 && string2 != null) {
            bundle.putString("SKU_PACKAGE_NAME", string2);
        }
        if (n >= 14) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            boolean bl2 = false;
            ArrayList<zzap> arrayList3 = arrayList;
            int n2 = arrayList3.size();
            int n3 = 0;
            while (n3 < n2) {
                zzap zzap2 = arrayList3.get(n3);
                ++n3;
                zzap zzap3 = zzap2;
                arrayList2.add(zzap3.zzb());
                bl2 |= !TextUtils.isEmpty((CharSequence)zzap3.zzb());
            }
            if (bl2) {
                bundle.putStringArrayList("SKU_OFFER_ID_TOKEN_LIST", arrayList2);
            }
        }
        return bundle;
    }

    public static Bundle zza(ConsumeParams consumeParams, boolean bl, String string) {
        Bundle bundle = new Bundle();
        if (bl) {
            bundle.putString("playBillingLibraryVersion", string);
        }
        return bundle;
    }

    public static Bundle zza(AcknowledgePurchaseParams acknowledgePurchaseParams, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("playBillingLibraryVersion", string);
        return bundle;
    }

    private static Purchase zzc(String string, String string2) {
        if (string == null || string2 == null) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingHelper", "Received a bad purchase data.");
            return null;
        }
        Purchase purchase = null;
        try {
            purchase = new Purchase(string, string2);
        }
        catch (JSONException jSONException) {
            String string3 = String.valueOf((Object)jSONException);
            com.google.android.gms.internal.play_billing.zza.zzb("BillingHelper", new StringBuilder(47 + String.valueOf(string3).length()).append("Got JSONException while parsing purchase data: ").append(string3).toString());
        }
        return purchase;
    }
}

