/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.android.billingclient.api.BillingBroadcastManager;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.PriceChangeConfirmationListener;
import com.android.billingclient.api.PriceChangeFlowParams;
import com.android.billingclient.api.ProxyBillingActivity;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.RewardLoadParams;
import com.android.billingclient.api.RewardResponseListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.android.billingclient.util.BillingHelper;
import com.android.vending.billing.IInAppBillingService;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class BillingClientImpl
extends BillingClient {
    private static final String TAG = "BillingClient";
    private static final int MAX_SKU_DETAILS_ITEMS_PER_REQUEST = 20;
    private int mClientState = 0;
    private int mChildDirected = 0;
    private static final String GET_SKU_DETAILS_ITEM_LIST = "ITEM_ID_LIST";
    private static final String LIBRARY_VERSION = "1.2";
    private static final int MAX_IAP_VERSION = 8;
    private static final int MIN_IAP_VERSION = 3;
    private final Handler mUiThreadHandler = new Handler();
    private final BillingBroadcastManager mBroadcastManager;
    private final Context mApplicationContext;
    private IInAppBillingService mService;
    private ServiceConnection mServiceConnection;
    private boolean mSubscriptionsSupported;
    private boolean mSubscriptionUpdateSupported;
    private boolean mIABv6Supported;
    private boolean mIABv8Supported;
    private ExecutorService mExecutorService;
    private final ResultReceiver onPurchaseFinishedReceiver = new ResultReceiver(new Handler()){

        public void onReceiveResult(int resultCode, Bundle resultData) {
            PurchasesUpdatedListener purchasesUpdatedListener = BillingClientImpl.this.mBroadcastManager.getListener();
            if (purchasesUpdatedListener == null) {
                BillingHelper.logWarn(BillingClientImpl.TAG, "PurchasesUpdatedListener is null - no way to return the response.");
                return;
            }
            List<Purchase> purchases = BillingHelper.extractPurchases(resultData);
            purchasesUpdatedListener.onPurchasesUpdated(resultCode, purchases);
        }
    };

    @VisibleForTesting
    void setExecutorService(ExecutorService executorService) {
        this.mExecutorService = executorService;
    }

    @UiThread
    BillingClientImpl(@NonNull Context context, @NonNull PurchasesUpdatedListener listener) {
        this.mApplicationContext = context.getApplicationContext();
        this.mBroadcastManager = new BillingBroadcastManager(this.mApplicationContext, listener);
    }

    @Override
    public int isFeatureSupported(String feature) {
        if (!this.isReady()) {
            return -1;
        }
        switch (feature) {
            case "subscriptions": {
                return this.mSubscriptionsSupported ? 0 : -2;
            }
            case "subscriptionsUpdate": {
                return this.mSubscriptionUpdateSupported ? 0 : -2;
            }
            case "inAppItemsOnVr": {
                return this.isBillingSupportedOnVr("inapp");
            }
            case "subscriptionsOnVr": {
                return this.isBillingSupportedOnVr("subs");
            }
            case "priceChangeConfirmation": {
                return this.mIABv8Supported ? 0 : -2;
            }
        }
        BillingHelper.logWarn(TAG, "Unsupported feature: " + feature);
        return 5;
    }

    @Override
    public boolean isReady() {
        return this.mClientState == 2 && this.mService != null && this.mServiceConnection != null;
    }

    @Override
    public void startConnection(@NonNull BillingClientStateListener listener) {
        if (this.isReady()) {
            BillingHelper.logVerbose(TAG, "Service connection is valid. No need to re-initialize.");
            listener.onBillingSetupFinished(0);
            return;
        }
        if (this.mClientState == 1) {
            BillingHelper.logWarn(TAG, "Client is already in the process of connecting to billing service.");
            listener.onBillingSetupFinished(5);
            return;
        }
        if (this.mClientState == 3) {
            BillingHelper.logWarn(TAG, "Client was already closed and can't be reused. Please create another instance.");
            listener.onBillingSetupFinished(5);
            return;
        }
        this.mClientState = 1;
        this.mBroadcastManager.registerReceiver();
        BillingHelper.logVerbose(TAG, "Starting in-app billing setup.");
        this.mServiceConnection = new BillingServiceConnection(listener);
        Intent serviceIntent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
        serviceIntent.setPackage("com.android.vending");
        List intentServices = this.mApplicationContext.getPackageManager().queryIntentServices(serviceIntent, 0);
        if (intentServices != null && !intentServices.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)intentServices.get(0);
            if (resolveInfo.serviceInfo != null) {
                String packageName = resolveInfo.serviceInfo.packageName;
                String className = resolveInfo.serviceInfo.name;
                if ("com.android.vending".equals(packageName) && className != null) {
                    ComponentName component = new ComponentName(packageName, className);
                    Intent explicitServiceIntent = new Intent(serviceIntent);
                    explicitServiceIntent.setComponent(component);
                    explicitServiceIntent.putExtra("libraryVersion", LIBRARY_VERSION);
                    boolean connectionResult = this.mApplicationContext.bindService(explicitServiceIntent, this.mServiceConnection, 1);
                    if (connectionResult) {
                        BillingHelper.logVerbose(TAG, "Service was bonded successfully.");
                        return;
                    }
                    BillingHelper.logWarn(TAG, "Connection to Billing service is blocked.");
                } else {
                    BillingHelper.logWarn(TAG, "The device doesn't have valid Play Store.");
                }
            }
        }
        this.mClientState = 0;
        BillingHelper.logVerbose(TAG, "Billing service unavailable on device.");
        listener.onBillingSetupFinished(3);
    }

    @Override
    public void endConnection() {
        try {
            this.mBroadcastManager.destroy();
            if (this.mServiceConnection != null && this.mService != null) {
                BillingHelper.logVerbose(TAG, "Unbinding from service.");
                this.mApplicationContext.unbindService(this.mServiceConnection);
                this.mServiceConnection = null;
            }
            this.mService = null;
            if (this.mExecutorService != null) {
                this.mExecutorService.shutdownNow();
                this.mExecutorService = null;
            }
        }
        catch (Exception ex) {
            BillingHelper.logWarn(TAG, "There was an exception while ending connection: " + ex);
        }
        finally {
            this.mClientState = 3;
        }
    }

    @Override
    public void launchPriceChangeConfirmationFlow(Activity activity, PriceChangeFlowParams priceChangeFlowParams, final @NonNull PriceChangeConfirmationListener listener) {
        Bundle priceChangeIntentBundle;
        if (!this.isReady()) {
            listener.onPriceChangeConfirmationResult(-1);
            return;
        }
        if (priceChangeFlowParams == null || priceChangeFlowParams.getSkuDetails() == null) {
            BillingHelper.logWarn(TAG, "Please fix the input params. priceChangeFlowParams must contain valid sku.");
            listener.onPriceChangeConfirmationResult(5);
            return;
        }
        String sku = priceChangeFlowParams.getSkuDetails().getSku();
        if (sku == null) {
            BillingHelper.logWarn(TAG, "Please fix the input params. priceChangeFlowParams must contain valid sku.");
            listener.onPriceChangeConfirmationResult(5);
            return;
        }
        if (!this.mIABv8Supported) {
            BillingHelper.logWarn(TAG, "Current client doesn't support price change confirmation flow.");
            listener.onPriceChangeConfirmationResult(-2);
            return;
        }
        Bundle extraParams = new Bundle();
        extraParams.putString("libraryVersion", LIBRARY_VERSION);
        extraParams.putBoolean("subs_price_change", true);
        try {
            priceChangeIntentBundle = this.mService.getSubscriptionManagementIntent(8, this.mApplicationContext.getPackageName(), sku, "subs", extraParams);
        }
        catch (RemoteException ex) {
            String msg = "RemoteException while launching launching price change flow for sku: " + sku + "; try to reconnect";
            BillingHelper.logWarn(TAG, msg);
            listener.onPriceChangeConfirmationResult(-1);
            return;
        }
        int responseCode = BillingHelper.getResponseCodeFromBundle(priceChangeIntentBundle, TAG);
        if (responseCode != 0) {
            BillingHelper.logWarn(TAG, "Unable to launch price change flow, error response code: " + responseCode);
            listener.onPriceChangeConfirmationResult(responseCode);
            return;
        }
        ResultReceiver onPriceChangeConfirmationReceiver = new ResultReceiver(new Handler()){

            public void onReceiveResult(int resultCode, Bundle resultData) {
                listener.onPriceChangeConfirmationResult(resultCode);
            }
        };
        Intent intent = new Intent((Context)activity, ProxyBillingActivity.class);
        PendingIntent pendingIntent = (PendingIntent)priceChangeIntentBundle.getParcelable("SUBS_MANAGEMENT_INTENT");
        intent.putExtra("SUBS_MANAGEMENT_INTENT", (Parcelable)pendingIntent);
        intent.putExtra("result_receiver", (Parcelable)onPriceChangeConfirmationReceiver);
        activity.startActivity(intent);
    }

    @Override
    public int launchBillingFlow(Activity activity, BillingFlowParams params) {
        boolean isSubscriptionUpdate;
        boolean rewardedSku;
        if (!this.isReady()) {
            return this.broadcastFailureAndReturnBillingResponse(-1);
        }
        String skuType = params.getSkuType();
        String newSku = params.getSku();
        SkuDetails skuDetails = params.getSkuDetails();
        boolean bl = rewardedSku = skuDetails != null && skuDetails.isRewarded();
        if (newSku == null) {
            BillingHelper.logWarn(TAG, "Please fix the input params. SKU can't be null.");
            return this.broadcastFailureAndReturnBillingResponse(5);
        }
        if (skuType == null) {
            BillingHelper.logWarn(TAG, "Please fix the input params. SkuType can't be null.");
            return this.broadcastFailureAndReturnBillingResponse(5);
        }
        if (skuType.equals("subs") && !this.mSubscriptionsSupported) {
            BillingHelper.logWarn(TAG, "Current client doesn't support subscriptions.");
            return this.broadcastFailureAndReturnBillingResponse(-2);
        }
        boolean bl2 = isSubscriptionUpdate = params.getOldSku() != null;
        if (isSubscriptionUpdate && !this.mSubscriptionUpdateSupported) {
            BillingHelper.logWarn(TAG, "Current client doesn't support subscriptions update.");
            return this.broadcastFailureAndReturnBillingResponse(-2);
        }
        if (params.hasExtraParams() && !this.mIABv6Supported) {
            BillingHelper.logWarn(TAG, "Current client doesn't support extra params for buy intent.");
            return this.broadcastFailureAndReturnBillingResponse(-2);
        }
        if (rewardedSku && !this.mIABv6Supported) {
            BillingHelper.logWarn(TAG, "Current client doesn't support extra params for buy intent.");
            return this.broadcastFailureAndReturnBillingResponse(-2);
        }
        try {
            Bundle buyIntentBundle;
            BillingHelper.logVerbose(TAG, "Constructing buy intent for " + newSku + ", item type: " + skuType);
            if (this.mIABv6Supported) {
                Bundle extraParams = this.constructExtraParams(params);
                extraParams.putString("libraryVersion", LIBRARY_VERSION);
                if (rewardedSku) {
                    extraParams.putString("rewardToken", skuDetails.rewardToken());
                    if (this.mChildDirected == 1 || this.mChildDirected == 2) {
                        extraParams.putInt("childDirected", this.mChildDirected);
                    }
                }
                int apiVersion = params.getVrPurchaseFlow() ? 7 : 6;
                buyIntentBundle = this.mService.getBuyIntentExtraParams(apiVersion, this.mApplicationContext.getPackageName(), newSku, skuType, null, extraParams);
            } else {
                buyIntentBundle = isSubscriptionUpdate ? this.mService.getBuyIntentToReplaceSkus(5, this.mApplicationContext.getPackageName(), Arrays.asList(params.getOldSku()), newSku, "subs", null) : this.mService.getBuyIntent(3, this.mApplicationContext.getPackageName(), newSku, skuType, null);
            }
            int responseCode = BillingHelper.getResponseCodeFromBundle(buyIntentBundle, TAG);
            if (responseCode != 0) {
                BillingHelper.logWarn(TAG, "Unable to buy item, Error response code: " + responseCode);
                return this.broadcastFailureAndReturnBillingResponse(responseCode);
            }
            Intent intent = new Intent((Context)activity, ProxyBillingActivity.class);
            intent.putExtra("result_receiver", (Parcelable)this.onPurchaseFinishedReceiver);
            PendingIntent pendingIntent = (PendingIntent)buyIntentBundle.getParcelable("BUY_INTENT");
            intent.putExtra("BUY_INTENT", (Parcelable)pendingIntent);
            activity.startActivity(intent);
        }
        catch (RemoteException e) {
            String msg = "RemoteException while launching launching replace subscriptions flow: ; for sku: " + newSku + "; try to reconnect";
            BillingHelper.logWarn(TAG, msg);
            return this.broadcastFailureAndReturnBillingResponse(-1);
        }
        return 0;
    }

    private int broadcastFailureAndReturnBillingResponse(int responseCode) {
        this.mBroadcastManager.getListener().onPurchasesUpdated(responseCode, null);
        return responseCode;
    }

    @Override
    public Purchase.PurchasesResult queryPurchases(String skuType) {
        if (!this.isReady()) {
            return new Purchase.PurchasesResult(-1, null);
        }
        if (TextUtils.isEmpty((CharSequence)skuType)) {
            BillingHelper.logWarn(TAG, "Please provide a valid SKU type.");
            return new Purchase.PurchasesResult(5, null);
        }
        return this.queryPurchasesInternal(skuType, false);
    }

    @Override
    public void querySkuDetailsAsync(SkuDetailsParams params, final SkuDetailsResponseListener listener) {
        if (!this.isReady()) {
            listener.onSkuDetailsResponse(-1, null);
            return;
        }
        final String skuType = params.getSkuType();
        final List<String> skusList = params.getSkusList();
        if (TextUtils.isEmpty((CharSequence)skuType)) {
            BillingHelper.logWarn(TAG, "Please fix the input params. SKU type can't be empty.");
            listener.onSkuDetailsResponse(5, null);
            return;
        }
        if (skusList == null) {
            BillingHelper.logWarn(TAG, "Please fix the input params. The list of SKUs can't be empty.");
            listener.onSkuDetailsResponse(5, null);
            return;
        }
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                final SkuDetails.SkuDetailsResult result = BillingClientImpl.this.querySkuDetailsInternal(skuType, skusList);
                BillingClientImpl.this.postToUiThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onSkuDetailsResponse(result.getResponseCode(), result.getSkuDetailsList());
                    }
                });
            }
        });
    }

    @Override
    public void consumeAsync(final String purchaseToken, final ConsumeResponseListener listener) {
        if (!this.isReady()) {
            listener.onConsumeResponse(-1, null);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)purchaseToken)) {
            BillingHelper.logWarn(TAG, "Please provide a valid purchase token got from queryPurchases result.");
            listener.onConsumeResponse(5, purchaseToken);
            return;
        }
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                BillingClientImpl.this.consumeInternal(purchaseToken, listener);
            }
        });
    }

    @Override
    public void queryPurchaseHistoryAsync(final String skuType, final PurchaseHistoryResponseListener listener) {
        if (!this.isReady()) {
            listener.onPurchaseHistoryResponse(-1, null);
            return;
        }
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                final Purchase.PurchasesResult result = BillingClientImpl.this.queryPurchasesInternal(skuType, true);
                BillingClientImpl.this.postToUiThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onPurchaseHistoryResponse(result.getResponseCode(), result.getPurchasesList());
                    }
                });
            }
        });
    }

    @Override
    public void loadRewardedSku(final RewardLoadParams params, final RewardResponseListener listener) {
        if (!this.mIABv6Supported) {
            listener.onRewardResponse(4);
            return;
        }
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                Bundle buyIntentBundle;
                Bundle extraParams = new Bundle();
                extraParams.putString("rewardToken", params.getSkuDetails().rewardToken());
                if (BillingClientImpl.this.mChildDirected == 1 || BillingClientImpl.this.mChildDirected == 2) {
                    extraParams.putInt("childDirected", BillingClientImpl.this.mChildDirected);
                }
                try {
                    buyIntentBundle = BillingClientImpl.this.mService.getBuyIntentExtraParams(6, BillingClientImpl.this.mApplicationContext.getPackageName(), params.getSkuDetails().getSku(), params.getSkuDetails().getType(), null, extraParams);
                }
                catch (RemoteException e) {
                    BillingClientImpl.this.postToUiThread(new Runnable(){

                        @Override
                        public void run() {
                            listener.onRewardResponse(6);
                        }
                    });
                    return;
                }
                final int responseCode = BillingHelper.getResponseCodeFromBundle(buyIntentBundle, BillingClientImpl.TAG);
                BillingClientImpl.this.postToUiThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onRewardResponse(responseCode);
                    }
                });
            }
        });
    }

    @Override
    public void setChildDirected(int childDirected) {
        this.mChildDirected = childDirected;
    }

    private Bundle constructExtraParams(BillingFlowParams params) {
        Bundle extraParams = new Bundle();
        if (params.getReplaceSkusProrationMode() != 0) {
            extraParams.putInt("prorationMode", params.getReplaceSkusProrationMode());
        }
        if (params.getAccountId() != null) {
            extraParams.putString("accountId", params.getAccountId());
        }
        if (params.getVrPurchaseFlow()) {
            extraParams.putBoolean("vr", true);
        }
        if (params.getOldSku() != null) {
            extraParams.putStringArrayList("skusToReplace", new ArrayList<String>(Arrays.asList(params.getOldSku())));
        }
        return extraParams;
    }

    private void executeAsync(Runnable runnable) {
        if (this.mExecutorService == null) {
            this.mExecutorService = Executors.newFixedThreadPool(BillingHelper.NUMBER_OF_CORES);
        }
        this.mExecutorService.submit(runnable);
    }

    private int isBillingSupportedOnVr(String skuType) {
        try {
            int supportedResult = this.mService.isBillingSupportedExtraParams(7, this.mApplicationContext.getPackageName(), skuType, this.generateVrBundle());
            return supportedResult == 0 ? 0 : -2;
        }
        catch (RemoteException e) {
            BillingHelper.logWarn(TAG, "RemoteException while checking if billing is supported; try to reconnect");
            return -1;
        }
    }

    private Bundle generateVrBundle() {
        Bundle result = new Bundle();
        result.putBoolean("vr", true);
        return result;
    }

    @VisibleForTesting
    SkuDetails.SkuDetailsResult querySkuDetailsInternal(String skuType, List<String> skuList) {
        ArrayList<SkuDetails> resultList = new ArrayList<SkuDetails>();
        int listSize = skuList.size();
        for (int startIndex = 0; startIndex < listSize; startIndex += 20) {
            Bundle skuDetails;
            int endIndex = startIndex + 20;
            if (endIndex > listSize) {
                endIndex = listSize;
            }
            ArrayList<String> curSkuList = new ArrayList<String>(skuList.subList(startIndex, endIndex));
            Bundle querySkus = new Bundle();
            querySkus.putStringArrayList(GET_SKU_DETAILS_ITEM_LIST, curSkuList);
            querySkus.putString("libraryVersion", LIBRARY_VERSION);
            try {
                skuDetails = this.mService.getSkuDetails(3, this.mApplicationContext.getPackageName(), skuType, querySkus);
            }
            catch (RemoteException e) {
                String msg = "querySkuDetailsAsync got a remote exception (try to reconnect): " + (Object)((Object)e);
                BillingHelper.logWarn(TAG, msg);
                return new SkuDetails.SkuDetailsResult(-1, null);
            }
            if (skuDetails == null) {
                BillingHelper.logWarn(TAG, "querySkuDetailsAsync got null sku details list");
                return new SkuDetails.SkuDetailsResult(4, null);
            }
            if (!skuDetails.containsKey("DETAILS_LIST")) {
                int responseCode = BillingHelper.getResponseCodeFromBundle(skuDetails, TAG);
                if (responseCode != 0) {
                    BillingHelper.logWarn(TAG, "getSkuDetails() failed. Response code: " + responseCode);
                    return new SkuDetails.SkuDetailsResult(responseCode, resultList);
                }
                BillingHelper.logWarn(TAG, "getSkuDetails() returned a bundle with neither an error nor a detail list.");
                return new SkuDetails.SkuDetailsResult(6, resultList);
            }
            ArrayList skuDetailsJsonList = skuDetails.getStringArrayList("DETAILS_LIST");
            if (skuDetailsJsonList == null) {
                BillingHelper.logWarn(TAG, "querySkuDetailsAsync got null response list");
                return new SkuDetails.SkuDetailsResult(4, null);
            }
            for (int i = 0; i < skuDetailsJsonList.size(); ++i) {
                SkuDetails currentSkuDetails;
                String thisResponse = (String)skuDetailsJsonList.get(i);
                try {
                    currentSkuDetails = new SkuDetails(thisResponse);
                }
                catch (JSONException e) {
                    BillingHelper.logWarn(TAG, "Got a JSON exception trying to decode SkuDetails");
                    return new SkuDetails.SkuDetailsResult(6, null);
                }
                BillingHelper.logVerbose(TAG, "Got sku details: " + currentSkuDetails);
                resultList.add(currentSkuDetails);
            }
        }
        return new SkuDetails.SkuDetailsResult(0, resultList);
    }

    private Purchase.PurchasesResult queryPurchasesInternal(String skuType, boolean queryHistory) {
        BillingHelper.logVerbose(TAG, "Querying owned items, item type: " + skuType + "; history: " + queryHistory);
        String continueToken = null;
        ArrayList<Purchase> resultList = new ArrayList<Purchase>();
        do {
            Bundle ownedItems;
            try {
                if (queryHistory) {
                    if (!this.mIABv6Supported) {
                        BillingHelper.logWarn(TAG, "getPurchaseHistory is not supported on current device");
                        return new Purchase.PurchasesResult(-2, null);
                    }
                    ownedItems = this.mService.getPurchaseHistory(6, this.mApplicationContext.getPackageName(), skuType, continueToken, null);
                } else {
                    ownedItems = this.mService.getPurchases(3, this.mApplicationContext.getPackageName(), skuType, continueToken);
                }
            }
            catch (RemoteException e) {
                BillingHelper.logWarn(TAG, "Got exception trying to get purchases: " + (Object)((Object)e) + "; try to reconnect");
                return new Purchase.PurchasesResult(-1, null);
            }
            if (ownedItems == null) {
                BillingHelper.logWarn(TAG, "queryPurchases got null owned items list");
                return new Purchase.PurchasesResult(6, null);
            }
            int responseCode = BillingHelper.getResponseCodeFromBundle(ownedItems, TAG);
            if (responseCode != 0) {
                BillingHelper.logWarn(TAG, "getPurchases() failed. Response code: " + responseCode);
                return new Purchase.PurchasesResult(responseCode, null);
            }
            if (!(ownedItems.containsKey("INAPP_PURCHASE_ITEM_LIST") && ownedItems.containsKey("INAPP_PURCHASE_DATA_LIST") && ownedItems.containsKey("INAPP_DATA_SIGNATURE_LIST"))) {
                BillingHelper.logWarn(TAG, "Bundle returned from getPurchases() doesn't contain required fields.");
                return new Purchase.PurchasesResult(6, null);
            }
            ArrayList ownedSkus = ownedItems.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList purchaseDataList = ownedItems.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList signatureList = ownedItems.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            if (ownedSkus == null) {
                BillingHelper.logWarn(TAG, "Bundle returned from getPurchases() contains null SKUs list.");
                return new Purchase.PurchasesResult(6, null);
            }
            if (purchaseDataList == null) {
                BillingHelper.logWarn(TAG, "Bundle returned from getPurchases() contains null purchases list.");
                return new Purchase.PurchasesResult(6, null);
            }
            if (signatureList == null) {
                BillingHelper.logWarn(TAG, "Bundle returned from getPurchases() contains null signatures list.");
                return new Purchase.PurchasesResult(6, null);
            }
            for (int i = 0; i < purchaseDataList.size(); ++i) {
                Purchase purchase;
                String purchaseData = (String)purchaseDataList.get(i);
                String signature = (String)signatureList.get(i);
                String sku = (String)ownedSkus.get(i);
                BillingHelper.logVerbose(TAG, "Sku is owned: " + sku);
                try {
                    purchase = new Purchase(purchaseData, signature);
                }
                catch (JSONException e) {
                    BillingHelper.logWarn(TAG, "Got an exception trying to decode the purchase: " + (Object)((Object)e));
                    return new Purchase.PurchasesResult(6, null);
                }
                if (TextUtils.isEmpty((CharSequence)purchase.getPurchaseToken())) {
                    BillingHelper.logWarn(TAG, "BUG: empty/null token!");
                }
                resultList.add(purchase);
            }
            continueToken = ownedItems.getString("INAPP_CONTINUATION_TOKEN");
            BillingHelper.logVerbose(TAG, "Continuation token: " + continueToken);
        } while (!TextUtils.isEmpty((CharSequence)continueToken));
        return new Purchase.PurchasesResult(0, resultList);
    }

    private void postToUiThread(Runnable runnable) {
        this.mUiThreadHandler.post(runnable);
    }

    @WorkerThread
    private void consumeInternal(final String purchaseToken, final ConsumeResponseListener listener) {
        try {
            BillingHelper.logVerbose(TAG, "Consuming purchase with token: " + purchaseToken);
            final int responseCode = this.mService.consumePurchase(3, this.mApplicationContext.getPackageName(), purchaseToken);
            if (responseCode == 0) {
                BillingHelper.logVerbose(TAG, "Successfully consumed purchase.");
                if (listener != null) {
                    this.postToUiThread(new Runnable(){

                        @Override
                        public void run() {
                            listener.onConsumeResponse(responseCode, purchaseToken);
                        }
                    });
                }
            } else {
                BillingHelper.logWarn(TAG, "Error consuming purchase with token. Response code: " + responseCode);
                this.postToUiThread(new Runnable(){

                    @Override
                    public void run() {
                        BillingHelper.logWarn(BillingClientImpl.TAG, "Error consuming purchase.");
                        listener.onConsumeResponse(responseCode, purchaseToken);
                    }
                });
            }
        }
        catch (RemoteException e) {
            this.postToUiThread(new Runnable(){

                @Override
                public void run() {
                    BillingHelper.logWarn(BillingClientImpl.TAG, "Error consuming purchase; ex: " + (Object)((Object)e));
                    listener.onConsumeResponse(-1, purchaseToken);
                }
            });
        }
    }

    private final class BillingServiceConnection
    implements ServiceConnection {
        private final BillingClientStateListener mListener;

        private BillingServiceConnection(BillingClientStateListener listener) {
            if (listener == null) {
                throw new RuntimeException("Please specify a listener to know when init is done.");
            }
            this.mListener = listener;
        }

        public void onServiceDisconnected(ComponentName name) {
            BillingHelper.logWarn(BillingClientImpl.TAG, "Billing service disconnected.");
            BillingClientImpl.this.mService = null;
            BillingClientImpl.this.mClientState = 0;
            this.mListener.onBillingServiceDisconnected();
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            BillingHelper.logVerbose(BillingClientImpl.TAG, "Billing service connected.");
            BillingClientImpl.this.mService = IInAppBillingService.Stub.asInterface(service);
            String packageName = BillingClientImpl.this.mApplicationContext.getPackageName();
            try {
                int response = 3;
                int highestLevelSupportedForSubs = 0;
                for (int apiVersion = 8; apiVersion >= 3; --apiVersion) {
                    response = BillingClientImpl.this.mService.isBillingSupported(apiVersion, packageName, "subs");
                    if (response != 0) continue;
                    highestLevelSupportedForSubs = apiVersion;
                    break;
                }
                BillingClientImpl.this.mSubscriptionUpdateSupported = highestLevelSupportedForSubs >= 5;
                BillingClientImpl.this.mSubscriptionsSupported = highestLevelSupportedForSubs >= 3;
                if (highestLevelSupportedForSubs < 3) {
                    BillingHelper.logVerbose(BillingClientImpl.TAG, "In-app billing API does not support subscription on this device.");
                }
                int highestLevelSupportedForInApp = 0;
                for (int apiVersion = 8; apiVersion >= 3; --apiVersion) {
                    response = BillingClientImpl.this.mService.isBillingSupported(apiVersion, packageName, "inapp");
                    if (response != 0) continue;
                    highestLevelSupportedForInApp = apiVersion;
                    break;
                }
                BillingClientImpl.this.mIABv8Supported = highestLevelSupportedForInApp >= 8;
                BillingClientImpl.this.mIABv6Supported = highestLevelSupportedForInApp >= 6;
                if (highestLevelSupportedForInApp < 3) {
                    BillingHelper.logWarn(BillingClientImpl.TAG, "In-app billing API version 3 is not supported on this device.");
                }
                if (response == 0) {
                    BillingClientImpl.this.mClientState = 2;
                } else {
                    BillingClientImpl.this.mClientState = 0;
                    BillingClientImpl.this.mService = null;
                }
                this.mListener.onBillingSetupFinished(response);
            }
            catch (RemoteException e) {
                BillingHelper.logWarn(BillingClientImpl.TAG, "RemoteException while setting up in-app billing" + (Object)((Object)e));
                BillingClientImpl.this.mClientState = 0;
                BillingClientImpl.this.mService = null;
                this.mListener.onBillingSetupFinished(-1);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ClientState {
        public static final int DISCONNECTED = 0;
        public static final int CONNECTING = 1;
        public static final int CONNECTED = 2;
        public static final int CLOSED = 3;
    }
}

