/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import com.android.billingclient.api.SkuDetails;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;

public class BillingFlowParams {
    static final String EXTRA_PARAM_KEY_ACCOUNT_ID = "accountId";
    static final String EXTRA_PARAM_KEY_REPLACE_SKUS_PRORATION_MODE = "prorationMode";
    static final String EXTRA_PARAM_KEY_VR = "vr";
    static final String EXTRA_PARAM_KEY_RSKU = "rewardToken";
    static final String EXTRA_PARAM_CHILD_DIRECTED = "childDirected";
    static final String EXTRA_PARAM_UNDER_AGE_OF_CONSENT = "underAgeOfConsent";
    static final String EXTRA_PARAM_KEY_OLD_SKUS = "skusToReplace";
    private String mSku;
    private String mSkuType;
    private SkuDetails mSkuDetails;
    private String mOldSku;
    private String mAccountId;
    private boolean mVrPurchaseFlow;
    private int mReplaceSkusProrationMode = 0;

    public String getSku() {
        if (this.mSkuDetails != null) {
            return this.mSkuDetails.getSku();
        }
        return this.mSku;
    }

    public String getSkuType() {
        if (this.mSkuDetails != null) {
            return this.mSkuDetails.getType();
        }
        return this.mSkuType;
    }

    public SkuDetails getSkuDetails() {
        return this.mSkuDetails;
    }

    @Deprecated
    public ArrayList<String> getOldSkus() {
        return new ArrayList<String>(Arrays.asList(this.mOldSku));
    }

    public String getOldSku() {
        return this.mOldSku;
    }

    public String getAccountId() {
        return this.mAccountId;
    }

    public boolean getVrPurchaseFlow() {
        return this.mVrPurchaseFlow;
    }

    public int getReplaceSkusProrationMode() {
        return this.mReplaceSkusProrationMode;
    }

    public boolean hasExtraParams() {
        return this.mVrPurchaseFlow || this.mAccountId != null || this.mReplaceSkusProrationMode != 0;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String mSku;
        private String mSkuType;
        private SkuDetails mSkuDetails;
        private String mOldSku;
        private String mAccountId;
        private boolean mVrPurchaseFlow;
        private int mReplaceSkusProrationMode = 0;

        private Builder() {
        }

        @Deprecated
        public Builder setSku(String sku) {
            if (this.mSkuDetails != null) {
                throw new RuntimeException("Sku details already set");
            }
            this.mSku = sku;
            return this;
        }

        @Deprecated
        public Builder setType(String type) {
            if (this.mSkuDetails != null) {
                throw new RuntimeException("Sku details already set");
            }
            this.mSkuType = type;
            return this;
        }

        public Builder setSkuDetails(SkuDetails skuDetails) {
            if (this.mSku != null || this.mSkuType != null) {
                throw new RuntimeException("Sku or type already set");
            }
            this.mSkuDetails = skuDetails;
            return this;
        }

        @Deprecated
        public Builder setOldSkus(ArrayList<String> oldSkus) {
            if (oldSkus != null && oldSkus.size() > 0) {
                this.mOldSku = oldSkus.get(0);
            }
            return this;
        }

        public Builder setOldSku(String oldSku) {
            this.mOldSku = oldSku;
            return this;
        }

        @Deprecated
        public Builder addOldSku(String oldSku) {
            this.mOldSku = oldSku;
            return this;
        }

        public Builder setReplaceSkusProrationMode(int replaceSkusProrationMode) {
            this.mReplaceSkusProrationMode = replaceSkusProrationMode;
            return this;
        }

        public Builder setAccountId(String accountId) {
            this.mAccountId = accountId;
            return this;
        }

        public Builder setVrPurchaseFlow(boolean isVrPurchaseFlow) {
            this.mVrPurchaseFlow = isVrPurchaseFlow;
            return this;
        }

        public BillingFlowParams build() {
            BillingFlowParams params = new BillingFlowParams();
            params.mSku = this.mSku;
            params.mSkuType = this.mSkuType;
            params.mSkuDetails = this.mSkuDetails;
            params.mOldSku = this.mOldSku;
            params.mAccountId = this.mAccountId;
            params.mVrPurchaseFlow = this.mVrPurchaseFlow;
            params.mReplaceSkusProrationMode = this.mReplaceSkusProrationMode;
            return params;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProrationMode {
        public static final int UNKNOWN_SUBSCRIPTION_UPGRADE_DOWNGRADE_POLICY = 0;
        public static final int IMMEDIATE_WITH_TIME_PRORATION = 1;
        public static final int IMMEDIATE_AND_CHARGE_PRORATED_PRICE = 2;
        public static final int IMMEDIATE_WITHOUT_PRORATION = 3;
        public static final int DEFERRED = 4;
    }
}

