/*
 * Decompiled with CFR 0.152.
 */
package com.andrognito.rxpatternlockview.utils;

import android.os.Looper;
import io.reactivex.Observer;

public final class Preconditions {
    private Preconditions() {
        throw new AssertionError((Object)"You can not instantiate this class. Use its static utility methods instead");
    }

    public static void checkNotNull(Object value, String message) {
        if (value == null) {
            throw new NullPointerException(message);
        }
    }

    public static boolean checkMainThread(Observer<?> observer) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            observer.onError((Throwable)new IllegalStateException("Expected to be called on the main thread but was " + Thread.currentThread().getName()));
            return false;
        }
        return true;
    }
}

