/*
 * Decompiled with CFR 0.152.
 */
package com.andrognito.rxpatternlockview.observables;

import com.andrognito.patternlockview.PatternLockView;
import com.andrognito.patternlockview.listener.PatternLockViewListener;
import com.andrognito.rxpatternlockview.events.PatternLockCompoundEvent;
import com.andrognito.rxpatternlockview.observables.BasePatternLockViewObservable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import java.util.List;

public class PatternLockViewCompoundObservable
extends BasePatternLockViewObservable<PatternLockCompoundEvent> {
    public PatternLockViewCompoundObservable(PatternLockView patternLockView, boolean emitInitialValue) {
        super(patternLockView, emitInitialValue);
    }

    protected void subscribeActual(Observer<? super PatternLockCompoundEvent> observer) {
        this.subscribeListener(observer);
        if (this.mEmitInitialValue) {
            observer.onNext((Object)new PatternLockCompoundEvent(0, this.mPatternLockView.getPattern()));
        }
    }

    @Override
    protected void subscribeListener(Observer<? super PatternLockCompoundEvent> observer) {
        InternalListener internalListener = new InternalListener(this.mPatternLockView, observer);
        observer.onSubscribe((Disposable)internalListener);
        this.mPatternLockView.addPatternLockListener((PatternLockViewListener)internalListener);
    }

    private static final class InternalListener
    extends MainThreadDisposable
    implements PatternLockViewListener {
        private final PatternLockView view;
        private final Observer<? super PatternLockCompoundEvent> observer;

        InternalListener(PatternLockView view, Observer<? super PatternLockCompoundEvent> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onStarted() {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)new PatternLockCompoundEvent(0, null));
            }
        }

        public void onProgress(List<PatternLockView.Dot> progressPattern) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)new PatternLockCompoundEvent(1, progressPattern));
            }
        }

        public void onComplete(List<PatternLockView.Dot> pattern) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)new PatternLockCompoundEvent(2, pattern));
            }
        }

        public void onCleared() {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)new PatternLockCompoundEvent(3, null));
            }
        }

        protected void onDispose() {
            this.view.removePatternLockListener((PatternLockViewListener)this);
        }
    }
}

