/*
 * Decompiled with CFR 0.152.
 */
package com.andrognito.rxpatternlockview.observables;

import com.andrognito.patternlockview.PatternLockView;
import com.andrognito.patternlockview.listener.PatternLockViewListener;
import com.andrognito.rxpatternlockview.events.PatternLockCompleteEvent;
import com.andrognito.rxpatternlockview.observables.BasePatternLockViewObservable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import java.util.List;

public class PatternLockViewCompleteObservable
extends BasePatternLockViewObservable<PatternLockCompleteEvent> {
    public PatternLockViewCompleteObservable(PatternLockView patternLockView, boolean emitInitialValues) {
        super(patternLockView, emitInitialValues);
    }

    @Override
    protected void subscribeListener(Observer<? super PatternLockCompleteEvent> observer) {
        this.subscribeListener(observer);
        if (this.mEmitInitialValue) {
            observer.onNext((Object)new PatternLockCompleteEvent(this.mPatternLockView.getPattern()));
        }
    }

    protected void subscribeActual(Observer<? super PatternLockCompleteEvent> observer) {
        InternalListener internalListener = new InternalListener(this.mPatternLockView, observer);
        observer.onSubscribe((Disposable)internalListener);
        this.mPatternLockView.addPatternLockListener((PatternLockViewListener)internalListener);
    }

    private static final class InternalListener
    extends MainThreadDisposable
    implements PatternLockViewListener {
        private final PatternLockView view;
        private final Observer<? super PatternLockCompleteEvent> observer;

        InternalListener(PatternLockView view, Observer<? super PatternLockCompleteEvent> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onStarted() {
        }

        public void onProgress(List<PatternLockView.Dot> progressPattern) {
        }

        public void onComplete(List<PatternLockView.Dot> pattern) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)new PatternLockCompleteEvent(pattern));
            }
        }

        public void onCleared() {
        }

        protected void onDispose() {
            this.view.removePatternLockListener((PatternLockViewListener)this);
        }
    }
}

