/*
 * Decompiled with CFR 0.152.
 */
package com.andreabaccega.formedittextvalidator;

import android.widget.EditText;
import com.andreabaccega.formedittextvalidator.Validator;

public class NumericRangeValidator
extends Validator {
    private int min;
    private int max;

    public NumericRangeValidator(String _customErrorMessage, int min, int max) {
        super(_customErrorMessage);
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean isValid(EditText et) {
        try {
            int value = Integer.parseInt(et.getText().toString());
            return value >= this.min && value <= this.max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

