/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.essentials.utils;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.ancient.essentials.R;
import com.ancient.essentials.utils.AlertDialogUtils;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0004J&\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/ancient/essentials/utils/ShareUtils;", "", "()V", "MARKET_DETAILS_ID", "", "createShareIntent", "", "aContext", "Landroid/content/Context;", "shareContent", "openPlayStorePage", "context", "openWebPage", "aWebPageURL", "sendEmailFeedback", "aEmailId", "aEmailSubject", "aEmailContent", "aShareContent", "android-essentials_release"})
public final class ShareUtils {
    private static final String MARKET_DETAILS_ID = "market://details?id=%s";
    public static final ShareUtils INSTANCE;

    public final void openPlayStorePage(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = MARKET_DETAILS_ID;
        Object[] objectArray = new Object[]{context.getPackageName()};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        Uri uri = Uri.parse((String)string3);
        Intent goToMarket = new Intent("android.intent.action.VIEW", uri);
        try {
            context.startActivity(goToMarket);
        }
        catch (ActivityNotFoundException e) {
            String string4 = context.getString(R.string.error_title);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"context.getString(R.string.error_title)");
            String string5 = context.getString(R.string.play_store_not_available);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"context.getString(R.stri\u2026play_store_not_available)");
            AlertDialogUtils.createConformationDialog$default(AlertDialogUtils.INSTANCE, context, string4, string5, false, null, 16, null);
        }
    }

    private final void createShareIntent(Context aContext, String shareContent) {
        Intent sendIntent = new Intent();
        sendIntent.setAction("android.intent.action.SEND");
        sendIntent.putExtra("android.intent.extra.TEXT", shareContent);
        sendIntent.setType("text/plain");
        aContext.startActivity(Intent.createChooser((Intent)sendIntent, (CharSequence)aContext.getResources().getText(R.string.share_content)));
    }

    public final void openWebPage(@NotNull Context aContext, @NotNull String aWebPageURL) {
        Intrinsics.checkParameterIsNotNull((Object)aContext, (String)"aContext");
        Intrinsics.checkParameterIsNotNull((Object)aWebPageURL, (String)"aWebPageURL");
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)aWebPageURL));
        aContext.startActivity(Intent.createChooser((Intent)intent, (CharSequence)aContext.getResources().getText(R.string.open_web_page)));
    }

    public final void sendEmailFeedback(@NotNull Context aContext, @NotNull String aEmailId, @NotNull String aEmailSubject, @NotNull String aEmailContent) {
        Intrinsics.checkParameterIsNotNull((Object)aContext, (String)"aContext");
        Intrinsics.checkParameterIsNotNull((Object)aEmailId, (String)"aEmailId");
        Intrinsics.checkParameterIsNotNull((Object)aEmailSubject, (String)"aEmailSubject");
        Intrinsics.checkParameterIsNotNull((Object)aEmailContent, (String)"aEmailContent");
        Intent emailIntent = new Intent("android.intent.action.SEND");
        emailIntent.setType("plain/text");
        emailIntent.putExtra("android.intent.extra.EMAIL", new String[]{aEmailId});
        emailIntent.putExtra("android.intent.extra.SUBJECT", aEmailSubject);
        emailIntent.putExtra("android.intent.extra.TEXT", aEmailContent);
        aContext.startActivity(Intent.createChooser((Intent)emailIntent, (CharSequence)aContext.getString(R.string.send_email_title)));
    }

    public final void shareContent(@NotNull Context aContext, @NotNull String aShareContent) {
        Intrinsics.checkParameterIsNotNull((Object)aContext, (String)"aContext");
        Intrinsics.checkParameterIsNotNull((Object)aShareContent, (String)"aShareContent");
        this.createShareIntent(aContext, aShareContent);
    }

    private ShareUtils() {
    }

    static {
        ShareUtils shareUtils;
        INSTANCE = shareUtils = new ShareUtils();
    }
}

