/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.essentials;

import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import androidx.databinding.DataBinderMapper;
import androidx.databinding.DataBindingComponent;
import androidx.databinding.ViewDataBinding;
import com.ancient.essentials.R;
import com.ancient.essentials.databinding.ContentListBindingImpl;
import com.ancient.essentials.databinding.ListPageBindingImpl;
import com.ancient.essentials.databinding.SearchPageBindingImpl;
import com.ancient.essentials.databinding.TabsPageLayoutBindingImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DataBinderMapperImpl
extends DataBinderMapper {
    private static final int LAYOUT_CONTENTLIST = 1;
    private static final int LAYOUT_LISTPAGE = 2;
    private static final int LAYOUT_SEARCHPAGE = 3;
    private static final int LAYOUT_TABSPAGELAYOUT = 4;
    private static final SparseIntArray INTERNAL_LAYOUT_ID_LOOKUP = new SparseIntArray(4);

    public ViewDataBinding getDataBinder(DataBindingComponent component, View view, int layoutId) {
        int localizedLayoutId = INTERNAL_LAYOUT_ID_LOOKUP.get(layoutId);
        if (localizedLayoutId > 0) {
            Object tag = view.getTag();
            if (tag == null) {
                throw new RuntimeException("view must have a tag");
            }
            switch (localizedLayoutId) {
                case 1: {
                    if ("layout/content_list_0".equals(tag)) {
                        return new ContentListBindingImpl(component, view);
                    }
                    throw new IllegalArgumentException("The tag for content_list is invalid. Received: " + tag);
                }
                case 2: {
                    if ("layout/list_page_0".equals(tag)) {
                        return new ListPageBindingImpl(component, view);
                    }
                    throw new IllegalArgumentException("The tag for list_page is invalid. Received: " + tag);
                }
                case 3: {
                    if ("layout/search_page_0".equals(tag)) {
                        return new SearchPageBindingImpl(component, view);
                    }
                    throw new IllegalArgumentException("The tag for search_page is invalid. Received: " + tag);
                }
                case 4: {
                    if ("layout/tabs_page_layout_0".equals(tag)) {
                        return new TabsPageLayoutBindingImpl(component, view);
                    }
                    throw new IllegalArgumentException("The tag for tabs_page_layout is invalid. Received: " + tag);
                }
            }
        }
        return null;
    }

    public ViewDataBinding getDataBinder(DataBindingComponent component, View[] views, int layoutId) {
        if (views == null || views.length == 0) {
            return null;
        }
        int localizedLayoutId = INTERNAL_LAYOUT_ID_LOOKUP.get(layoutId);
        if (localizedLayoutId > 0) {
            Object tag = views[0].getTag();
            if (tag == null) {
                throw new RuntimeException("view must have a tag");
            }
        }
        return null;
    }

    public int getLayoutId(String tag) {
        if (tag == null) {
            return 0;
        }
        Integer tmpVal = InnerLayoutIdLookup.sKeys.get(tag);
        return tmpVal == null ? 0 : tmpVal;
    }

    public String convertBrIdToString(int localId) {
        String tmpVal = (String)InnerBrLookup.sKeys.get(localId);
        return tmpVal;
    }

    public List<DataBinderMapper> collectDependencies() {
        ArrayList<DataBinderMapper> result = new ArrayList<DataBinderMapper>(1);
        result.add((DataBinderMapper)new androidx.databinding.library.baseAdapters.DataBinderMapperImpl());
        return result;
    }

    static {
        INTERNAL_LAYOUT_ID_LOOKUP.put(R.layout.content_list, 1);
        INTERNAL_LAYOUT_ID_LOOKUP.put(R.layout.list_page, 2);
        INTERNAL_LAYOUT_ID_LOOKUP.put(R.layout.search_page, 3);
        INTERNAL_LAYOUT_ID_LOOKUP.put(R.layout.tabs_page_layout, 4);
    }

    private static class InnerLayoutIdLookup {
        static final HashMap<String, Integer> sKeys = new HashMap(4);

        private InnerLayoutIdLookup() {
        }

        static {
            sKeys.put("layout/content_list_0", R.layout.content_list);
            sKeys.put("layout/list_page_0", R.layout.list_page);
            sKeys.put("layout/search_page_0", R.layout.search_page);
            sKeys.put("layout/tabs_page_layout_0", R.layout.tabs_page_layout);
        }
    }

    private static class InnerBrLookup {
        static final SparseArray<String> sKeys = new SparseArray(2);

        private InnerBrLookup() {
        }

        static {
            sKeys.put(0, (Object)"_all");
            sKeys.put(1, (Object)"viewModel");
        }
    }
}

