/*
 * Decompiled with CFR 0.152.
 */
package com.anagog.jedai.debugging.playback;

import android.content.Context;
import android.net.Uri;
import android.util.Pair;
import androidx.documentfile.provider.DocumentFile;
import com.anagog.jedai.common.playback.PlaybackConfig;
import com.anagog.jedai.core.logger.JedAILogger;
import com.anagog.jedai.debugging.playback.PlaybackUtils;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0007J \u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/anagog/jedai/debugging/playback/PlaybackUtils;", "", "()V", "DATA_URI", "", "END_TIME", "IS_PLAYBACK_MODE", "START_TIME", "sLogger", "Lcom/anagog/jedai/core/logger/JedAILogger;", "getSensorDataTimeRange", "", "Landroidx/documentfile/provider/DocumentFile;", "Landroid/util/Pair;", "", "context", "Landroid/content/Context;", "sensorFiles", "", "playbackConfigFromJson", "Lcom/anagog/jedai/common/playback/PlaybackConfig;", "jsonStr", "playbackConfigToJson", "Lorg/json/JSONObject;", "playbackConfig", "readLineTimeStamp", "fileUri", "Landroid/net/Uri;", "readFirstLine", "", "sortSensorFiles", "debugging_release"})
public final class PlaybackUtils {
    private static final JedAILogger sLogger;
    private static final String DATA_URI = "dataUri";
    private static final String IS_PLAYBACK_MODE = "isPlaybackMode";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    public static final PlaybackUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final JSONObject playbackConfigToJson(@NotNull PlaybackConfig playbackConfig) {
        Intrinsics.checkNotNullParameter((Object)playbackConfig, (String)"playbackConfig");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(DATA_URI, (Object)playbackConfig.getDataUri());
        jsonObject.put(IS_PLAYBACK_MODE, playbackConfig.isPlaybackMode());
        jsonObject.put(START_TIME, playbackConfig.getStartTime());
        jsonObject.put(END_TIME, playbackConfig.getEndTime());
        return jsonObject;
    }

    @JvmStatic
    @NotNull
    public static final PlaybackConfig playbackConfigFromJson(@NotNull String jsonStr) {
        Intrinsics.checkNotNullParameter((Object)jsonStr, (String)"jsonStr");
        CharSequence charSequence = jsonStr;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return new PlaybackConfig(false);
        }
        JSONObject jsonObject = new JSONObject(jsonStr);
        String dataUri = null;
        if (jsonObject.has(DATA_URI)) {
            dataUri = jsonObject.getString(DATA_URI);
        }
        boolean isPlaybackMode = jsonObject.getBoolean(IS_PLAYBACK_MODE);
        long startTime = jsonObject.getLong(START_TIME);
        long endTime = jsonObject.getLong(END_TIME);
        return new PlaybackConfig(isPlaybackMode, dataUri, startTime, endTime);
    }

    @JvmStatic
    @NotNull
    public static final List<DocumentFile> sortSensorFiles(@NotNull List<? extends DocumentFile> sensorFiles) {
        Intrinsics.checkNotNullParameter(sensorFiles, (String)"sensorFiles");
        Iterable $this$sortedBy$iv = sensorFiles;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                String string2;
                String string3;
                boolean bl;
                int n;
                int n2;
                String string4;
                boolean bl2;
                String name;
                boolean bl3;
                boolean bl4;
                String string5;
                boolean bl5 = false;
                DocumentFile it = (DocumentFile)a;
                boolean bl6 = false;
                String string6 = it.getName();
                if (string6 != null) {
                    string5 = string6;
                    bl4 = false;
                    bl3 = false;
                    name = string5;
                    bl2 = false;
                    String string7 = name;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"name");
                    string4 = string7;
                    n2 = 0;
                    n = StringsKt.lastIndexOf$default((CharSequence)name, (String)".", (int)0, (boolean)false, (int)6, null) == -1 ? name.length() - 1 : StringsKt.lastIndexOf$default((CharSequence)name, (String)".", (int)0, (boolean)false, (int)6, null);
                    bl = false;
                    String string8 = string4;
                    if (string8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.substring(n2, n);
                    string3 = string9;
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    string3 = null;
                }
                it = (DocumentFile)b;
                Comparable comparable = (Comparable)((Object)string3);
                bl6 = false;
                String string10 = it.getName();
                if (string10 != null) {
                    string5 = string10;
                    bl4 = false;
                    bl3 = false;
                    name = string5;
                    bl2 = false;
                    String string11 = name;
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"name");
                    string4 = string11;
                    n2 = 0;
                    n = StringsKt.lastIndexOf$default((CharSequence)name, (String)".", (int)0, (boolean)false, (int)6, null) == -1 ? name.length() - 1 : StringsKt.lastIndexOf$default((CharSequence)name, (String)".", (int)0, (boolean)false, (int)6, null);
                    bl = false;
                    String string12 = string4;
                    if (string12 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string13 = string12.substring(n2, n);
                    string2 = string13;
                    Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    string2 = null;
                }
                String string14 = string2;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string14)));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<DocumentFile, Pair<Long, Long>> getSensorDataTimeRange(@NotNull Context context, @NotNull List<? extends DocumentFile> sensorFiles) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sensorFiles, (String)"sensorFiles");
        List<DocumentFile> sortedFiles = PlaybackUtils.sortSensorFiles(sensorFiles);
        Map sensorRanges = new LinkedHashMap();
        if (sortedFiles.isEmpty()) {
            return sensorRanges;
        }
        if (sortedFiles.size() == 1) {
            Uri uri = sortedFiles.get(0).getUri();
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"sortedFiles[0].uri");
            Uri fileUri = uri;
            long firstPeriod = this.readLineTimeStamp(context, fileUri, true);
            long lastPeriod = this.readLineTimeStamp(context, fileUri, false);
            sensorRanges.put(sortedFiles.get(0), new Pair((Object)firstPeriod, (Object)lastPeriod));
            return sensorRanges;
        }
        long start = 0L;
        long prevStart = 0L;
        Uri fileUri = null;
        int n = 0;
        int n2 = ((Collection)sortedFiles).size();
        while (n < n2) {
            void item;
            Intrinsics.checkNotNullExpressionValue((Object)sortedFiles.get((int)item).getUri(), (String)"sortedFiles[item].uri");
            if (item == false) {
                prevStart = this.readLineTimeStamp(context, fileUri, true);
            } else {
                start = this.readLineTimeStamp(context, fileUri, true);
                sensorRanges.put(sortedFiles.get((int)(item - true)), new Pair((Object)prevStart, (Object)start));
                prevStart = start;
                if (item == sortedFiles.size() - 1) {
                    long end = this.readLineTimeStamp(context, fileUri, false);
                    sensorRanges.put(sortedFiles.get((int)item), new Pair((Object)start, (Object)end));
                }
            }
            ++item;
        }
        return sensorRanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long readLineTimeStamp(Context context, Uri fileUri, boolean readFirstLine) {
        long timestamp;
        block21: {
            Function1<InputStream, InputStream> $fun$getInputStream$1 = new Function1<InputStream, InputStream>(fileUri){
                final /* synthetic */ Uri $fileUri;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @NotNull
                public final InputStream invoke(@NotNull InputStream inputStream) {
                    InputStream inputStream2;
                    Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                    String string2 = this.$fileUri.getLastPathSegment();
                    if (string2 != null) {
                        if (StringsKt.endsWith$default((String)string2, (String)".gz", (boolean)false, (int)2, null)) {
                            inputStream2 = new GZIPInputStream(inputStream);
                            return inputStream2;
                        }
                    }
                    inputStream2 = inputStream;
                    return inputStream2;
                }
                {
                    this.$fileUri = uri;
                    super(1);
                }
            };
            timestamp = readFirstLine ? 0L : Long.MAX_VALUE;
            try {
                InputStream inputStream = context.getContentResolver().openInputStream(fileUri);
                if (inputStream == null) break block21;
                Closeable closeable = inputStream;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl3 = false;
                    InputStream inputStream2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"it");
                    Closeable closeable2 = $fun$getInputStream$1.invoke(inputStream2);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Throwable throwable2 = null;
                    try {
                        InputStream gis = (InputStream)closeable2;
                        boolean bl6 = false;
                        Closeable closeable3 = gis;
                        Charset charset = Charsets.UTF_8;
                        boolean bl7 = false;
                        closeable3 = new InputStreamReader((InputStream)closeable3, charset);
                        boolean bl8 = false;
                        bl7 = false;
                        Throwable throwable3 = null;
                        try {
                            InputStreamReader reader = (InputStreamReader)closeable3;
                            boolean bl9 = false;
                            Iterable $this$forEach$iv = TextStreamsKt.readLines((Reader)reader);
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String line = (String)element$iv;
                                boolean bl10 = false;
                                String string2 = (String)StringsKt.split$default((CharSequence)line, (String[])new String[]{"\t"}, (boolean)false, (int)0, (int)6, null).get(1);
                                boolean bl11 = false;
                                timestamp = Long.parseLong(string2);
                                if (!readFirstLine) continue;
                                long l = timestamp;
                                long l2 = l;
                                long l3 = l2;
                                return l3;
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                sLogger.error((Throwable)e, (Function0)readLineTimeStamp.3.INSTANCE);
            }
        }
        return timestamp;
    }

    private PlaybackUtils() {
    }

    static {
        PlaybackUtils playbackUtils;
        INSTANCE = playbackUtils = new PlaybackUtils();
        String string2 = PlaybackUtils.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PlaybackUtils::class.java.name");
        sLogger = JedAILogger.Companion.getLogger(string2);
    }
}

