/*
 * Decompiled with CFR 0.152.
 */
package com.anagog.jedai.debugging.zip;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.anagog.jedai.core.logger.JedAILogger;
import com.anagog.jedai.debugging.files.FileNameUtils;
import com.anagog.jedai.debugging.files.JedAIFileProvider;
import com.anagog.jedai.debugging.zip.DebuggingDataZipConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;

public class DebuggingDataZipProvider {
    private static final JedAILogger sLogger = JedAILogger.getLogger((String)DebuggingDataZipProvider.class.getName());
    private static final String JEDAI_MAIN_DB_NAME = "jedai.db";
    private static final String JEDAI_PERSONAL_POI_DB_NAME = "personal_poi.db";
    private static final String AN_CORE_DB_NAME = "an_core.db";
    private static final String WEEKDAYS_JSON = "weekdays.json";
    private static final String WEEKEND_JSON = "weekend.json";
    private static final String PROFILE_JSON = "profile.json";
    private static final String EDIT_JSON = "edit.json";
    private static final String ZIP_EXTENSION = "zip";
    private final String mUniqueUserId;
    private final JedAIFileProvider mFileProvider;

    public DebuggingDataZipProvider(@NonNull JedAIFileProvider fileProvider, @NonNull String userId) {
        this.mFileProvider = fileProvider;
        this.mUniqueUserId = userId;
    }

    public ZipFile getJedAIDebuggingDataZip(@NonNull DebuggingDataZipConfig config) throws ZipException {
        this.cleanTempFiles(config.directory);
        File zipTargetFile = new File(config.directory.getPath() + "/" + config.zipFileName);
        zipTargetFile.delete();
        ZipFile zipFile = new ZipFile(zipTargetFile);
        String filesSuffix = config.addUserId ? "_" + this.mUniqueUserId : "";
        ZipParameters parameters = this.getZipParameters(config);
        boolean anyDataZipped = false;
        if (config.packLogs) {
            try {
                this.packLogs(zipFile, parameters);
                anyDataZipped = true;
            }
            catch (ZipException e) {
                sLogger.error((Throwable)e, e.getMessage(), new Object[0]);
            }
        }
        if (config.packDatabase) {
            try {
                this.packDatabases(JEDAI_MAIN_DB_NAME, zipFile, parameters, filesSuffix);
                anyDataZipped = true;
                this.packDatabases(JEDAI_PERSONAL_POI_DB_NAME, zipFile, parameters, filesSuffix);
                this.packDatabases(AN_CORE_DB_NAME, zipFile, parameters, filesSuffix);
            }
            catch (ZipException e) {
                sLogger.error((Throwable)e, e.getMessage(), new Object[0]);
            }
        }
        if (config.packProfiles) {
            this.packProfiles(zipFile, parameters, filesSuffix);
        }
        if (config.packSchedule) {
            this.packSchedule(zipFile, parameters, filesSuffix);
        }
        if (!anyDataZipped) {
            throw new ZipException("Can't zip requested data");
        }
        return zipFile;
    }

    @NonNull
    private ZipParameters getZipParameters(@NonNull DebuggingDataZipConfig config) {
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        parameters.setSourceExternalStream(true);
        if (config.encrypt) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(99);
            parameters.setAesKeyStrength(3);
            parameters.setPassword("f33dback");
        }
        return parameters;
    }

    private void cleanTempFiles(@NonNull File rootDir) {
        this.cleanFilteredFiles(rootDir, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("A_") && name.endsWith(DebuggingDataZipProvider.ZIP_EXTENSION);
            }
        });
        this.cleanFilteredFiles(rootDir, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(DebuggingDataZipProvider.WEEKDAYS_JSON) || name.endsWith(DebuggingDataZipProvider.WEEKEND_JSON) || name.endsWith(DebuggingDataZipProvider.PROFILE_JSON) || name.endsWith(DebuggingDataZipProvider.EDIT_JSON);
            }
        });
        this.cleanFilteredFiles(rootDir, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("discover_") && name.endsWith(DebuggingDataZipProvider.ZIP_EXTENSION);
            }
        });
    }

    private void cleanFilteredFiles(@NonNull File rootDir, FilenameFilter filter) {
        for (File file : rootDir.listFiles(filter)) {
            file.delete();
        }
    }

    private void packLogs(@NonNull ZipFile zipFile, @NonNull ZipParameters parameters) throws ZipException {
        for (File file : this.mFileProvider.getLogFiles().listFiles()) {
            try (FileInputStream inputStream = new FileInputStream(file);){
                this.updateFileNameInZip(parameters, file, null);
                zipFile.addStream((InputStream)inputStream, parameters);
            }
            catch (IOException e) {
                throw new ZipException((Throwable)e);
            }
        }
    }

    private void packDatabases(@NonNull String dbName, @NonNull ZipFile zipFile, @NonNull ZipParameters parameters, @Nullable String fileSuffix) throws ZipException {
        for (File file : this.mFileProvider.getDatabaseFiles(dbName)) {
            try (FileInputStream inputStream = new FileInputStream(file);){
                this.updateFileNameInZip(parameters, file, fileSuffix);
                zipFile.addStream((InputStream)inputStream, parameters);
            }
            catch (IOException e) {
                throw new ZipException((Throwable)e);
            }
        }
    }

    private void packProfiles(@NonNull ZipFile zipFile, @NonNull ZipParameters parameters, @Nullable String fileSuffix) throws ZipException {
        throw new ZipException("Profile packing is not implemented yet");
    }

    private void packSchedule(@NonNull ZipFile zipFile, @NonNull ZipParameters parameters, @Nullable String fileSuffix) throws ZipException {
        throw new ZipException("Schedule packing is not implemented yet");
    }

    private void updateFileNameInZip(@NonNull ZipParameters parameters, @NonNull File file, @Nullable String filesSuffix) {
        parameters.setFileNameInZip(TextUtils.isEmpty((CharSequence)filesSuffix) ? file.getName() : FileNameUtils.getFileNameWithoutExtension(file.getName()) + filesSuffix + "." + FileNameUtils.getFileExtension(file.getName()));
    }
}

