/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.loaders;

import com.google.common.cache.CacheLoader;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.googlecomputeengine.compute.functions.Resources;
import org.jclouds.googlecomputeengine.domain.Disk;
import org.jclouds.googlecomputeengine.domain.Image;
import org.jclouds.logging.Logger;

@Singleton
public class DiskURIToImage
extends CacheLoader<URI, Image> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Resources resources;

    @Inject
    DiskURIToImage(Resources resources) {
        this.resources = resources;
    }

    public Image load(URI key) throws ExecutionException {
        try {
            Disk disk = this.resources.disk(key);
            return this.resources.image(disk.sourceImage());
        }
        catch (Exception e) {
            throw new ExecutionException(DiskURIToImage.message(key, e), e);
        }
    }

    public static String message(URI key, Exception e) {
        return String.format("could not find image for disk %s: %s", key.toString(), e.getMessage());
    }
}

