/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.internal.TemplateBuilderImpl;
import org.jclouds.compute.functions.NodeAndTemplateOptionsToStatement;
import org.jclouds.compute.functions.NodeAndTemplateOptionsToStatementWithoutPublicKey;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.googlecomputeengine.compute.GoogleComputeEngineService;
import org.jclouds.googlecomputeengine.compute.GoogleComputeEngineServiceAdapter;
import org.jclouds.googlecomputeengine.compute.domain.internal.GoogleComputeEngineArbitraryCpuRamTemplateBuilderImpl;
import org.jclouds.googlecomputeengine.compute.functions.FirewallTagNamingConvention;
import org.jclouds.googlecomputeengine.compute.functions.GoogleComputeEngineImageToImage;
import org.jclouds.googlecomputeengine.compute.functions.ImageNameToOperatingSystem;
import org.jclouds.googlecomputeengine.compute.functions.InstanceToNodeMetadata;
import org.jclouds.googlecomputeengine.compute.functions.MachineTypeToHardware;
import org.jclouds.googlecomputeengine.compute.functions.OrphanedGroupsFromDeadNodes;
import org.jclouds.googlecomputeengine.compute.functions.ResetWindowsPassword;
import org.jclouds.googlecomputeengine.compute.functions.Resources;
import org.jclouds.googlecomputeengine.compute.loaders.DiskURIToImage;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.googlecomputeengine.compute.predicates.AtomicInstanceVisible;
import org.jclouds.googlecomputeengine.compute.predicates.AtomicOperationDone;
import org.jclouds.googlecomputeengine.compute.predicates.GroupIsEmpty;
import org.jclouds.googlecomputeengine.domain.Image;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.MachineType;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.implicit.FirstZone;
import org.jclouds.rest.config.BinderUtils;
import org.jclouds.util.Predicates2;

public final class GoogleComputeEngineServiceContextModule
extends ComputeServiceAdapterContextModule<Instance, MachineType, Image, Location> {
    private static final Map<Instance.Status, NodeMetadata.Status> toPortableNodeStatus = ImmutableMap.builder().put((Object)Instance.Status.PROVISIONING, (Object)NodeMetadata.Status.PENDING).put((Object)Instance.Status.STAGING, (Object)NodeMetadata.Status.PENDING).put((Object)Instance.Status.RUNNING, (Object)NodeMetadata.Status.RUNNING).put((Object)Instance.Status.STOPPING, (Object)NodeMetadata.Status.PENDING).put((Object)Instance.Status.STOPPED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)Instance.Status.TERMINATED, (Object)NodeMetadata.Status.SUSPENDED).build();

    protected void configure() {
        super.configure();
        this.bind(ComputeService.class).to(GoogleComputeEngineService.class);
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<Instance, MachineType, Image, Location>>(){}).to(GoogleComputeEngineServiceAdapter.class);
        this.bind(TemplateBuilderImpl.class).to(GoogleComputeEngineArbitraryCpuRamTemplateBuilderImpl.class);
        this.install((Module)new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<Instance, MachineType, Image, Location>(){});
        this.bind((TypeLiteral)new TypeLiteral<Function<Location, Location>>(){}).toInstance((Object)Functions.identity());
        this.bind(ImplicitLocationSupplier.class).to(FirstZone.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Instance, NodeMetadata>>(){}).to(InstanceToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<MachineType, Hardware>>(){}).to(MachineTypeToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Image, org.jclouds.compute.domain.Image>>(){}).to(GoogleComputeEngineImageToImage.class);
        this.bind(CreateNodesWithGroupEncodedIntoNameThenAddToSet.class).to(org.jclouds.googlecomputeengine.compute.strategy.CreateNodesWithGroupEncodedIntoNameThenAddToSet.class);
        this.bind(TemplateOptions.class).to(GoogleComputeEngineTemplateOptions.class);
        this.bind(NodeAndTemplateOptionsToStatement.class).to(NodeAndTemplateOptionsToStatementWithoutPublicKey.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Set<? extends NodeMetadata>, Set<String>>>(){}).to(OrphanedGroupsFromDeadNodes.class);
        this.bind((TypeLiteral)new TypeLiteral<Predicate<String>>(){}).to(GroupIsEmpty.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<String, OperatingSystem>>(){}).to(ImageNameToOperatingSystem.class);
        this.bind(new TypeLiteral<Function<Map<String, ?>, String>>(){}).to(ResetWindowsPassword.class);
        this.bind(FirewallTagNamingConvention.Factory.class).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<URI, Image>>(){}).to(DiskURIToImage.class);
        BinderUtils.bindHttpApi((Binder)this.binder(), Resources.class);
    }

    @Provides
    Predicate<AtomicReference<Operation>> operationDone(AtomicOperationDone input, @Named(value="jclouds.google-compute-engine.operation-complete-timeout") long timeout, @Named(value="jclouds.google-compute-engine.operation-complete-interval") long interval) {
        return Predicates2.retry((Predicate)input, (long)timeout, (long)interval, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Provides
    Predicate<AtomicReference<Instance>> instanceVisible(AtomicInstanceVisible input, @Named(value="jclouds.google-compute-engine.operation-complete-timeout") long timeout, @Named(value="jclouds.google-compute-engine.operation-complete-interval") long interval) {
        return Predicates2.retry((Predicate)input, (long)timeout, (long)interval, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Provides
    @Singleton
    @Memoized
    Supplier<Map<URI, Hardware>> hardwareByUri(final @Memoized Supplier<Set<? extends Hardware>> hardwareSupplier, @Named(value="jclouds.session-interval") long seconds) {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<Map<URI, Hardware>>(){

            public Map<URI, Hardware> get() {
                ImmutableMap.Builder result = ImmutableMap.builder();
                for (Hardware hardware : (Set)hardwareSupplier.get()) {
                    result.put((Object)hardware.getUri(), (Object)hardware);
                }
                return result.build();
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Memoized
    Supplier<Map<URI, Location>> locationsByUri(final @Memoized Supplier<Set<? extends Location>> locations, @Named(value="jclouds.session-interval") long seconds) {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<Map<URI, Location>>(){

            public Map<URI, Location> get() {
                ImmutableMap.Builder result = ImmutableMap.builder();
                for (Location location : (Set)locations.get()) {
                    result.put((Object)URI.create(location.getDescription()), (Object)location);
                }
                return result.build();
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    protected Map<OsFamily, LoginCredentials> osFamilyToCredentials(Injector injector) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        block4: for (OsFamily family : OsFamily.values()) {
            switch (family) {
                case COREOS: {
                    builder.put((Object)family, (Object)LoginCredentials.builder().user("core").build());
                    continue block4;
                }
                case WINDOWS: {
                    builder.put((Object)family, (Object)LoginCredentials.builder().user("Administrator").build());
                    continue block4;
                }
                default: {
                    builder.put((Object)family, (Object)LoginCredentials.builder().user("jclouds").build());
                }
            }
        }
        return builder.build();
    }

    @Provides
    @Singleton
    protected LoadingCache<URI, Image> diskURIToImageMap(CacheLoader<URI, Image> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    Map<Instance.Status, NodeMetadata.Status> toPortableNodeStatus() {
        return toPortableNodeStatus;
    }
}

