/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.xml.SpotInstancesHandler;
import org.jclouds.date.DateService;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.location.Region;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SpotInstancesHandlerTest")
public class SpotInstancesHandlerTest
extends BaseEC2HandlerTest {
    private DateService dateService;

    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(), new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).annotatedWith(Region.class).toInstance((Object)Suppliers.ofInstance((Object)"us-east-1"));
            }
        }});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        this.dateService = (DateService)this.injector.getInstance(DateService.class);
        assert (this.dateService != null);
    }

    public void testDescribe() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/describe_spot_instance_requests.xml");
        SpotInstancesHandler handler = (SpotInstancesHandler)this.injector.getInstance(SpotInstancesHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((int)result.size(), (int)18);
    }

    public void testRequest() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/request_spot_instances.xml");
        SpotInstancesHandler handler = (SpotInstancesHandler)this.injector.getInstance(SpotInstancesHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((int)result.size(), (int)3);
    }

    public void testParseTags() {
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(SpotInstancesHandler.class)).parse(((Object)((Object)this)).getClass().getResourceAsStream("/describe_spot_instance_tags.xml"));
        Iterable tags = Iterables.transform((Iterable)result, (Function)new Function<SpotInstanceRequest, Map<String, String>>(){

            public Map<String, String> apply(SpotInstanceRequest input) {
                return input.getTags();
            }
        });
        Assert.assertEquals((Map)((Map)Iterables.get((Iterable)tags, (int)0)), (Map)ImmutableMap.of((Object)"One", (Object)"one", (Object)"Two", (Object)"one"));
        Assert.assertEquals((Map)((Map)Iterables.get((Iterable)tags, (int)1)), (Map)ImmutableMap.of((Object)"One", (Object)"two", (Object)"Two", (Object)"two"));
        Assert.assertEquals((Map)((Map)Iterables.get((Iterable)tags, (int)2)), (Map)ImmutableMap.of((Object)"Two", (Object)"three", (Object)"Three", (Object)"three", (Object)"Four", (Object)""));
    }

    public void testParseNoNPE() {
        this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(SpotInstancesHandler.class)).parse(((Object)((Object)this)).getClass().getResourceAsStream("/describe_spot_instances_1.xml"));
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

