/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.collect.Iterables;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.features.AWSSecurityGroupApi;
import org.jclouds.aws.ec2.options.CreateSecurityGroupOptions;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.features.internal.BaseTagApiLiveTest;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class TagSecurityGroupLiveTest
extends BaseTagApiLiveTest {
    public TagSecurityGroupLiveTest() {
        this.provider = "aws-ec2";
    }

    protected BaseTagApiLiveTest.Resource createResourceForTagging(String prefix) {
        try {
            return new BaseTagApiLiveTest.Resource(this.securityGroupApi().createSecurityGroupInRegionAndReturnId(null, prefix, prefix, new CreateSecurityGroupOptions[0]), "security-group");
        }
        catch (IllegalStateException e) {
            return new BaseTagApiLiveTest.Resource(((SecurityGroup)Iterables.get((Iterable)this.securityGroupApi().describeSecurityGroupsInRegion(null, new String[]{prefix}), (int)0)).getId(), "security-group");
        }
    }

    protected void cleanupResource(BaseTagApiLiveTest.Resource resource) {
        this.securityGroupApi().deleteSecurityGroupInRegionById(null, resource.id);
    }

    private AWSSecurityGroupApi securityGroupApi() {
        return (AWSSecurityGroupApi)((AWSEC2Api)AWSEC2Api.class.cast(this.api)).getSecurityGroupApi().get();
    }
}

