/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.collect.ImmutableList;
import com.squareup.okhttp.mockwebserver.MockResponse;
import java.util.Map;
import java.util.Set;
import org.jclouds.aws.ec2.features.AWSAMIApi;
import org.jclouds.aws.ec2.internal.BaseAWSEC2ApiMockTest;
import org.jclouds.ec2.domain.Permission;
import org.jclouds.ec2.options.CreateImageOptions;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.ec2.options.RegisterImageBackedByEbsOptions;
import org.jclouds.ec2.options.RegisterImageOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AWSAMIApiMockTest", singleThreaded=true)
public class AWSAMIApiMockTest
extends BaseAWSEC2ApiMockTest {
    public void describeImagesInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/amzn_images.xml");
        Set result = this.amiApi().describeImagesInRegion("us-east-1", new DescribeImagesOptions[0]);
        Assert.assertFalse((boolean)result.isEmpty());
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeImages");
    }

    public void describeImagesInRegion_options() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/amzn_images.xml");
        Set result = this.amiApi().describeImagesInRegion("us-east-1", new DescribeImagesOptions[]{DescribeImagesOptions.Builder.executableBy((String)"me").ownedBy(new String[]{"fred", "nancy"}).imageIds(new String[]{"1", "2"})});
        Assert.assertFalse((boolean)result.isEmpty());
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeImages&ExecutableBy=me&Owner.1=fred&Owner.2=nancy&ImageId.1=1&ImageId.2=2");
    }

    public void describeImagesInRegion_404() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse().setResponseCode(404));
        Set result = this.amiApi().describeImagesInRegion("us-east-1", new DescribeImagesOptions[0]);
        Assert.assertTrue((boolean)result.isEmpty());
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeImages");
    }

    public void createImageInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse().setBody("<CreateImageResponse><ImageId>ami-246f8d4d</ImageId></CreateImageResponse>"));
        String result = this.amiApi().createImageInRegion("us-east-1", "name", "instanceId", new CreateImageOptions[0]);
        Assert.assertEquals((String)result, (String)"ami-246f8d4d");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=CreateImage&Name=name&InstanceId=instanceId");
    }

    public void createImageInRegion_options() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse().setBody("<CreateImageResponse><ImageId>ami-246f8d4d</ImageId></CreateImageResponse>"));
        String result = this.amiApi().createImageInRegion("us-east-1", "name", "instanceId", new CreateImageOptions[]{new CreateImageOptions().withDescription("description").noReboot()});
        Assert.assertEquals((String)result, (String)"ami-246f8d4d");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=CreateImage&Name=name&InstanceId=instanceId&Description=description&NoReboot=true");
    }

    public void registerImageFromManifestInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse().setBody("<RegisterImageResponse><ImageId>ami-246f8d4d</ImageId></RegisterImageResponse>"));
        String result = this.amiApi().registerImageFromManifestInRegion("us-east-1", "name", "pathToManifest", new RegisterImageOptions[0]);
        Assert.assertEquals((String)result, (String)"ami-246f8d4d");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=RegisterImage&Name=name&ImageLocation=pathToManifest");
    }

    public void registerImageFromManifestInRegion_options() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse().setBody("<RegisterImageResponse><ImageId>ami-246f8d4d</ImageId></RegisterImageResponse>"));
        String result = this.amiApi().registerImageFromManifestInRegion("us-east-1", "name", "pathToManifest", new RegisterImageOptions[]{new RegisterImageOptions().withDescription("description")});
        Assert.assertEquals((String)result, (String)"ami-246f8d4d");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=RegisterImage&Name=name&ImageLocation=pathToManifest&Description=description");
    }

    public void registerUnixImageBackedByEbsInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse().setBody("<RegisterImageResponse><ImageId>ami-246f8d4d</ImageId></RegisterImageResponse>"));
        String result = this.amiApi().registerUnixImageBackedByEbsInRegion("us-east-1", "imageName", "snapshotId", new RegisterImageBackedByEbsOptions[0]);
        Assert.assertEquals((String)result, (String)"ami-246f8d4d");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=RegisterImage&RootDeviceName=/dev/sda1&BlockDeviceMapping.0.DeviceName=/dev/sda1&Name=imageName&BlockDeviceMapping.0.Ebs.SnapshotId=snapshotId");
    }

    public void registerUnixImageBackedByEbsInRegion_options() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse().setBody("<RegisterImageResponse><ImageId>ami-246f8d4d</ImageId></RegisterImageResponse>"));
        String result = this.amiApi().registerUnixImageBackedByEbsInRegion("us-east-1", "imageName", "snapshotId", new RegisterImageBackedByEbsOptions[]{new RegisterImageBackedByEbsOptions().withDescription("description").addBlockDeviceFromSnapshot("/dev/device", null, "snapshot", false, "gp2", null, false).addNewBlockDevice("/dev/newdevice", "newblock", 100)});
        Assert.assertEquals((String)result, (String)"ami-246f8d4d");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=RegisterImage&RootDeviceName=/dev/sda1&BlockDeviceMapping.0.DeviceName=/dev/sda1&Name=imageName&BlockDeviceMapping.0.Ebs.SnapshotId=snapshotId&Description=description&BlockDeviceMapping.1.Ebs.DeleteOnTermination=false&BlockDeviceMapping.1.Ebs.VolumeType=gp2&BlockDeviceMapping.1.DeviceName=/dev/device&BlockDeviceMapping.1.Ebs.SnapshotId=snapshot&BlockDeviceMapping.2.Ebs.DeleteOnTermination=false&BlockDeviceMapping.2.DeviceName=/dev/newdevice&BlockDeviceMapping.2.VirtualName=newblock&BlockDeviceMapping.2.Ebs.VolumeSize=100");
    }

    public void deregisterImageInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse());
        this.amiApi().deregisterImageInRegion("us-east-1", "ami-246f8d4d");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DeregisterImage&ImageId=ami-246f8d4d");
    }

    public void getBlockDeviceMappingsForImageInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/describe_image_attribute_blockDeviceMapping.xml");
        Map result = this.amiApi().getBlockDeviceMappingsForImageInRegion("us-east-1", "ami-246f8d4d");
        Assert.assertFalse((boolean)result.isEmpty());
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeImageAttribute&Attribute=blockDeviceMapping&ImageId=ami-246f8d4d");
    }

    public void getLaunchPermissionForImageInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/describe_image_attribute_launchPermission.xml");
        Permission result = this.amiApi().getLaunchPermissionForImageInRegion("us-east-1", "ami-246f8d4d");
        Assert.assertNotNull((Object)result);
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeImageAttribute&Attribute=launchPermission&ImageId=ami-246f8d4d");
    }

    public void addLaunchPermissionsToImageInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse());
        this.amiApi().addLaunchPermissionsToImageInRegion("us-east-1", (Iterable)ImmutableList.of((Object)"bob", (Object)"sue"), (Iterable)ImmutableList.of((Object)"all"), "imageId");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=ModifyImageAttribute&OperationType=add&Attribute=launchPermission&ImageId=imageId&UserId.1=bob&UserId.2=sue&UserGroup.1=all");
    }

    public void removeLaunchPermissionsFromImageInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse());
        this.amiApi().removeLaunchPermissionsFromImageInRegion("us-east-1", (Iterable)ImmutableList.of((Object)"bob", (Object)"sue"), (Iterable)ImmutableList.of((Object)"all"), "imageId");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=ModifyImageAttribute&OperationType=remove&Attribute=launchPermission&ImageId=imageId&UserId.1=bob&UserId.2=sue&UserGroup.1=all");
    }

    public void resetLaunchPermissionsOnImageInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse());
        this.amiApi().resetLaunchPermissionsOnImageInRegion("us-east-1", "imageId");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=ResetImageAttribute&Attribute=launchPermission&ImageId=imageId");
    }

    public void getProductCodesForImageInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/describe_image_attribute_productCodes.xml");
        Set result = this.amiApi().getProductCodesForImageInRegion("us-east-1", "ami-246f8d4d");
        Assert.assertFalse((boolean)result.isEmpty());
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeImageAttribute&Attribute=productCodes&ImageId=ami-246f8d4d");
    }

    public void addProductCodesToImageInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse());
        this.amiApi().addProductCodesToImageInRegion("us-east-1", (Iterable)ImmutableList.of((Object)"code1", (Object)"code2"), "imageId");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=ModifyImageAttribute&OperationType=add&Attribute=productCodes&ImageId=imageId&ProductCode.1=code1&ProductCode.2=code2");
    }

    public void removeProductCodesFromImageInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse());
        this.amiApi().removeProductCodesFromImageInRegion("us-east-1", (Iterable)ImmutableList.of((Object)"code1", (Object)"code2"), "imageId");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=ModifyImageAttribute&OperationType=remove&Attribute=productCodes&ImageId=imageId&ProductCode.1=code1&ProductCode.2=code2");
    }

    private AWSAMIApi amiApi() {
        return (AWSAMIApi)this.api().getAMIApi().get();
    }
}

