/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.extensions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.features.AWSAMIApi;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Image;
import org.jclouds.ec2.compute.extensions.EC2ImageExtensionLiveTest;
import org.jclouds.ec2.compute.functions.EC2ImageParser;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="AWSEC2ImageExtensionLiveTest")
public class AWSEC2ImageExtensionLiveTest
extends EC2ImageExtensionLiveTest {
    public AWSEC2ImageExtensionLiveTest() {
        this.provider = "aws-ec2";
    }

    protected Iterable<? extends Image> listImages() {
        AWSEC2Api client = (AWSEC2Api)((ComputeServiceContext)this.view).unwrapApi(AWSEC2Api.class);
        String[] parts = AWSUtils.parseHandle((String)this.imageId);
        String region = parts[0];
        String imageId = parts[1];
        EC2ImageParser parser = (EC2ImageParser)((ComputeServiceContext)this.view).utils().injector().getInstance(EC2ImageParser.class);
        return Iterables.transform((Iterable)((AWSAMIApi)client.getAMIApi().get()).describeImagesInRegion(region, new DescribeImagesOptions[]{new DescribeImagesOptions().imageIds(new String[]{imageId})}), (Function)parser);
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }
}

