/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.options.RequestSpotInstancesOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RequestSpotInstancesOptionsTest {
    Date test = new Date(12345678910L);

    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(RequestSpotInstancesOptions.class));
        assert (!String.class.isAssignableFrom(RequestSpotInstancesOptions.class));
    }

    @Test
    public void testAvailabilityZoneGroup() {
        RequestSpotInstancesOptions options = new RequestSpotInstancesOptions();
        options.availabilityZoneGroup("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"AvailabilityZoneGroup"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testAvailabilityZoneGroupStatic() {
        RequestSpotInstancesOptions options = RequestSpotInstancesOptions.Builder.availabilityZoneGroup((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"AvailabilityZoneGroup"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testAvailabilityZoneGroupNPE() {
        RequestSpotInstancesOptions.Builder.availabilityZoneGroup(null);
    }

    @Test
    public void testLaunchGroup() {
        RequestSpotInstancesOptions options = new RequestSpotInstancesOptions();
        options.launchGroup("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"LaunchGroup"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testLaunchGroupStatic() {
        RequestSpotInstancesOptions options = RequestSpotInstancesOptions.Builder.launchGroup((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"LaunchGroup"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testLaunchGroupNPE() {
        RequestSpotInstancesOptions.Builder.launchGroup(null);
    }

    @Test
    public void testInstanceType() {
        RequestSpotInstancesOptions options = new RequestSpotInstancesOptions();
        options.type(SpotInstanceRequest.Type.PERSISTENT);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Type"), (Collection)ImmutableList.of((Object)"persistent"));
    }

    @Test
    public void testInstanceTypeStatic() {
        RequestSpotInstancesOptions options = RequestSpotInstancesOptions.Builder.type((SpotInstanceRequest.Type)SpotInstanceRequest.Type.PERSISTENT);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Type"), (Collection)ImmutableList.of((Object)"persistent"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testInstanceTypeNPE() {
        RequestSpotInstancesOptions.Builder.type(null);
    }

    @Test
    public void testFrom() {
        RequestSpotInstancesOptions options = new RequestSpotInstancesOptions();
        options.validFrom(this.test);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ValidFrom"), (Collection)ImmutableList.of((Object)"1970-05-23T21:21:18Z"));
    }

    @Test
    public void testFromStatic() {
        RequestSpotInstancesOptions options = RequestSpotInstancesOptions.Builder.validFrom((Date)this.test);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ValidFrom"), (Collection)ImmutableList.of((Object)"1970-05-23T21:21:18Z"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testFromNPE() {
        RequestSpotInstancesOptions.Builder.validFrom(null);
    }

    @Test
    public void testTo() {
        RequestSpotInstancesOptions options = new RequestSpotInstancesOptions();
        options.validUntil(this.test);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ValidUntil"), (Collection)ImmutableList.of((Object)"1970-05-23T21:21:18Z"));
    }

    @Test
    public void testToStatic() {
        RequestSpotInstancesOptions options = RequestSpotInstancesOptions.Builder.validUntil((Date)this.test);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ValidUntil"), (Collection)ImmutableList.of((Object)"1970-05-23T21:21:18Z"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testToNPE() {
        RequestSpotInstancesOptions.Builder.validUntil(null);
    }
}

