/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.functions;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import org.easymock.EasyMock;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.features.AWSKeyPairApi;
import org.jclouds.aws.ec2.functions.ImportOrReturnExistingKeypair;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ssh.SshKeys;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ImportOrReturnExistingKeypairTest {
    private static final String PUBLIC_KEY = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCcm8DjTHg4r72dVhNLQ33XpUyMLr+ph78i4NR3LqF1bXDP0g4xNLcI/GUTQq6g07X8zs7vIWyjoitqBPFSQ2onaZQ6pXQF/QISRQgrN5hEZ+nH5Aw+isdstBeOMWKdYrCJtm6/qWq2+rByyuNbtulazP3H7SqoozSjRSGNQyFNGpmhjGgTbNQftYDwlFq0T9tCSO/+dYF8j79bNIOEmfsCMiqXQ13hD5vGiEgkRm7zIPDUfpOl3ubDzebpRgGTh5kfv2vd3Z665AxQoi6fItvDu80knyphMlC41giIm5YqfPOPG4lR+6aF06p+NKhvOeECNMtRsD9u1kKJD9NqxXhx";
    private static final KeyPair pair = KeyPair.builder().region("region").keyName("jclouds#group").sha1OfPrivateKey("foo").build();
    private static final KeyPair pairWithFingerprint = pair.toBuilder().fingerprint(SshKeys.fingerprintPublicKey((String)"ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCcm8DjTHg4r72dVhNLQ33XpUyMLr+ph78i4NR3LqF1bXDP0g4xNLcI/GUTQq6g07X8zs7vIWyjoitqBPFSQ2onaZQ6pXQF/QISRQgrN5hEZ+nH5Aw+isdstBeOMWKdYrCJtm6/qWq2+rByyuNbtulazP3H7SqoozSjRSGNQyFNGpmhjGgTbNQftYDwlFq0T9tCSO/+dYF8j79bNIOEmfsCMiqXQ13hD5vGiEgkRm7zIPDUfpOl3ubDzebpRgGTh5kfv2vd3Z665AxQoi6fItvDu80knyphMlC41giIm5YqfPOPG4lR+6aF06p+NKhvOeECNMtRsD9u1kKJD9NqxXhx")).build();

    @Test
    public void testApply() {
        AWSEC2Api client = (AWSEC2Api)EasyMock.createMock(AWSEC2Api.class);
        AWSKeyPairApi keyApi = (AWSKeyPairApi)EasyMock.createMock(AWSKeyPairApi.class);
        EasyMock.expect((Object)client.getKeyPairApi()).andReturn((Object)Optional.of((Object)keyApi)).atLeastOnce();
        EasyMock.expect((Object)keyApi.importKeyPairInRegion("region", "jclouds#group", PUBLIC_KEY)).andReturn((Object)pair);
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{keyApi});
        ImportOrReturnExistingKeypair parser = new ImportOrReturnExistingKeypair(client);
        Assert.assertEquals((Object)parser.importOrReturnExistingKeypair("region", "group", PUBLIC_KEY), (Object)pairWithFingerprint);
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{keyApi});
    }

    @Test
    public void testApplyWithIllegalStateExceptionReturnsExistingKey() {
        AWSEC2Api client = (AWSEC2Api)EasyMock.createMock(AWSEC2Api.class);
        AWSKeyPairApi keyApi = (AWSKeyPairApi)EasyMock.createMock(AWSKeyPairApi.class);
        EasyMock.expect((Object)client.getKeyPairApi()).andReturn((Object)Optional.of((Object)keyApi)).atLeastOnce();
        EasyMock.expect((Object)keyApi.importKeyPairInRegion("region", "jclouds#group", PUBLIC_KEY)).andThrow((Throwable)new IllegalStateException());
        EasyMock.expect((Object)keyApi.describeKeyPairsInRegion("region", new String[]{"jclouds#group"})).andReturn((Object)ImmutableSet.of((Object)pair));
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{keyApi});
        ImportOrReturnExistingKeypair parser = new ImportOrReturnExistingKeypair(client);
        Assert.assertEquals((Object)parser.importOrReturnExistingKeypair("region", "group", PUBLIC_KEY), (Object)pairWithFingerprint);
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{keyApi});
    }

    @Test
    public void testApplyWithIllegalStateExceptionRetriesWhenExistingKeyNotFound() {
        AWSEC2Api client = (AWSEC2Api)EasyMock.createMock(AWSEC2Api.class);
        AWSKeyPairApi keyApi = (AWSKeyPairApi)EasyMock.createMock(AWSKeyPairApi.class);
        EasyMock.expect((Object)client.getKeyPairApi()).andReturn((Object)Optional.of((Object)keyApi)).atLeastOnce();
        EasyMock.expect((Object)keyApi.importKeyPairInRegion("region", "jclouds#group", PUBLIC_KEY)).andThrow((Throwable)new IllegalStateException());
        EasyMock.expect((Object)keyApi.describeKeyPairsInRegion("region", new String[]{"jclouds#group"})).andReturn((Object)ImmutableSet.of());
        EasyMock.expect((Object)keyApi.importKeyPairInRegion("region", "jclouds#group", PUBLIC_KEY)).andThrow((Throwable)new IllegalStateException());
        EasyMock.expect((Object)keyApi.describeKeyPairsInRegion("region", new String[]{"jclouds#group"})).andReturn((Object)ImmutableSet.of((Object)pair));
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{keyApi});
        ImportOrReturnExistingKeypair parser = new ImportOrReturnExistingKeypair(client);
        Assert.assertEquals((Object)parser.importOrReturnExistingKeypair("region", "group", PUBLIC_KEY), (Object)pairWithFingerprint);
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{keyApi});
    }
}

