/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.aws.ec2.features.AWSSecurityGroupApi;
import org.jclouds.aws.ec2.features.BaseAWSEC2ApiTest;
import org.jclouds.aws.ec2.xml.AWSEC2DescribeSecurityGroupsResponseHandler;
import org.jclouds.ec2.util.IpPermissions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AWSSecurityGroupApiTest")
public class AWSSecurityGroupApiTest
extends BaseAWSEC2ApiTest<AWSSecurityGroupApi> {
    public AWSSecurityGroupApiTest() {
        this.provider = "aws-ec2";
    }

    public void testDeleteSecurityGroup() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AWSSecurityGroupApi.class, (String)"deleteSecurityGroupInRegionById", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "id"}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DeleteSecurityGroup&GroupId=id", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeSecurityGroups() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AWSSecurityGroupApi.class, (String)"describeSecurityGroupsInRegionById", (Class[])new Class[]{String.class, String[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DescribeSecurityGroups", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, AWSEC2DescribeSecurityGroupsResponseHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeSecurityGroupsArgs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AWSSecurityGroupApi.class, (String)"describeSecurityGroupsInRegionById", (Class[])new Class[]{String.class, String[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "1", "2"}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DescribeSecurityGroups&GroupId.1=1&GroupId.2=2", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, AWSEC2DescribeSecurityGroupsResponseHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateSecurityGroup() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AWSSecurityGroupApi.class, (String)"createSecurityGroupInRegion", (Class[])new Class[]{String.class, String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "name", "description"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=CreateSecurityGroup&GroupName=name&GroupDescription=description&Version=2012-06-01", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAuthorizeSecurityGroupIpPermission() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AWSSecurityGroupApi.class, (String)"authorizeSecurityGroupIngressInRegion", (Class[])new Class[]{String.class, String.class, IpPermission.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "group", IpPermissions.permitAnyProtocol()}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=AuthorizeSecurityGroupIngress&GroupId=group&IpPermissions.0.IpProtocol=-1&IpPermissions.0.FromPort=1&IpPermissions.0.ToPort=65535&IpPermissions.0.IpRanges.0.CidrIp=0.0.0.0/0", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAuthorizeSecurityGroupIpPermissions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AWSSecurityGroupApi.class, (String)"authorizeSecurityGroupIngressInRegion", (Class[])new Class[]{String.class, String.class, Iterable.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "group", ImmutableSet.of((Object)IpPermissions.permit((IpProtocol)IpProtocol.TCP).originatingFromCidrBlock("1.1.1.1/32"), (Object)IpPermissions.permitICMP().type(8).andCode(0).originatingFromSecurityGroupId("groupId"))}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=AuthorizeSecurityGroupIngress&GroupId=group&IpPermissions.0.IpProtocol=tcp&IpPermissions.0.FromPort=1&IpPermissions.0.ToPort=65535&IpPermissions.0.IpRanges.0.CidrIp=1.1.1.1/32&IpPermissions.1.IpProtocol=icmp&IpPermissions.1.FromPort=8&IpPermissions.1.ToPort=0&IpPermissions.1.Groups.0.GroupId=groupId", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRevokeSecurityGroupIpPermission() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AWSSecurityGroupApi.class, (String)"revokeSecurityGroupIngressInRegion", (Class[])new Class[]{String.class, String.class, IpPermission.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "group", IpPermissions.permitAnyProtocol()}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=RevokeSecurityGroupIngress&GroupId=group&IpPermissions.0.IpProtocol=-1&IpPermissions.0.FromPort=1&IpPermissions.0.ToPort=65535&IpPermissions.0.IpRanges.0.CidrIp=0.0.0.0/0", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRevokeSecurityGroupIpPermissions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AWSSecurityGroupApi.class, (String)"revokeSecurityGroupIngressInRegion", (Class[])new Class[]{String.class, String.class, Iterable.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "group", ImmutableSet.of((Object)IpPermissions.permit((IpProtocol)IpProtocol.TCP).originatingFromCidrBlock("1.1.1.1/32"), (Object)IpPermissions.permitICMP().type(8).andCode(0).originatingFromSecurityGroupId("groupId"))}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=RevokeSecurityGroupIngress&GroupId=group&IpPermissions.0.IpProtocol=tcp&IpPermissions.0.FromPort=1&IpPermissions.0.ToPort=65535&IpPermissions.0.IpRanges.0.CidrIp=1.1.1.1/32&IpPermissions.1.IpProtocol=icmp&IpPermissions.1.FromPort=8&IpPermissions.1.ToPort=0&IpPermissions.1.Groups.0.GroupId=groupId", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }
}

