/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMultimap;
import java.util.Set;
import org.jclouds.aws.ec2.features.AWSSecurityGroupApi;
import org.jclouds.aws.ec2.options.CreateSecurityGroupOptions;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.domain.UserIdGroupPair;
import org.jclouds.ec2.features.SecurityGroupApiLiveTest;
import org.jclouds.ec2.util.IpPermissions;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class AWSSecurityGroupApiLiveTest
extends SecurityGroupApiLiveTest {
    public AWSSecurityGroupApiLiveTest() {
        this.provider = "aws-ec2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testAuthorizeSecurityGroupIngressSourceGroup() {
        String group1Name = PREFIX + "ingress1";
        String group2Name = PREFIX + "ingress2";
        this.cleanupAndSleep(group2Name);
        this.cleanupAndSleep(group1Name);
        try {
            final String group1Id = ((AWSSecurityGroupApi)AWSSecurityGroupApi.class.cast(this.client)).createSecurityGroupInRegionAndReturnId(null, group1Name, group1Name, new CreateSecurityGroupOptions[0]);
            String group2Id = ((AWSSecurityGroupApi)AWSSecurityGroupApi.class.cast(this.client)).createSecurityGroupInRegionAndReturnId(null, group2Name, group2Name, new CreateSecurityGroupOptions[0]);
            this.ensureGroupsExist(group1Name, group2Name);
            this.client.authorizeSecurityGroupIngressInRegion(null, group1Name, IpProtocol.TCP, 80, 80, "0.0.0.0/0");
            AWSSecurityGroupApiLiveTest.assertEventually((Runnable)new SecurityGroupApiLiveTest.GroupHasPermission(this.client, group1Name, (Predicate)new SecurityGroupApiLiveTest.TCPPort80AllIPs()));
            Set oneResult = this.client.describeSecurityGroupsInRegion(null, new String[]{group1Name});
            Assert.assertNotNull((Object)oneResult);
            Assert.assertEquals((int)oneResult.size(), (int)1);
            final SecurityGroup group = (SecurityGroup)oneResult.iterator().next();
            Assert.assertEquals((String)group.getName(), (String)group1Name);
            UserIdGroupPair to = new UserIdGroupPair(group.getOwnerId(), group1Name);
            this.client.authorizeSecurityGroupIngressInRegion(null, group2Name, to);
            AWSSecurityGroupApiLiveTest.assertEventually((Runnable)new SecurityGroupApiLiveTest.GroupHasPermission(this.client, group2Name, (Predicate)new Predicate<IpPermission>(){

                public boolean apply(IpPermission arg0) {
                    return arg0.getTenantIdGroupNamePairs().equals((Object)ImmutableMultimap.of((Object)group.getOwnerId(), (Object)group1Id));
                }
            }));
            this.client.revokeSecurityGroupIngressInRegion(null, group2Name, new UserIdGroupPair(group.getOwnerId(), group1Name));
            AWSSecurityGroupApiLiveTest.assertEventually((Runnable)new SecurityGroupApiLiveTest.GroupHasNoPermissions(this.client, group2Name));
        }
        finally {
            this.client.deleteSecurityGroupInRegion(null, group2Name);
            this.client.deleteSecurityGroupInRegion(null, group1Name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testAuthorizeSecurityGroupIngressIpPermission() throws InterruptedException {
        String group1Name = PREFIX + "ingress11";
        String group2Name = PREFIX + "ingress12";
        this.cleanupAndSleep(group2Name);
        this.cleanupAndSleep(group1Name);
        try {
            final String group1Id = ((AWSSecurityGroupApi)AWSSecurityGroupApi.class.cast(this.client)).createSecurityGroupInRegionAndReturnId(null, group1Name, group1Name, new CreateSecurityGroupOptions[0]);
            String group2Id = ((AWSSecurityGroupApi)AWSSecurityGroupApi.class.cast(this.client)).createSecurityGroupInRegionAndReturnId(null, group2Name, group2Name, new CreateSecurityGroupOptions[0]);
            Thread.sleep(100L);
            this.ensureGroupsExist(group1Name, group2Name);
            ((AWSSecurityGroupApi)AWSSecurityGroupApi.class.cast(this.client)).authorizeSecurityGroupIngressInRegion(null, group1Id, (IpPermission)IpPermissions.permit((IpProtocol)IpProtocol.TCP).port(80));
            AWSSecurityGroupApiLiveTest.assertEventually((Runnable)new SecurityGroupApiLiveTest.GroupHasPermission(this.client, group1Name, (Predicate)new SecurityGroupApiLiveTest.TCPPort80AllIPs()));
            Set oneResult = this.client.describeSecurityGroupsInRegion(null, new String[]{group1Name});
            Assert.assertNotNull((Object)oneResult);
            Assert.assertEquals((int)oneResult.size(), (int)1);
            final SecurityGroup group = (SecurityGroup)oneResult.iterator().next();
            Assert.assertEquals((String)group.getName(), (String)group1Name);
            IpPermissions group2CanHttpGroup1 = IpPermissions.permit((IpProtocol)IpProtocol.TCP).port(80).originatingFromSecurityGroupId(group1Id);
            ((AWSSecurityGroupApi)AWSSecurityGroupApi.class.cast(this.client)).authorizeSecurityGroupIngressInRegion(null, group2Id, (IpPermission)group2CanHttpGroup1);
            AWSSecurityGroupApiLiveTest.assertEventually((Runnable)new SecurityGroupApiLiveTest.GroupHasPermission(this.client, group2Name, (Predicate)new Predicate<IpPermission>(){

                public boolean apply(IpPermission arg0) {
                    return arg0.getTenantIdGroupNamePairs().equals((Object)ImmutableMultimap.of((Object)group.getOwnerId(), (Object)group1Id)) && arg0.getFromPort() == 80 && arg0.getToPort() == 80 && arg0.getIpProtocol() == IpProtocol.TCP;
                }
            }));
            ((AWSSecurityGroupApi)AWSSecurityGroupApi.class.cast(this.client)).revokeSecurityGroupIngressInRegion(null, group2Id, (IpPermission)group2CanHttpGroup1);
            AWSSecurityGroupApiLiveTest.assertEventually((Runnable)new SecurityGroupApiLiveTest.GroupHasNoPermissions(this.client, group2Name));
        }
        finally {
            this.client.deleteSecurityGroupInRegion(null, group2Name);
            this.client.deleteSecurityGroupInRegion(null, group1Name);
        }
    }
}

