/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Module;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jclouds.aws.domain.Region;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.features.AWSInstanceApi;
import org.jclouds.aws.ec2.features.AWSKeyPairApi;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.ComputeTestUtils;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class AWSKeyPairApiLiveTest
extends BaseComputeServiceContextLiveTest {
    private AWSKeyPairApi client;
    public static final String PREFIX = System.getProperty("user.name") + "-ec2";

    public AWSKeyPairApiLiveTest() {
        this.provider = "aws-ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.client = (AWSKeyPairApi)((AWSEC2Api)((ComputeServiceContext)this.view).unwrapApi(AWSEC2Api.class)).getKeyPairApi().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoSsh() throws Exception {
        Map keyPair = ComputeTestUtils.setupKeyPair();
        AWSInstanceApi instanceApi = (AWSInstanceApi)((AWSEC2Api)((ComputeServiceContext)this.view).unwrapApi(AWSEC2Api.class)).getInstanceApi().get();
        String group = PREFIX + "unssh";
        ((ComputeServiceContext)this.view).getComputeService().destroyNodesMatching(NodePredicates.inGroup((String)group));
        TemplateOptions options = ((ComputeServiceContext)this.view).getComputeService().templateOptions();
        options.authorizePublicKey((String)keyPair.get("public")).as(AWSEC2TemplateOptions.class);
        ComputeServiceContext noSshContext = null;
        try {
            noSshContext = (ComputeServiceContext)this.createView(this.setupProperties(), (Iterable)ImmutableSet.of((Object)new Log4JLoggingModule()));
            Set nodes = noSshContext.getComputeService().createNodesInGroup(group, 1, options);
            NodeMetadata first = (NodeMetadata)Iterables.get((Iterable)nodes, (int)0);
            assert (first.getCredentials() != null) : first;
            assert (first.getCredentials().identity != null) : first;
            assert (first.getCredentials().credential == null) : first;
            AWSRunningInstance instance = this.getInstance(instanceApi, first.getProviderId());
            Assert.assertEquals((String)instance.getKeyName(), (String)("jclouds#" + group));
            Map responses = ((ComputeServiceContext)this.view).getComputeService().runScriptOnNodesMatching(NodePredicates.runningInGroup((String)group), Statements.exec((String)"echo hello"), (RunScriptOptions)TemplateOptions.Builder.overrideLoginCredentials((LoginCredentials)LoginCredentials.builder().user(first.getCredentials().identity).privateKey((String)keyPair.get("private")).build()).wrapInInitScript(false).runAsRoot(false));
            ExecResponse hello = (ExecResponse)Iterables.getOnlyElement(responses.values());
            Assert.assertEquals((String)hello.getOutput().trim(), (String)"hello");
        }
        finally {
            noSshContext.close();
            ((ComputeServiceContext)this.view).getComputeService().destroyNodesMatching(NodePredicates.inGroup((String)group));
        }
    }

    @Test
    void testDescribeAWSKeyPairs() {
        for (String region : Region.DEFAULT_REGIONS) {
            TreeSet allResults = Sets.newTreeSet((Iterable)this.client.describeKeyPairsInRegion(region, new String[0]));
            Assert.assertNotNull((Object)allResults);
            if (allResults.size() < 1) continue;
            KeyPair pair = (KeyPair)allResults.last();
            TreeSet result = Sets.newTreeSet((Iterable)this.client.describeKeyPairsInRegion(region, new String[]{pair.getKeyName()}));
            Assert.assertNotNull((Object)result);
            KeyPair compare = (KeyPair)result.last();
            Assert.assertEquals((Object)compare, (Object)pair);
        }
    }

    @Test
    void testCreateKeyPair() {
        String keyName = PREFIX + "1";
        this.cleanupKeyPair(keyName);
        try {
            KeyPair keyPair = this.client.createKeyPairInRegion(null, keyName);
            this.checkKeyPair(keyName, keyPair);
            Assert.assertNotNull((Object)keyPair.getKeyMaterial());
        }
        finally {
            this.cleanupKeyPair(keyName);
        }
    }

    protected void cleanupKeyPair(String keyName) {
        try {
            this.client.deleteKeyPairInRegion(null, keyName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.client.deleteKeyPairInRegion(null, keyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testImportKeyPair() throws FileNotFoundException, IOException {
        String keyName = PREFIX + "2";
        this.cleanupKeyPair(keyName);
        Map myKey = ComputeTestUtils.setupKeyPair();
        try {
            KeyPair keyPair = this.client.importKeyPairInRegion(null, keyName, (String)myKey.get("public"));
            this.checkKeyPair(keyName, keyPair);
            try {
                this.client.importKeyPairInRegion(null, keyName, (String)myKey.get("public"));
                Assert.fail((String)"Expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        finally {
            this.cleanupKeyPair(keyName);
        }
    }

    protected void checkKeyPair(String keyName, KeyPair keyPair) {
        Assert.assertNotNull((Object)keyPair);
        Assert.assertNotNull((Object)keyPair.getSha1OfPrivateKey());
        Assert.assertEquals((String)keyPair.getKeyName(), (String)keyName);
        Set twoResults = this.client.describeKeyPairsInRegion(null, new String[]{keyName});
        Assert.assertNotNull((Object)twoResults);
        Assert.assertEquals((int)twoResults.size(), (int)1);
        KeyPair listPair = (KeyPair)twoResults.iterator().next();
        Assert.assertEquals((String)listPair.getKeyName(), (String)keyPair.getKeyName());
        Assert.assertEquals((String)listPair.getSha1OfPrivateKey(), (String)keyPair.getSha1OfPrivateKey());
    }

    protected AWSRunningInstance getInstance(AWSInstanceApi instanceApi, String id) {
        return (AWSRunningInstance)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)instanceApi.describeInstancesInRegion(null, new String[]{id}))));
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }
}

