/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import java.util.Set;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.features.AWSInstanceApi;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.features.AvailabilityZoneAndRegionApi;
import org.jclouds.ec2.options.DescribeRegionsOptions;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class AWSInstanceApiLiveTest
extends BaseComputeServiceContextLiveTest {
    public static final String PREFIX = System.getProperty("user.name") + "-ec2";
    private AWSInstanceApi client;

    public AWSInstanceApiLiveTest() {
        this.provider = "aws-ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.client = (AWSInstanceApi)((AWSEC2Api)((ComputeServiceContext)this.view).unwrapApi(AWSEC2Api.class)).getInstanceApi().get();
    }

    @Test
    void testDescribeInstances() {
        for (String region : ((AvailabilityZoneAndRegionApi)((AWSEC2Api)((ComputeServiceContext)this.view).unwrapApi(AWSEC2Api.class)).getAvailabilityZoneAndRegionApi().get()).describeRegions(new DescribeRegionsOptions[0]).keySet()) {
            Set allResults = this.client.describeInstancesInRegion(region, new String[0]);
            Assert.assertNotNull((Object)allResults);
            for (Reservation result : allResults) {
                Assert.assertNotNull((Object)result.getReservationId());
            }
        }
    }
}

