/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.easymock.EasyMock;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.compute.functions.PresentSpotRequestsAndInstances;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.features.AWSInstanceApi;
import org.jclouds.aws.ec2.features.SpotInstanceApi;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.domain.Reservation;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class PresentSpotRequestsAndInstancesTest {
    AWSRunningInstance instance1 = (AWSRunningInstance)EasyMock.createMock(AWSRunningInstance.class);
    AWSRunningInstance instance2 = (AWSRunningInstance)EasyMock.createMock(AWSRunningInstance.class);
    SpotInstanceRequest spot1 = (SpotInstanceRequest)EasyMock.createMock(SpotInstanceRequest.class);
    SpotInstanceRequest spot2 = (SpotInstanceRequest)EasyMock.createMock(SpotInstanceRequest.class);

    @Test
    public void testWhenInstancesPresentSingleCall() {
        AWSEC2Api client = (AWSEC2Api)EasyMock.createMock(AWSEC2Api.class);
        AWSInstanceApi instanceApi = (AWSInstanceApi)EasyMock.createMock(AWSInstanceApi.class);
        Function converter = (Function)EasyMock.createMock(Function.class);
        EasyMock.expect((Object)client.getInstanceApi()).andReturn((Object)Optional.of((Object)instanceApi));
        EasyMock.expect((Object)instanceApi.describeInstancesInRegion("us-east-1", new String[]{"i-aaaa", "i-bbbb"})).andReturn(Set.class.cast(ImmutableSet.of((Object)Reservation.builder().region("us-east-1").instances((Set)ImmutableSet.of((Object)this.instance1, (Object)this.instance2)).build())));
        EasyMock.replay((Object[])new Object[]{client, instanceApi, converter});
        PresentSpotRequestsAndInstances fn = new PresentSpotRequestsAndInstances(client, converter);
        Assert.assertEquals((Set)fn.apply((Set)ImmutableSet.of((Object)new RegionAndName("us-east-1", "i-aaaa"), (Object)new RegionAndName("us-east-1", "i-bbbb"))), (Set)ImmutableSet.of((Object)this.instance1, (Object)this.instance2));
        EasyMock.verify((Object[])new Object[]{client, instanceApi, converter});
    }

    @Test
    public void testWhenSpotsPresentSingleCall() {
        Function converter = Functions.forMap((Map)ImmutableMap.of((Object)this.spot1, (Object)this.instance1, (Object)this.spot2, (Object)this.instance2));
        AWSEC2Api client = (AWSEC2Api)EasyMock.createMock(AWSEC2Api.class);
        SpotInstanceApi spotApi = (SpotInstanceApi)EasyMock.createMock(SpotInstanceApi.class);
        EasyMock.expect((Object)client.getSpotInstanceApi()).andReturn((Object)Optional.of((Object)spotApi));
        EasyMock.expect((Object)spotApi.describeSpotInstanceRequestsInRegion("us-east-1", new String[]{"sir-aaaa", "sir-bbbb"})).andReturn((Object)ImmutableSet.of((Object)this.spot1, (Object)this.spot2));
        EasyMock.replay((Object[])new Object[]{client, spotApi});
        PresentSpotRequestsAndInstances fn = new PresentSpotRequestsAndInstances(client, converter);
        Assert.assertEquals((Set)fn.apply((Set)ImmutableSet.of((Object)new RegionAndName("us-east-1", "sir-aaaa"), (Object)new RegionAndName("us-east-1", "sir-bbbb"))), (Set)ImmutableSet.of((Object)this.instance1, (Object)this.instance2));
        EasyMock.verify((Object[])new Object[]{client, spotApi});
    }
}

