/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.extensions;

import com.google.common.collect.Iterables;
import org.jclouds.aws.ec2.internal.BaseAWSEC2ApiMockTest;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AWSEC2SecurityGroupExtensionMockTest", singleThreaded=true)
public class AWSEC2SecurityGroupExtensionApiMockTest
extends BaseAWSEC2ApiMockTest {
    SecurityGroup group = new SecurityGroupBuilder().id("us-east-1/sg-3c6ef654").providerId("sg-3c6ef654").name("jclouds#some-group").ownerId("993194456877").location(new LocationBuilder().scope(LocationScope.REGION).id("us-east-1").description("").build()).build();
    IpPermission permByCidrBlock = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(22).toPort(40).cidrBlock("0.0.0.0/0").build();
    IpPermission permByGroup = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(22).toPort(40).tenantIdGroupNamePair(this.group.getOwnerId(), this.group.getProviderId()).build();

    public void addIpPermissionCidrFromIpPermission() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/authorize_securitygroup_ingress_response.xml");
        this.enqueueXml("us-east-1", "/describe_securitygroups_extension_cidr.xml");
        this.enqueueXml("us-east-1", "/availabilityZones.xml");
        SecurityGroup newGroup = this.extension().addIpPermission(this.permByCidrBlock, this.group);
        Assert.assertEquals((int)1, (int)newGroup.getIpPermissions().size());
        IpPermission newPerm = (IpPermission)Iterables.getOnlyElement((Iterable)newGroup.getIpPermissions());
        Assert.assertEquals((Object)newPerm, (Object)this.permByCidrBlock);
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=AuthorizeSecurityGroupIngress&GroupId=sg-3c6ef654&IpPermissions.0.IpProtocol=tcp&IpPermissions.0.FromPort=22&IpPermissions.0.ToPort=40&IpPermissions.0.IpRanges.0.CidrIp=0.0.0.0/0");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupId.1=sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=DescribeAvailabilityZones");
    }

    public void addIpPermissionCidrFromParams() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/authorize_securitygroup_ingress_response.xml");
        this.enqueueXml("us-east-1", "/describe_securitygroups_extension_cidr.xml");
        this.enqueueXml("us-east-1", "/availabilityZones.xml");
        SecurityGroup newGroup = this.extension().addIpPermission(this.permByCidrBlock.getIpProtocol(), this.permByCidrBlock.getFromPort(), this.permByCidrBlock.getToPort(), this.permByCidrBlock.getTenantIdGroupNamePairs(), (Iterable)this.permByCidrBlock.getCidrBlocks(), (Iterable)this.permByCidrBlock.getGroupIds(), this.group);
        IpPermission newPerm = (IpPermission)Iterables.getOnlyElement((Iterable)newGroup.getIpPermissions());
        Assert.assertEquals((Object)newPerm, (Object)this.permByCidrBlock);
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=AuthorizeSecurityGroupIngress&GroupId=sg-3c6ef654&IpPermissions.0.IpProtocol=tcp&IpPermissions.0.FromPort=22&IpPermissions.0.ToPort=40&IpPermissions.0.IpRanges.0.CidrIp=0.0.0.0/0");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupId.1=sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=DescribeAvailabilityZones");
    }

    public void addIpPermissionGroupFromIpPermission() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/authorize_securitygroup_ingress_response.xml");
        this.enqueueXml("us-east-1", "/describe_securitygroups_extension_group.xml");
        this.enqueueXml("us-east-1", "/availabilityZones.xml");
        SecurityGroup newGroup = this.extension().addIpPermission(this.permByGroup, this.group);
        Assert.assertEquals((int)1, (int)newGroup.getIpPermissions().size());
        IpPermission newPerm = (IpPermission)Iterables.getOnlyElement((Iterable)newGroup.getIpPermissions());
        Assert.assertEquals((Object)newPerm, (Object)this.permByGroup);
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=AuthorizeSecurityGroupIngress&GroupId=sg-3c6ef654&IpPermissions.0.IpProtocol=tcp&IpPermissions.0.FromPort=22&IpPermissions.0.ToPort=40&IpPermissions.0.Groups.0.UserId=993194456877&IpPermissions.0.Groups.0.GroupId=sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupId.1=sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=DescribeAvailabilityZones");
    }

    public void addIpPermissionGroupFromParams() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/authorize_securitygroup_ingress_response.xml");
        this.enqueueXml("us-east-1", "/describe_securitygroups_extension_group.xml");
        this.enqueueXml("us-east-1", "/availabilityZones.xml");
        SecurityGroup newGroup = this.extension().addIpPermission(this.permByGroup.getIpProtocol(), this.permByGroup.getFromPort(), this.permByGroup.getToPort(), this.permByGroup.getTenantIdGroupNamePairs(), (Iterable)this.permByGroup.getCidrBlocks(), (Iterable)this.permByGroup.getGroupIds(), this.group);
        IpPermission newPerm = (IpPermission)Iterables.getOnlyElement((Iterable)newGroup.getIpPermissions());
        Assert.assertEquals((Object)newPerm, (Object)this.permByGroup);
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=AuthorizeSecurityGroupIngress&GroupId=sg-3c6ef654&IpPermissions.0.IpProtocol=tcp&IpPermissions.0.FromPort=22&IpPermissions.0.ToPort=40&IpPermissions.0.Groups.0.UserId=993194456877&IpPermissions.0.Groups.0.GroupId=sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupId.1=sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=DescribeAvailabilityZones");
    }

    public void createSecurityGroup() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/created_securitygroup.xml");
        this.enqueueXml("us-east-1", "/describe_securitygroups_extension_single.xml");
        this.enqueueXml("us-east-1", "/describe_securitygroups_extension_single.xml");
        this.enqueueXml("us-east-1", "/describe_securitygroups_extension_single.xml");
        this.enqueueXml("us-east-1", "/availabilityZones.xml");
        SecurityGroup newGroup = this.extension().createSecurityGroup(this.group.getName().replace("jclouds#", ""), this.group.getLocation());
        Assert.assertEquals((String)newGroup.getId(), (String)this.group.getId());
        Assert.assertEquals((String)newGroup.getProviderId(), (String)this.group.getProviderId());
        Assert.assertEquals((String)newGroup.getName(), (String)this.group.getName());
        Assert.assertEquals((String)newGroup.getLocation().getId(), (String)this.group.getLocation().getId());
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=CreateSecurityGroup&GroupName=jclouds%23some-group&GroupDescription=jclouds%23some-group");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23some-group");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23some-group");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupId.1=sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=DescribeAvailabilityZones");
    }

    private SecurityGroupExtension extension() {
        return (SecurityGroupExtension)this.computeService().getSecurityGroupExtension().get();
    }
}

