/*
 * Decompiled with CFR 0.152.
 */
package com.amuyu.logger;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class FileLog {
    private BlockingQueue<String> logQueue = new LinkedBlockingQueue<String>();
    private Looper looper;
    private String logFile;

    public FileLog(String logFile) {
        this.logFile = logFile;
        if (logFile != null) {
            File file = new File(logFile);
            try {
                if (!file.exists()) {
                    this.logQueue.put("DATE TIME LEVEL:THREAD/TAG: [METHOD(LINE)] MESSAGE\n");
                    this.logQueue.put("---- ---- ----------------- -------------- -------\n");
                } else {
                    this.logQueue.put("\nAPP RESTART ---------------------------------------------\n\n");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileLog(int level, String tag, String message) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);
        StringBuilder log = new StringBuilder().append(dateFormat.format(new Date())).append(" ").append(this.getLogLevelName(level)).append(":").append(Thread.currentThread().getId()).append("/").append(tag).append(": ").append(message);
        try {
            this.logQueue.put(log.append("\n").toString());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        FileLog fileLog = this;
        synchronized (fileLog) {
            if (this.looper == null || !this.looper.isAlive()) {
                this.looper = new Looper();
                this.looper.start();
            }
        }
    }

    private String getLogLevelName(int level) {
        switch (level) {
            case 2: {
                return "V";
            }
            case 3: {
                return "D";
            }
            case 6: {
                return "E";
            }
            case 4: {
                return "I";
            }
            case 5: {
                return "W";
            }
            case 7: {
                return "A";
            }
        }
        return "U";
    }

    private class Looper
    extends Thread {
        private Looper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OutputStream os = null;
            try {
                os = new FileOutputStream(FileLog.this.logFile, true);
                while (FileLog.this.logFile != null) {
                    String log = null;
                    try {
                        log = (String)FileLog.this.logQueue.poll(1L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (log == null) {
                        break;
                    }
                    os.write(log.getBytes());
                    os.flush();
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

