/*
 * Decompiled with CFR 0.152.
 */
package com.amuyu.logger;

import android.content.Context;
import com.amuyu.logger.AbstractLogPrinter;
import java.util.regex.Matcher;

public class DefaultLogPrinter
extends AbstractLogPrinter {
    public DefaultLogPrinter(Context context) {
        super(context);
    }

    @Override
    protected String createStackElementTag(StackTraceElement element) {
        String className = element.getClassName();
        Matcher m = ANONYMOUS_CLASS.matcher(className);
        if (m.find()) {
            className = m.replaceAll("");
        }
        return (className = className.substring(className.lastIndexOf(46) + 1)).length() > 23 ? className.substring(0, 23) : className;
    }

    @Override
    protected String createStackElementMessage(StackTraceElement element) {
        if (element != null) {
            String threadName = Thread.currentThread().getName();
            String methodName = element.getMethodName();
            int lineNumber = element.getLineNumber();
            return threadName + "#" + methodName + '(' + lineNumber + ") ";
        }
        return "";
    }

    @Override
    protected void logPrint(int priority, String tag, String message) {
        this.androidLog(priority, tag, message);
        this.fileLog(priority, tag, message);
    }
}

