/*
 * Decompiled with CFR 0.152.
 */
package com.amuyu.logger;

import com.amuyu.logger.AbstractLogPrinter;
import com.amuyu.logger.LogInterface;
import com.amuyu.logger.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LogAdapter
implements LogInterface {
    private static final int JSON_INDENT = 2;
    private static final AbstractLogPrinter[] LOG_PRINTERS_EMPTY = new AbstractLogPrinter[0];
    private static final List<AbstractLogPrinter> LOG_PRINTERS = new ArrayList<AbstractLogPrinter>();
    static volatile AbstractLogPrinter[] logPrintersAsArray = LOG_PRINTERS_EMPTY;

    public synchronized void add(AbstractLogPrinter logPrinter) {
        LOG_PRINTERS.add(logPrinter);
        logPrintersAsArray = LOG_PRINTERS.toArray(new AbstractLogPrinter[LOG_PRINTERS.size()]);
    }

    public synchronized void remove(AbstractLogPrinter logPrinter) {
        if (!LOG_PRINTERS.remove(logPrinter)) {
            throw new IllegalArgumentException("Cannot remove logPrinter");
        }
        logPrintersAsArray = LOG_PRINTERS.toArray(new AbstractLogPrinter[LOG_PRINTERS.size()]);
    }

    public synchronized void clear() {
        LOG_PRINTERS.clear();
        logPrintersAsArray = LOG_PRINTERS_EMPTY;
    }

    public synchronized List<AbstractLogPrinter> logPrinters() {
        return Collections.unmodifiableList(new ArrayList<AbstractLogPrinter>(LOG_PRINTERS));
    }

    public int getCount() {
        return LOG_PRINTERS.size();
    }

    @Override
    public void v(String msg, Object ... args) {
        AbstractLogPrinter[] logPrinters = logPrintersAsArray;
        int count = logPrinters.length;
        for (int i = 0; i < count; ++i) {
            logPrinters[i].log(2, msg, null, args);
        }
    }

    @Override
    public void v(String msg, Throwable tr, Object ... args) {
        AbstractLogPrinter[] logPrinters = logPrintersAsArray;
        int count = logPrinters.length;
        for (int i = 0; i < count; ++i) {
            logPrinters[i].log(2, msg, tr, args);
        }
    }

    @Override
    public void d(String msg, Object ... args) {
        AbstractLogPrinter[] logPrinters = logPrintersAsArray;
        int count = logPrinters.length;
        for (int i = 0; i < count; ++i) {
            logPrinters[i].log(3, msg, null, args);
        }
    }

    @Override
    public void d(String msg, Throwable tr, Object ... args) {
        AbstractLogPrinter[] logPrinters = logPrintersAsArray;
        int count = logPrinters.length;
        for (int i = 0; i < count; ++i) {
            logPrinters[i].log(3, msg, tr, args);
        }
    }

    @Override
    public void d(Object object) {
        AbstractLogPrinter[] logPrinters = logPrintersAsArray;
        int count = logPrinters.length;
        for (int i = 0; i < count; ++i) {
            logPrinters[i].log(3, Utils.toString(object), null, new Object[0]);
        }
    }

    @Override
    public void json(String name, String json) {
        String message = "Empty/Null json content";
        try {
            if (!Utils.isEmpty(json)) {
                if ((json = json.trim()).startsWith("{")) {
                    JSONObject jsonObject = new JSONObject(json);
                    message = jsonObject.toString(2);
                }
                if (json.startsWith("[")) {
                    JSONArray jsonArray = new JSONArray(json);
                    message = jsonArray.toString(2);
                }
            }
        }
        catch (JSONException e) {
            message = "Invalid Json";
        }
        message = name == null ? message : name + ':' + message;
        AbstractLogPrinter[] logPrinters = logPrintersAsArray;
        int count = logPrinters.length;
        for (int i = 0; i < count; ++i) {
            logPrinters[i].log(3, message, null, new Object[0]);
        }
    }

    @Override
    public void i(String msg, Object ... args) {
        AbstractLogPrinter[] logPrinters = logPrintersAsArray;
        int count = logPrinters.length;
        for (int i = 0; i < count; ++i) {
            logPrinters[i].log(4, msg, null, args);
        }
    }

    @Override
    public void i(String msg, Throwable tr, Object ... args) {
        AbstractLogPrinter[] logPrinters = logPrintersAsArray;
        int count = logPrinters.length;
        for (int i = 0; i < count; ++i) {
            logPrinters[i].log(4, msg, tr, args);
        }
    }

    @Override
    public void w(String msg, Object ... args) {
        AbstractLogPrinter[] logPrinters = logPrintersAsArray;
        int count = logPrinters.length;
        for (int i = 0; i < count; ++i) {
            logPrinters[i].log(5, msg, null, args);
        }
    }

    @Override
    public void w(String msg, Throwable tr, Object ... args) {
        AbstractLogPrinter[] logPrinters = logPrintersAsArray;
        int count = logPrinters.length;
        for (int i = 0; i < count; ++i) {
            logPrinters[i].log(5, msg, tr, args);
        }
    }

    @Override
    public void w(Throwable tr, Object ... args) {
        AbstractLogPrinter[] logPrinters = logPrintersAsArray;
        int count = logPrinters.length;
        for (int i = 0; i < count; ++i) {
            logPrinters[i].log(5, null, tr, args);
        }
    }

    @Override
    public void e(String msg, Object ... args) {
        AbstractLogPrinter[] logPrinters = logPrintersAsArray;
        int count = logPrinters.length;
        for (int i = 0; i < count; ++i) {
            logPrinters[i].log(6, msg, null, args);
        }
    }

    @Override
    public void e(String msg, Throwable tr, Object ... args) {
        AbstractLogPrinter[] logPrinters = logPrintersAsArray;
        int count = logPrinters.length;
        for (int i = 0; i < count; ++i) {
            logPrinters[i].log(6, msg, tr, args);
        }
    }

    @Override
    public void e(Throwable tr, Object ... args) {
        AbstractLogPrinter[] logPrinters = logPrintersAsArray;
        int count = logPrinters.length;
        for (int i = 0; i < count; ++i) {
            logPrinters[i].log(6, null, tr, args);
        }
    }
}

