/*
 * Decompiled with CFR 0.152.
 */
package com.amuyu.logger;

import android.content.Context;
import android.util.Log;
import com.amuyu.logger.FileLog;
import com.amuyu.logger.Utils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

public abstract class AbstractLogPrinter {
    protected static final int MAX_LOG_LENGTH = 4000;
    protected static final int MAX_TAG_LENGTH = 23;
    protected static final int MAX_TAG_THREAD_LEGTH = 6;
    protected static final int MAX_TAG_CLASS_LENGTH = 17;
    protected static final int CALL_STACK_INDEX = 4;
    protected static final Pattern ANONYMOUS_CLASS = Pattern.compile("(\\$\\d+)+$");
    private Context context;
    private boolean writeLogFile;
    private String logFileName;
    private FileLog fileLog;
    final ThreadLocal<String> explicitTag = new ThreadLocal();

    public AbstractLogPrinter(Context context) {
        this.context = context;
    }

    public AbstractLogPrinter writeFileLog(boolean writeFileLog) {
        this.writeLogFile = writeFileLog;
        return this;
    }

    public AbstractLogPrinter logFileName(String logFileName) {
        this.logFileName = logFileName;
        return this;
    }

    String getTag(StackTraceElement element) {
        String tag = this.explicitTag.get();
        if (tag != null) {
            return tag;
        }
        tag = element != null ? this.createStackElementTag(element) : "unknown";
        return tag;
    }

    protected void log(int priority, String message, Throwable t, Object ... args) {
        StackTraceElement element = this.getStackTraceElement();
        String tag = this.getTag(element);
        if (message != null && message.length() == 0) {
            message = "";
        }
        if (message == null) {
            if (t == null) {
                return;
            }
            message = Utils.getStackTraceString(t);
        } else {
            if (args.length > 0) {
                message = this.formatMessage(message, args);
            }
            if (t != null) {
                message = message + "\n" + Utils.getStackTraceString(t);
            }
        }
        message = this.createStackElementMessage(element) + message;
        this.logPrint(priority, tag, message);
    }

    abstract void logPrint(int var1, String var2, String var3);

    protected void fileLog(int priority, String tag, String message) {
        if (this.fileLog == null) {
            this.createFileLog();
        }
        this.fileLog.fileLog(priority, tag, message);
    }

    protected void androidLog(int priority, String tag, String message) {
        if (message.length() < 4000) {
            Log.println((int)priority, (String)tag, (String)message);
            return;
        }
        int length = message.length();
        for (int i = 0; i < length; ++i) {
            int end;
            int newline = message.indexOf(10, i);
            newline = newline != -1 ? newline : length;
            do {
                end = Math.min(newline, i + 4000);
                String part = message.substring(i, end);
                if (priority == 7) {
                    Log.wtf((String)tag, (String)part);
                    continue;
                }
                Log.println((int)priority, (String)tag, (String)part);
            } while ((i = end) < newline);
        }
    }

    private String formatMessage(String message, Object[] args) {
        return String.format(message, args);
    }

    private StackTraceElement getStackTraceElement() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (stackTrace.length <= 4) {
            return null;
        }
        return stackTrace[4];
    }

    private void createFileLog() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd", Locale.US);
        Object encryptKey = null;
        String ext = this.logFileName != null ? '-' + this.logFileName + ".log" : ".log";
        String cachePath = this.context.getExternalCacheDir().getPath();
        File logFile = new File(cachePath, dateFormat.format(new Date()) + ext);
        this.fileLog = new FileLog(logFile.getPath());
    }

    protected abstract String createStackElementTag(StackTraceElement var1);

    protected abstract String createStackElementMessage(StackTraceElement var1);
}

