/*
 * Decompiled with CFR 0.152.
 */
package com.amuyu.logger;

import android.content.Context;
import com.amuyu.logger.AbstractLogPrinter;
import java.util.regex.Matcher;

public class DefaultLogPrinter
extends AbstractLogPrinter {
    public DefaultLogPrinter(Context context) {
        super(context);
    }

    @Override
    protected String createStackElementTag(StackTraceElement element) {
        String className = element.getClassName();
        Matcher m = ANONYMOUS_CLASS.matcher(className);
        if (m.find()) {
            className = m.replaceAll("");
        }
        className = className.substring(className.lastIndexOf(46) + 1);
        String threadName = Thread.currentThread().getName();
        String tag = className + '#' + threadName;
        return tag.length() > 23 ? tag.substring(0, 23) : tag;
    }

    @Override
    protected String createStackElementMessage(StackTraceElement element) {
        if (element != null) {
            String methodName = element.getMethodName();
            int lineNumber = element.getLineNumber();
            return methodName + '(' + lineNumber + ") ";
        }
        return "";
    }

    @Override
    protected void logPrint(int priority, String tag, String message) {
        this.androidLog(priority, tag, message);
        this.fileLog(priority, tag, message);
    }
}

