/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude;

import com.amplitude.AmplitudeCallbacks;
import com.amplitude.AmplitudeLog;
import com.amplitude.Constants;
import com.amplitude.Event;
import com.amplitude.EventsRetryResult;
import com.amplitude.HttpCall;
import com.amplitude.Response;
import com.amplitude.Status;
import com.amplitude.exception.AmplitudeInvalidAPIKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.json.JSONException;
import org.json.JSONObject;

class HttpTransport {
    private Object throttleLock = new Object();
    private Map<String, Integer> throttledUserId = new HashMap<String, Integer>();
    private Map<String, Integer> throttledDeviceId = new HashMap<String, Integer>();
    private boolean recordThrottledId = false;
    private Map<String, Map<String, List<Event>>> idToBuffer = new HashMap<String, Map<String, List<Event>>>();
    private int eventsInRetry = 0;
    private Object bufferLock = new Object();
    private Object counterLock = new Object();
    private ExecutorService retryThreadPool = Executors.newFixedThreadPool(10);
    private HttpCall httpCall;
    private AmplitudeLog logger;
    private AmplitudeCallbacks callbacks;

    HttpTransport(HttpCall httpCall, AmplitudeCallbacks callbacks, AmplitudeLog logger) {
        this.httpCall = httpCall;
        this.callbacks = callbacks;
        this.logger = logger;
    }

    public void sendEventsWithRetry(List<Event> events) {
        ((CompletableFuture)this.sendEvents(events).thenAcceptAsync(response -> {
            Status status = response.status;
            if (this.shouldRetryForStatus(status)) {
                this.retryEvents(events, (Response)response);
            } else if (status == Status.SUCCESS) {
                this.triggerEventCallbacks(events, response.code, "Event sent success.");
            } else if (status == Status.FAILED) {
                this.triggerEventCallbacks(events, response.code, "Event sent Failed.");
            } else {
                this.triggerEventCallbacks(events, response.code, "Unknown response status.");
            }
        })).exceptionally(exception -> {
            this.logger.error("Invalid API Key", exception.getMessage());
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryEvents(List<Event> events, Response response) {
        int bufferSize;
        Object object = this.counterLock;
        synchronized (object) {
            bufferSize = this.eventsInRetry;
        }
        if (bufferSize < 16000) {
            this.onEventsError(events, response);
        } else {
            String message = "Retry buffer is full(" + bufferSize + "), " + events.size() + " events dropped.";
            this.logger.warn("DROP EVENTS", message);
            this.triggerEventCallbacks(events, response.code, message);
        }
    }

    public void setHttpCall(HttpCall httpCall) {
        this.httpCall = httpCall;
    }

    public void setCallbacks(AmplitudeCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    private CompletableFuture<Response> sendEvents(List<Event> events) {
        return CompletableFuture.supplyAsync(() -> {
            Response response = null;
            try {
                response = this.httpCall.makeRequest(events);
                this.logger.debug("SEND", events, response);
            }
            catch (AmplitudeInvalidAPIKeyException e) {
                throw new CompletionException(e);
            }
            return response;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEventsError(List<Event> events, Response response) {
        HashSet<String> users;
        List<Event> eventsToRetry = this.getEventListToRetry(events, response);
        if (eventsToRetry.isEmpty()) {
            return;
        }
        for (Event event : eventsToRetry) {
            String deviceId;
            String userId = event.userId != null ? event.userId : "";
            String string = deviceId = event.deviceId != null ? event.deviceId : "";
            if (userId.length() <= 0 && deviceId.length() <= 0) continue;
            this.addEventToBuffer(userId, deviceId, event);
        }
        Iterator iterator = this.bufferLock;
        synchronized (iterator) {
            users = new HashSet<String>(this.idToBuffer.keySet());
        }
        for (String userId : users) {
            HashSet<String> devices;
            Iterator iterator2 = this.bufferLock;
            synchronized (iterator2) {
                devices = new HashSet<String>(this.idToBuffer.get(userId).keySet());
            }
            for (String deviceId : devices) {
                try {
                    this.retryThreadPool.execute(new RetryEventsOnLoop(userId, deviceId));
                }
                catch (RejectedExecutionException e) {
                    this.logger.warn("Failed init retry thread", e.getMessage());
                }
            }
        }
    }

    private EventsRetryResult retryEventsOnce(String userId, String deviceId, List<Event> events) throws AmplitudeInvalidAPIKeyException {
        Response response = this.httpCall.makeRequest(events);
        this.logger.debug("RETRY", events, response);
        boolean shouldRetry = true;
        boolean shouldReduceEventCount = false;
        int[] eventIndicesToRemove = new int[]{};
        switch (response.status) {
            case SUCCESS: {
                shouldRetry = false;
                this.triggerEventCallbacks(events, response.code, "Events sent success.");
                break;
            }
            case RATELIMIT: {
                if (response.isUserOrDeviceExceedQuote(userId, deviceId)) {
                    shouldRetry = false;
                    this.triggerEventCallbacks(events, response.code, response.error);
                }
                shouldReduceEventCount = true;
                break;
            }
            case PAYLOAD_TOO_LARGE: {
                shouldRetry = true;
                shouldReduceEventCount = true;
                break;
            }
            case INVALID: {
                if (events.size() == 1) {
                    shouldRetry = false;
                    this.triggerEventCallbacks(events, response.code, response.error);
                    break;
                }
                eventIndicesToRemove = response.collectInvalidEventIndices();
                break;
            }
            case UNKNOWN: {
                shouldRetry = false;
                this.triggerEventCallbacks(events, response.code, "Unknown response status.");
                break;
            }
            case FAILED: {
                shouldRetry = false;
                this.triggerEventCallbacks(events, response.code, "Event sent Failed.");
                break;
            }
        }
        return new EventsRetryResult(shouldRetry, shouldReduceEventCount, eventIndicesToRemove, response.code, response.error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> getEventListToRetry(List<Event> events, Response response) {
        ArrayList<Event> eventsToRetry = new ArrayList();
        List<Event> eventsToDrop = new ArrayList<Event>();
        if (response.status == Status.INVALID && response.invalidRequestBody != null) {
            if (response.invalidRequestBody.has("missingField") && response.invalidRequestBody.getString("missingField").length() > 0 || events.size() == 1) {
                eventsToDrop = events;
            } else {
                int[] invalidEventIndices = response.collectInvalidEventIndices();
                for (int i = 0; i < events.size(); ++i) {
                    if (Arrays.binarySearch(invalidEventIndices, i) < 0) {
                        eventsToRetry.add(events.get(i));
                        continue;
                    }
                    eventsToDrop.add(events.get(i));
                }
            }
        } else if (response.status == Status.RATELIMIT && response.rateLimitBody != null) {
            for (Event event : events) {
                if (!response.isUserOrDeviceExceedQuote(event.userId, event.deviceId)) {
                    eventsToRetry.add(event);
                    if (!this.recordThrottledId) continue;
                    try {
                        JSONObject throttledUser = response.rateLimitBody.getJSONObject("throttledUsers");
                        JSONObject throttledDevice = response.rateLimitBody.getJSONObject("throttledDevices");
                        Object object = this.throttleLock;
                        synchronized (object) {
                            if (throttledUser.has(event.userId)) {
                                this.throttledUserId.put(event.userId, throttledUser.getInt(event.userId));
                            }
                            if (throttledDevice.has(event.deviceId)) {
                                this.throttledDeviceId.put(event.deviceId, throttledDevice.getInt(event.deviceId));
                            }
                            continue;
                        }
                    }
                    catch (JSONException e) {
                        this.logger.debug("THROTTLED", "Error get throttled userId or deviceId");
                        continue;
                    }
                }
                eventsToDrop.add(event);
            }
        } else {
            eventsToRetry = events;
        }
        this.triggerEventCallbacks(eventsToDrop, response.code, response.error);
        return eventsToRetry;
    }

    protected boolean shouldRetryForStatus(Status status) {
        return status == Status.INVALID || status == Status.PAYLOAD_TOO_LARGE || status == Status.RATELIMIT || status == Status.TIMEOUT;
    }

    private void triggerEventCallbacks(List<Event> events, int status, String message) {
        if (events == null || events.isEmpty()) {
            return;
        }
        for (Event event : events) {
            if (this.callbacks != null) {
                this.callbacks.onLogEventServerResponse(event, status, message);
            }
            if (event.callback == null) continue;
            event.callback.onLogEventServerResponse(event, status, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEventToBuffer(String userId, String deviceId, Event event) {
        Object object = this.bufferLock;
        synchronized (object) {
            if (!this.idToBuffer.containsKey(userId)) {
                this.idToBuffer.put(userId, new HashMap());
            }
            if (!this.idToBuffer.get(userId).containsKey(deviceId)) {
                this.idToBuffer.get(userId).put(deviceId, new ArrayList());
            }
            this.idToBuffer.get(userId).get(deviceId).add(event);
        }
        object = this.counterLock;
        synchronized (object) {
            ++this.eventsInRetry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> getEventsFromBuffer(String userId, String deviceId) {
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.idToBuffer.containsKey(userId) && this.idToBuffer.get(userId).containsKey(deviceId)) {
                List<Event> events = this.idToBuffer.get(userId).remove(deviceId);
                if (this.idToBuffer.get(userId).isEmpty()) {
                    this.idToBuffer.remove(userId);
                }
                return events;
            }
        }
        return null;
    }

    public boolean shouldWait(Event event) {
        if (this.recordThrottledId && (this.throttledUserId.containsKey(event.userId) || this.throttledDeviceId.containsKey(event.deviceId))) {
            return true;
        }
        return this.eventsInRetry >= 16000;
    }

    public void setRecordThrottledId(boolean record) {
        this.recordThrottledId = record;
    }

    class RetryEventsOnLoop
    implements Runnable {
        private String userId;
        private String deviceId;

        RetryEventsOnLoop(String userId, String deviceId) {
            this.deviceId = deviceId;
            this.userId = userId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int eventCount;
            List eventsBuffer = HttpTransport.this.getEventsFromBuffer(this.userId, this.deviceId);
            if (eventsBuffer == null || eventsBuffer.size() == 0) {
                return;
            }
            Object object = HttpTransport.this.counterLock;
            synchronized (object) {
                HttpTransport.this.eventsInRetry = HttpTransport.this.eventsInRetry - eventsBuffer.size();
            }
            int retryTimes = Constants.RETRY_TIMEOUTS.length;
            for (int numRetries = 0; numRetries < retryTimes && (eventCount = eventsBuffer.size()) > 0; ++numRetries) {
                long sleepDuration = Constants.RETRY_TIMEOUTS[numRetries];
                try {
                    List eventsToDrop;
                    Thread.sleep(sleepDuration);
                    boolean isLastTry = numRetries == retryTimes - 1;
                    EventsRetryResult retryResult = HttpTransport.this.retryEventsOnce(this.userId, this.deviceId, eventsBuffer);
                    boolean shouldRetry = retryResult.shouldRetry;
                    if (!shouldRetry) break;
                    if (isLastTry) {
                        HttpTransport.this.triggerEventCallbacks(eventsBuffer, retryResult.statusCode, "Event retries exhausted.");
                        break;
                    }
                    boolean shouldReduceEventCount = retryResult.shouldReduceEventCount;
                    int[] eventIndicesToRemove = retryResult.eventIndicesToRemove;
                    if (eventIndicesToRemove.length > 0) {
                        eventsToDrop = new ArrayList();
                        for (int i = eventIndicesToRemove.length - 1; i >= 0; --i) {
                            int index = eventIndicesToRemove[i];
                            if (index >= eventCount) continue;
                            eventsToDrop.add(eventsBuffer.remove(index));
                        }
                        HttpTransport.this.triggerEventCallbacks(eventsToDrop, retryResult.statusCode, "Invalid events.");
                        continue;
                    }
                    if (!shouldReduceEventCount) continue;
                    eventsToDrop = eventsBuffer.subList(eventCount / 2, eventCount);
                    HttpTransport.this.triggerEventCallbacks(eventsToDrop, retryResult.statusCode, "Event dropped for retry");
                    eventsBuffer = eventsBuffer.subList(0, eventCount / 2);
                    continue;
                }
                catch (AmplitudeInvalidAPIKeyException | InterruptedException e) {
                    HttpTransport.this.logger.debug("RETRY", "Retry thread got interrupted");
                    Thread.currentThread().interrupt();
                }
            }
            if (HttpTransport.this.recordThrottledId) {
                Object object2 = HttpTransport.this.throttleLock;
                synchronized (object2) {
                    HttpTransport.this.throttledUserId.remove(this.userId);
                    HttpTransport.this.throttledDeviceId.remove(this.deviceId);
                }
            }
        }
    }
}

