/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude.api;

import com.amplitude.api.AmplitudeLog;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class TrackingOptions {
    private static final String TAG = TrackingOptions.class.getName();
    private static String[] SERVER_SIDE_PROPERTIES = new String[]{"city", "country", "dma", "ip_address", "lat_lng", "region"};
    private static String[] COPPA_CONTROL_PROPERTIES = new String[]{"adid", "city", "ip_address", "lat_lng"};
    Set<String> disabledFields = new HashSet<String>();

    public TrackingOptions disableAdid() {
        this.disableTrackingField("adid");
        return this;
    }

    boolean shouldTrackAdid() {
        return this.shouldTrackField("adid");
    }

    public TrackingOptions disableAppSetId() {
        this.disableTrackingField("app_set_id");
        return this;
    }

    boolean shouldTrackAppSetId() {
        return this.shouldTrackField("app_set_id");
    }

    public TrackingOptions disableCarrier() {
        this.disableTrackingField("carrier");
        return this;
    }

    boolean shouldTrackCarrier() {
        return this.shouldTrackField("carrier");
    }

    public TrackingOptions disableCity() {
        this.disableTrackingField("city");
        return this;
    }

    boolean shouldTrackCity() {
        return this.shouldTrackField("city");
    }

    public TrackingOptions disableCountry() {
        this.disableTrackingField("country");
        return this;
    }

    boolean shouldTrackCountry() {
        return this.shouldTrackField("country");
    }

    public TrackingOptions disableDeviceBrand() {
        this.disableTrackingField("device_brand");
        return this;
    }

    boolean shouldTrackDeviceBrand() {
        return this.shouldTrackField("device_brand");
    }

    public TrackingOptions disableDeviceManufacturer() {
        this.disableTrackingField("device_manufacturer");
        return this;
    }

    boolean shouldTrackDeviceManufacturer() {
        return this.shouldTrackField("device_manufacturer");
    }

    public TrackingOptions disableDeviceModel() {
        this.disableTrackingField("device_model");
        return this;
    }

    boolean shouldTrackDeviceModel() {
        return this.shouldTrackField("device_model");
    }

    public TrackingOptions disableDma() {
        this.disableTrackingField("dma");
        return this;
    }

    boolean shouldTrackDma() {
        return this.shouldTrackField("dma");
    }

    public TrackingOptions disableIpAddress() {
        this.disableTrackingField("ip_address");
        return this;
    }

    boolean shouldTrackIpAddress() {
        return this.shouldTrackField("ip_address");
    }

    public TrackingOptions disableLanguage() {
        this.disableTrackingField("language");
        return this;
    }

    boolean shouldTrackLanguage() {
        return this.shouldTrackField("language");
    }

    public TrackingOptions disableLatLng() {
        this.disableTrackingField("lat_lng");
        return this;
    }

    boolean shouldTrackLatLng() {
        return this.shouldTrackField("lat_lng");
    }

    public TrackingOptions disableOsName() {
        this.disableTrackingField("os_name");
        return this;
    }

    boolean shouldTrackOsName() {
        return this.shouldTrackField("os_name");
    }

    public TrackingOptions disableOsVersion() {
        this.disableTrackingField("os_version");
        return this;
    }

    boolean shouldTrackOsVersion() {
        return this.shouldTrackField("os_version");
    }

    public TrackingOptions disableApiLevel() {
        this.disableTrackingField("api_level");
        return this;
    }

    boolean shouldTrackApiLevel() {
        return this.shouldTrackField("api_level");
    }

    public TrackingOptions disablePlatform() {
        this.disableTrackingField("platform");
        return this;
    }

    boolean shouldTrackPlatform() {
        return this.shouldTrackField("platform");
    }

    public TrackingOptions disableRegion() {
        this.disableTrackingField("region");
        return this;
    }

    boolean shouldTrackRegion() {
        return this.shouldTrackField("region");
    }

    public TrackingOptions disableVersionName() {
        this.disableTrackingField("version_name");
        return this;
    }

    boolean shouldTrackVersionName() {
        return this.shouldTrackField("version_name");
    }

    private void disableTrackingField(String field) {
        this.disabledFields.add(field);
    }

    protected JSONObject getApiPropertiesTrackingOptions() {
        JSONObject apiPropertiesTrackingOptions = new JSONObject();
        if (this.disabledFields.isEmpty()) {
            return apiPropertiesTrackingOptions;
        }
        for (String key : SERVER_SIDE_PROPERTIES) {
            if (!this.disabledFields.contains(key)) continue;
            try {
                apiPropertiesTrackingOptions.put(key, false);
            }
            catch (JSONException e) {
                AmplitudeLog.getLogger().e(TAG, e.toString());
            }
        }
        return apiPropertiesTrackingOptions;
    }

    private boolean shouldTrackField(String field) {
        return !this.disabledFields.contains(field);
    }

    TrackingOptions mergeIn(TrackingOptions other) {
        for (String key : other.disabledFields) {
            this.disableTrackingField(key);
        }
        return this;
    }

    static TrackingOptions copyOf(TrackingOptions other) {
        TrackingOptions trackingOptions = new TrackingOptions();
        for (String key : other.disabledFields) {
            trackingOptions.disableTrackingField(key);
        }
        return trackingOptions;
    }

    static TrackingOptions forCoppaControl() {
        TrackingOptions trackingOptions = new TrackingOptions();
        for (String key : COPPA_CONTROL_PROPERTIES) {
            trackingOptions.disableTrackingField(key);
        }
        return trackingOptions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        TrackingOptions options = (TrackingOptions)other;
        return options.disabledFields.equals(this.disabledFields);
    }
}

