/*
 * Decompiled with CFR 0.152.
 */
package com.amlzq.android.net;

import android.accounts.NetworkErrorException;
import android.os.Handler;
import android.os.Looper;
import com.amlzq.android.net.ResultCallback;
import com.amlzq.android.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class HttpHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void post(String url, String content, ResultCallback callback) {
        block7: {
            HttpURLConnection connection = null;
            try {
                URL parsedUrl = new URL(url);
                connection = (HttpURLConnection)parsedUrl.openConnection();
                connection.setRequestMethod("POST");
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(5000);
                connection.setDoOutput(true);
                String data = content;
                OutputStream out = connection.getOutputStream();
                out.write(data.getBytes());
                out.flush();
                out.close();
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    InputStream is = connection.getInputStream();
                    String response = HttpHelper.getStringFromInputStream(is);
                    HttpHelper.successCallback(url, response, callback);
                    break block7;
                }
                throw new NetworkErrorException("response status is " + responseCode);
            }
            catch (Exception e) {
                e.printStackTrace();
                HttpHelper.failureCallback(url, e, callback);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void get(String url, ResultCallback callback) {
        block7: {
            HttpURLConnection connection = null;
            try {
                URL parsedUrl = new URL(url);
                connection = (HttpURLConnection)parsedUrl.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String response = HttpHelper.getStringFromInputStream(connection.getInputStream());
                    HttpHelper.successCallback(url, response, callback);
                    break block7;
                }
                throw new NetworkErrorException("response status is " + responseCode);
            }
            catch (Exception e) {
                e.printStackTrace();
                HttpHelper.failureCallback(url, e, callback);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void get(String url, Map<String, String> params, ResultCallback callback) {
        block9: {
            HttpURLConnection connection = null;
            try {
                StringBuilder tempParams = new StringBuilder();
                int pos = 0;
                for (String key : params.keySet()) {
                    if (pos > 0) {
                        tempParams.append("&");
                    }
                    tempParams.append(String.format("%s=%s", key, URLEncoder.encode(params.get(key), "UTF-8")));
                    ++pos;
                }
                String requestUrl = url + "?" + tempParams.toString();
                Logger.d((Object)("request url: " + requestUrl));
                URL parsedUrl = new URL(requestUrl);
                connection = (HttpURLConnection)parsedUrl.openConnection();
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(5000);
                connection.setUseCaches(true);
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.addRequestProperty("Connection", "Keep-Alive");
                connection.connect();
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String response = HttpHelper.streamToString(connection.getInputStream());
                    HttpHelper.successCallback(url, response, callback);
                    break block9;
                }
                throw new NetworkErrorException("response status is " + responseCode);
            }
            catch (Exception e) {
                e.printStackTrace();
                HttpHelper.failureCallback(url, e, callback);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }

    private static String getStringFromInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = -1;
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        is.close();
        String state = os.toString();
        os.close();
        return state;
    }

    public static String streamToString(InputStream is) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = is.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            baos.close();
            is.close();
            byte[] byteArray = baos.toByteArray();
            return new String(byteArray);
        }
        catch (Exception e) {
            Logger.e((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void downloadFile(String url, String filePath, ResultCallback callback) {
        try {
            URL parsedUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)parsedUrl.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setUseCaches(true);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.addRequestProperty("Connection", "Keep-Alive");
            connection.connect();
            if (connection.getResponseCode() == 200) {
                int len;
                File descFile = new File(filePath);
                FileOutputStream fos = new FileOutputStream(descFile);
                byte[] buffer = new byte[1024];
                InputStream inputStream = connection.getInputStream();
                while ((len = inputStream.read(buffer)) != -1) {
                    fos.write(buffer, 0, len);
                }
            } else {
                Logger.e((Object)"download failure");
            }
            connection.disconnect();
        }
        catch (Exception e) {
            Logger.e((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void uploadFile(String url, String filePath, HashMap paramsMap, ResultCallback callback) {
        try {
            int bytesRead;
            File file = new File(filePath);
            URL parsedUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)parsedUrl.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("Accept-Charset", "UTF-8");
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=*****");
            String name = file.getName();
            DataOutputStream requestStream = new DataOutputStream(connection.getOutputStream());
            requestStream.writeBytes("--*****\r\n");
            StringBuilder tempParams = new StringBuilder();
            tempParams.append("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + name + "\"; ");
            int pos = 0;
            int size = paramsMap.size();
            for (Object key : paramsMap.keySet()) {
                tempParams.append(String.format("%s=\"%s\"", key, paramsMap.get(key), "UTF-8"));
                if (pos < size - 1) {
                    tempParams.append("; ");
                }
                ++pos;
            }
            tempParams.append("\r\n");
            tempParams.append("Content-Type: application/octet-stream\r\n");
            tempParams.append("\r\n");
            String params = tempParams.toString();
            requestStream.writeBytes(params);
            FileInputStream fileInput = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            while ((bytesRead = in.read(buffer)) != -1) {
                requestStream.write(buffer, 0, bytesRead);
            }
            requestStream.writeBytes("\r\n");
            requestStream.flush();
            requestStream.writeBytes("--*****--\r\n");
            requestStream.flush();
            fileInput.close();
            int statusCode = connection.getResponseCode();
            if (statusCode == 200) {
                String result = HttpHelper.streamToString(connection.getInputStream());
                Logger.i((Object)("upload success, result: " + result));
            } else {
                Logger.e((Object)"upload failure");
            }
        }
        catch (IOException e) {
            Logger.e((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void failureCallback(final String tag, final Throwable t, final ResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(tag, t);
            }
        });
    }

    public static void successCallback(final String tag, final Object o, final ResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                callback.onResponse(tag, o);
            }
        });
    }
}

