/*
 * Decompiled with CFR 0.152.
 */
package com.rx2androidnetworking;

import android.net.TrafficStats;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.common.ANResponse;
import com.androidnetworking.common.ConnectionClassManager;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.AnalyticsListener;
import com.androidnetworking.internal.InternalNetworking;
import com.androidnetworking.internal.RequestProgressBody;
import com.androidnetworking.internal.ResponseProgressBody;
import com.androidnetworking.utils.SourceCloseUtil;
import com.androidnetworking.utils.Utils;
import com.rx2androidnetworking.Rx2ANRequest;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.plugins.RxJavaPlugins;
import java.io.File;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class Rx2InternalNetworking {
    public static <T> Observable<T> generateSimpleObservable(Rx2ANRequest request) {
        Request.Builder builder = new Request.Builder().url(request.getUrl());
        InternalNetworking.addHeadersToRequestBuilder((Request.Builder)builder, (ANRequest)request);
        switch (request.getMethod()) {
            case 0: {
                builder = builder.get();
                break;
            }
            case 1: {
                RequestBody requestBody = request.getRequestBody();
                builder = builder.post(requestBody);
                break;
            }
            case 2: {
                RequestBody requestBody = request.getRequestBody();
                builder = builder.put(requestBody);
                break;
            }
            case 3: {
                RequestBody requestBody = request.getRequestBody();
                builder = builder.delete(requestBody);
                break;
            }
            case 4: {
                builder = builder.head();
                break;
            }
            case 6: {
                builder = builder.method("OPTIONS", null);
                break;
            }
            case 5: {
                RequestBody requestBody = request.getRequestBody();
                builder = builder.patch(requestBody);
            }
        }
        if (request.getCacheControl() != null) {
            builder.cacheControl(request.getCacheControl());
        }
        Request okHttpRequest = builder.build();
        if (request.getOkHttpClient() != null) {
            request.setCall(request.getOkHttpClient().newBuilder().cache(InternalNetworking.sHttpClient.cache()).build().newCall(okHttpRequest));
        } else {
            request.setCall(InternalNetworking.sHttpClient.newCall(okHttpRequest));
        }
        return new SimpleANObservable(request);
    }

    public static <T> Observable<T> generateDownloadObservable(final Rx2ANRequest request) {
        Request.Builder builder = new Request.Builder().url(request.getUrl());
        InternalNetworking.addHeadersToRequestBuilder((Request.Builder)builder, (ANRequest)request);
        builder = builder.get();
        if (request.getCacheControl() != null) {
            builder.cacheControl(request.getCacheControl());
        }
        Request okHttpRequest = builder.build();
        OkHttpClient okHttpClient = request.getOkHttpClient() != null ? request.getOkHttpClient().newBuilder().cache(InternalNetworking.sHttpClient.cache()).addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ResponseProgressBody(originalResponse.body(), request.getDownloadProgressListener())).build();
            }
        }).build() : InternalNetworking.sHttpClient.newBuilder().addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ResponseProgressBody(originalResponse.body(), request.getDownloadProgressListener())).build();
            }
        }).build();
        request.setCall(okHttpClient.newCall(okHttpRequest));
        return new DownloadANObservable(request);
    }

    public static <T> Observable<T> generateMultipartObservable(Rx2ANRequest request) {
        return new MultipartANObservable(request);
    }

    private static final class ANDisposable
    implements Disposable {
        private final Call call;

        private ANDisposable(Call call) {
            this.call = call;
        }

        public void dispose() {
            this.call.cancel();
        }

        public boolean isDisposed() {
            return this.call.isCanceled();
        }
    }

    static final class MultipartANObservable<T>
    extends Observable<T> {
        private final Rx2ANRequest request;

        MultipartANObservable(Rx2ANRequest request) {
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected void subscribeActual(Observer<? super T> observer) {
            block29: {
                boolean doNotSwallowError = false;
                Response okHttpResponse = null;
                try {
                    Request.Builder builder = new Request.Builder().url(this.request.getUrl());
                    InternalNetworking.addHeadersToRequestBuilder((Request.Builder)builder, (ANRequest)this.request);
                    RequestBody requestBody = this.request.getMultiPartRequestBody();
                    long requestBodyLength = requestBody.contentLength();
                    builder = builder.post((RequestBody)new RequestProgressBody(requestBody, this.request.getUploadProgressListener()));
                    if (this.request.getCacheControl() != null) {
                        builder.cacheControl(this.request.getCacheControl());
                    }
                    Request okHttpRequest = builder.build();
                    if (this.request.getOkHttpClient() != null) {
                        this.request.setCall(this.request.getOkHttpClient().newBuilder().cache(InternalNetworking.sHttpClient.cache()).build().newCall(okHttpRequest));
                    } else {
                        this.request.setCall(InternalNetworking.sHttpClient.newCall(okHttpRequest));
                    }
                    observer.onSubscribe((Disposable)new ANDisposable(this.request.getCall()));
                    long startTime = System.currentTimeMillis();
                    okHttpResponse = this.request.getCall().execute();
                    long timeTaken = System.currentTimeMillis() - startTime;
                    if (this.request.getAnalyticsListener() != null) {
                        if (okHttpResponse.cacheResponse() == null) {
                            Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)requestBodyLength, (long)okHttpResponse.body().contentLength(), (boolean)false);
                        } else if (okHttpResponse.networkResponse() == null) {
                            Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)0L, (long)0L, (boolean)true);
                        } else {
                            Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)(requestBodyLength != 0L ? requestBodyLength : -1L), (long)0L, (boolean)true);
                        }
                    }
                    if (okHttpResponse.code() >= 400) {
                        if (!this.request.getCall().isCanceled()) {
                            observer.onError((Throwable)Utils.getErrorForServerResponse((ANError)new ANError(okHttpResponse), (ANRequest)this.request, (int)okHttpResponse.code()));
                        }
                    } else {
                        ANResponse response = this.request.parseResponse(okHttpResponse);
                        if (!response.isSuccess()) {
                            if (!this.request.getCall().isCanceled()) {
                                observer.onError((Throwable)response.getError());
                            }
                        } else {
                            if (!this.request.getCall().isCanceled()) {
                                observer.onNext(response.getResult());
                            }
                            if (!this.request.getCall().isCanceled()) {
                                doNotSwallowError = true;
                                observer.onComplete();
                            }
                        }
                    }
                    SourceCloseUtil.close((Response)okHttpResponse, (ANRequest)this.request);
                }
                catch (IOException ioe) {
                    if (!this.request.getCall().isCanceled()) {
                        observer.onError((Throwable)Utils.getErrorForConnection((ANError)new ANError((Throwable)ioe)));
                    }
                }
                catch (Exception e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    if (doNotSwallowError) {
                        RxJavaPlugins.onError((Throwable)e);
                    } else if (!this.request.getCall().isCanceled()) {
                        try {
                            observer.onError((Throwable)Utils.getErrorForConnection((ANError)new ANError((Throwable)e)));
                        }
                        catch (Exception e1) {
                            Exceptions.throwIfFatal((Throwable)e1);
                            RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{e, e1}));
                        }
                    }
                    break block29;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    SourceCloseUtil.close(okHttpResponse, (ANRequest)this.request);
                }
            }
        }
    }

    static final class DownloadANObservable<T>
    extends Observable<T> {
        private final Rx2ANRequest request;
        private final Call originalCall;

        DownloadANObservable(Rx2ANRequest request) {
            this.request = request;
            this.originalCall = request.getCall();
        }

        protected void subscribeActual(Observer<? super T> observer) {
            block18: {
                Call call = this.originalCall.clone();
                observer.onSubscribe((Disposable)new ANDisposable(call));
                boolean doNotSwallowError = false;
                try {
                    long startTime = System.currentTimeMillis();
                    long startBytes = TrafficStats.getTotalRxBytes();
                    Response okHttpResponse = this.request.getCall().execute();
                    Utils.saveFile((Response)okHttpResponse, (String)this.request.getDirPath(), (String)this.request.getFileName());
                    long timeTaken = System.currentTimeMillis() - startTime;
                    if (okHttpResponse.cacheResponse() == null) {
                        long finalBytes = TrafficStats.getTotalRxBytes();
                        long diffBytes = startBytes == -1L || finalBytes == -1L ? okHttpResponse.body().contentLength() : finalBytes - startBytes;
                        ConnectionClassManager.getInstance().updateBandwidth(diffBytes, timeTaken);
                        Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)-1L, (long)okHttpResponse.body().contentLength(), (boolean)false);
                    } else if (this.request.getAnalyticsListener() != null) {
                        Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)-1L, (long)0L, (boolean)true);
                    }
                    if (okHttpResponse.code() >= 400) {
                        if (!call.isCanceled()) {
                            observer.onError((Throwable)Utils.getErrorForServerResponse((ANError)new ANError(okHttpResponse), (ANRequest)this.request, (int)okHttpResponse.code()));
                        }
                    } else {
                        if (!call.isCanceled()) {
                            ANResponse response = ANResponse.success((Object)"success");
                            observer.onNext(response.getResult());
                        }
                        if (!call.isCanceled()) {
                            doNotSwallowError = true;
                            observer.onComplete();
                        }
                    }
                }
                catch (IOException ioe) {
                    try {
                        File destinationFile = new File(this.request.getDirPath() + File.separator + this.request.getFileName());
                        if (destinationFile.exists()) {
                            destinationFile.delete();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!call.isCanceled()) {
                        observer.onError((Throwable)Utils.getErrorForConnection((ANError)new ANError((Throwable)ioe)));
                    }
                }
                catch (Exception e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    if (doNotSwallowError) {
                        RxJavaPlugins.onError((Throwable)e);
                    }
                    if (call.isCanceled()) break block18;
                    try {
                        observer.onError((Throwable)Utils.getErrorForConnection((ANError)new ANError((Throwable)e)));
                    }
                    catch (Exception e1) {
                        Exceptions.throwIfFatal((Throwable)e1);
                        RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{e, e1}));
                    }
                }
            }
        }
    }

    static final class SimpleANObservable<T>
    extends Observable<T> {
        private Rx2ANRequest request;
        private final Call originalCall;

        SimpleANObservable(Rx2ANRequest request) {
            this.request = request;
            this.originalCall = request.getCall();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected void subscribeActual(Observer<? super T> observer) {
            Response okHttpResponse;
            block19: {
                Call call = this.originalCall.clone();
                observer.onSubscribe((Disposable)new ANDisposable(call));
                boolean doNotSwallowError = false;
                okHttpResponse = null;
                try {
                    long startTime = System.currentTimeMillis();
                    long startBytes = TrafficStats.getTotalRxBytes();
                    okHttpResponse = call.execute();
                    long timeTaken = System.currentTimeMillis() - startTime;
                    if (okHttpResponse.cacheResponse() == null) {
                        long finalBytes = TrafficStats.getTotalRxBytes();
                        long diffBytes = startBytes == -1L || finalBytes == -1L ? okHttpResponse.body().contentLength() : finalBytes - startBytes;
                        ConnectionClassManager.getInstance().updateBandwidth(diffBytes, timeTaken);
                        Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)(this.request.getRequestBody() != null && this.request.getRequestBody().contentLength() != 0L ? this.request.getRequestBody().contentLength() : -1L), (long)okHttpResponse.body().contentLength(), (boolean)false);
                    } else if (this.request.getAnalyticsListener() != null) {
                        if (okHttpResponse.networkResponse() == null) {
                            Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)0L, (long)0L, (boolean)true);
                        } else {
                            Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)(this.request.getRequestBody() != null && this.request.getRequestBody().contentLength() != 0L ? this.request.getRequestBody().contentLength() : -1L), (long)0L, (boolean)true);
                        }
                    }
                    if (okHttpResponse.code() >= 400) {
                        if (!call.isCanceled()) {
                            observer.onError((Throwable)Utils.getErrorForServerResponse((ANError)new ANError(okHttpResponse), (ANRequest)this.request, (int)okHttpResponse.code()));
                        }
                        break block19;
                    }
                    ANResponse response = this.request.parseResponse(okHttpResponse);
                    if (!response.isSuccess()) {
                        if (!call.isCanceled()) {
                            observer.onError((Throwable)response.getError());
                        }
                        break block19;
                    }
                    if (!call.isCanceled()) {
                        observer.onNext(response.getResult());
                    }
                    if (call.isCanceled()) break block19;
                    doNotSwallowError = true;
                    observer.onComplete();
                }
                catch (IOException ioe) {
                    block20: {
                        if (call.isCanceled()) break block20;
                        observer.onError((Throwable)Utils.getErrorForConnection((ANError)new ANError((Throwable)ioe)));
                    }
                    SourceCloseUtil.close((Response)okHttpResponse, (ANRequest)this.request);
                }
                catch (Exception e) {
                    block21: {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (doNotSwallowError) {
                            RxJavaPlugins.onError((Throwable)e);
                            break block21;
                        }
                        if (call.isCanceled()) break block21;
                        try {
                            observer.onError((Throwable)Utils.getErrorForConnection((ANError)new ANError((Throwable)e)));
                        }
                        catch (Exception e1) {
                            Exceptions.throwIfFatal((Throwable)e1);
                            RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{e, e1}));
                        }
                        {
                            catch (Throwable throwable) {
                                SourceCloseUtil.close(okHttpResponse, (ANRequest)this.request);
                                throw throwable;
                            }
                        }
                    }
                    SourceCloseUtil.close((Response)okHttpResponse, (ANRequest)this.request);
                }
            }
            SourceCloseUtil.close((Response)okHttpResponse, (ANRequest)this.request);
        }
    }
}

